/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor.editpart;

import java.util.List;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.drools.eclipse.flow.common.editor.core.ModelEvent;
import org.drools.eclipse.flow.common.editor.core.ModelListener;
import org.drools.eclipse.flow.common.editor.core.ProcessWrapper;
import org.drools.eclipse.flow.common.editor.editpart.ElementEditPart;
import org.drools.eclipse.flow.common.editor.editpart.figure.ElementFigure;
import org.drools.eclipse.flow.common.editor.policy.ElementContainerLayoutEditPolicy;
import org.eclipse.draw2d.Animation;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FanRouter;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.ShortestPathConnectionRouter;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;

public class ProcessEditPart
extends AbstractGraphicalEditPart
implements ModelListener {
    protected IFigure createFigure() {
        Figure f = new Figure();
        f.setLayoutManager((LayoutManager)new XYLayout());
        return f;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("NodeEditPolicy", null);
        this.installEditPolicy("GraphicalNodeEditPolicy", null);
        this.installEditPolicy("Selection Feedback", null);
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ElementContainerLayoutEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
    }

    protected List getModelChildren() {
        return this.getProcessWrapper().getElements();
    }

    public ProcessWrapper getProcessWrapper() {
        return (ProcessWrapper)this.getModel();
    }

    public void activate() {
        super.activate();
        ((ProcessWrapper)this.getModel()).addListener(this);
    }

    public void deactivate() {
        ((ProcessWrapper)this.getModel()).removeListener(this);
        super.deactivate();
    }

    public void modelChanged(ModelEvent event) {
        if (event.getChange() == 1) {
            this.refreshChildren();
        } else if (event.getChange() == 2) {
            this.refreshVisuals();
        }
    }

    public Object getAdapter(Class adapter) {
        Boolean val;
        if (adapter == SnapToHelper.class && (val = (Boolean)this.getViewer().getProperty("SnapToGrid.isEnabled")) != null && val.booleanValue()) {
            return new SnapToGrid((GraphicalEditPart)this);
        }
        return super.getAdapter(adapter);
    }

    protected void refreshVisuals() {
        Animation.markBegin();
        ConnectionLayer layer = (ConnectionLayer)this.getLayer("Connection Layer");
        if ((this.getViewer().getControl().getStyle() & 0x8000000) == 0) {
            layer.setAntialias(1);
        }
        if (this.getProcessWrapper().getRouterLayout().equals(ProcessWrapper.ROUTER_LAYOUT_MANUAL)) {
            FanRouter router = new FanRouter();
            router.setNextRouter((ConnectionRouter)new BendpointConnectionRouter());
            layer.setConnectionRouter((ConnectionRouter)router);
        } else if (this.getProcessWrapper().getRouterLayout().equals(ProcessWrapper.ROUTER_LAYOUT_MANHATTAN)) {
            layer.setConnectionRouter((ConnectionRouter)new ManhattanConnectionRouter());
        } else {
            layer.setConnectionRouter((ConnectionRouter)new ShortestPathConnectionRouter(this.getFigure()));
        }
        Animation.run((int)400);
    }

    public boolean setTableModelBounds() {
        List tableParts = this.getChildren();
        for (ElementEditPart elementEditPart : tableParts) {
            ElementFigure elementFigure = (ElementFigure)elementEditPart.getFigure();
            if (elementFigure == null) continue;
            Rectangle constraint = elementFigure.getBounds().getCopy();
            ElementWrapper elementWrapper = elementEditPart.getElementWrapper();
            elementWrapper.setConstraint(constraint);
        }
        return true;
    }
}

