/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.view.property.constraint;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.definition.process.Connection;
import org.drools.eclipse.flow.common.view.property.EditBeanDialog;
import org.drools.eclipse.flow.ruleflow.view.property.constraint.RuleFlowConstraintDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jbpm.workflow.core.Constraint;
import org.jbpm.workflow.core.WorkflowProcess;
import org.jbpm.workflow.core.impl.ConnectionRef;
import org.jbpm.workflow.core.node.StateNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateConstraintListDialog
extends EditBeanDialog<Map<ConnectionRef, Constraint>> {
    private WorkflowProcess process;
    private StateNode stateNode;
    private Map<ConnectionRef, Constraint> newMap;
    private Map<Connection, Label> labels = new HashMap<Connection, Label>();

    protected StateConstraintListDialog(Shell parentShell, WorkflowProcess process, StateNode stateNode) {
        super(parentShell, "Edit Constraints");
        this.process = process;
        this.stateNode = stateNode;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        List outgoingConnections = this.stateNode.getOutgoingConnections("DROOLS_DEFAULT");
        this.labels.clear();
        for (Connection outgoingConnection : outgoingConnections) {
            Label label1 = new Label(composite, 0);
            label1.setText("To node " + outgoingConnection.getTo().getName() + ": ");
            Label label2 = new Label(composite, 0);
            this.labels.put(outgoingConnection, label2);
            GridData gridData = new GridData();
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalAlignment = 4;
            label2.setLayoutData((Object)gridData);
            Constraint constraint = this.newMap.get(new ConnectionRef(outgoingConnection.getTo().getId(), outgoingConnection.getToType()));
            if (constraint != null) {
                label2.setText(constraint.getName());
            }
            Button editButton = new Button(composite, 0);
            editButton.setText("Edit");
            editButton.addSelectionListener((SelectionListener)new EditButtonListener(outgoingConnection));
        }
        return composite;
    }

    @Override
    public void setValue(Map<ConnectionRef, Constraint> value) {
        super.setValue(value);
        this.newMap = new HashMap<ConnectionRef, Constraint>(value);
    }

    @Override
    protected Map<ConnectionRef, Constraint> updateValue(Map<ConnectionRef, Constraint> value) {
        return this.newMap;
    }

    private void editItem(final Connection connection) {
        Runnable r = new Runnable(){

            public void run() {
                RuleFlowConstraintDialog dialog = new RuleFlowConstraintDialog(StateConstraintListDialog.this.getShell(), StateConstraintListDialog.this.process);
                dialog.create();
                ConnectionRef connectionRef = new ConnectionRef(connection.getTo().getId(), connection.getToType());
                Constraint constraint = (Constraint)StateConstraintListDialog.this.newMap.get(connectionRef);
                dialog.setConstraint(constraint);
                dialog.fixType(0);
                dialog.fixDialect(0);
                int code = dialog.open();
                if (code != 1) {
                    constraint = dialog.getConstraint();
                    StateConstraintListDialog.this.newMap.put(connectionRef, constraint);
                    StateConstraintListDialog.this.setConnectionText((Label)StateConstraintListDialog.this.labels.get(connection), constraint.getName());
                }
            }
        };
        r.run();
    }

    private void setConnectionText(final Label connection, final String name) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                connection.setText(name);
            }
        });
    }

    private class EditButtonListener
    extends SelectionAdapter {
        private Connection connection;

        public EditButtonListener(Connection connection) {
            this.connection = connection;
        }

        public void widgetSelected(SelectionEvent e) {
            StateConstraintListDialog.this.editItem(this.connection);
        }
    }
}

