/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.preferences;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.eclipse.preferences.DroolsRuntimeDialog;
import org.drools.eclipse.util.DroolsRuntime;
import org.drools.eclipse.util.DroolsRuntimeManager;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class DroolsRuntimesBlock
implements ISelectionProvider {
    private Composite fControl;
    private List<DroolsRuntime> droolsRuntimes = new ArrayList<DroolsRuntime>();
    private CheckboxTableViewer droolsRuntimesList;
    private Button fAddButton;
    private Button fRemoveButton;
    private Button fEditButton;
    private ListenerList fSelectionListeners = new ListenerList();
    private ISelection fPrevSelection = new StructuredSelection();
    private Table fTable;

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        return new StructuredSelection(this.droolsRuntimesList.getCheckedElements());
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.equals(this.fPrevSelection)) {
            this.fPrevSelection = selection;
            Object runtime = ((IStructuredSelection)selection).getFirstElement();
            if (runtime == null) {
                this.droolsRuntimesList.setCheckedElements(new Object[0]);
            } else {
                this.droolsRuntimesList.setCheckedElements(new Object[]{runtime});
                this.droolsRuntimesList.reveal(runtime);
            }
            this.fireSelectionChanged();
        }
    }

    private void fireSelectionChanged() {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        Object[] listeners = this.fSelectionListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
            listener.selectionChanged(event);
            ++i;
        }
    }

    public void createControl(Composite ancestor) {
        Composite parent;
        Font font = ancestor.getFont();
        this.fControl = parent = SWTFactory.createComposite((Composite)ancestor, (Font)font, (int)2, (int)1, (int)1808);
        SWTFactory.createLabel((Composite)parent, (String)"Installed Drools Runtimes", (int)2);
        this.fTable = new Table(parent, 67618);
        GridData gd = new GridData(1808);
        gd.heightHint = 250;
        gd.widthHint = 350;
        this.fTable.setLayoutData((Object)gd);
        this.fTable.setFont(font);
        this.fTable.setHeaderVisible(true);
        this.fTable.setLinesVisible(true);
        TableColumn column = new TableColumn(this.fTable, 0);
        column.setText("Name");
        int defaultwidth = 176;
        column.setWidth(defaultwidth);
        column = new TableColumn(this.fTable, 0);
        column.setText("Location");
        column.setWidth(defaultwidth);
        this.droolsRuntimesList = new CheckboxTableViewer(this.fTable);
        this.droolsRuntimesList.setLabelProvider((IBaseLabelProvider)new DroolsRuntimesLabelProvider());
        this.droolsRuntimesList.setContentProvider((IContentProvider)new DroolsRuntimesContentProvider());
        this.droolsRuntimesList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent evt) {
                DroolsRuntimesBlock.this.enableButtons();
            }
        });
        this.droolsRuntimesList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    DroolsRuntimesBlock.this.setDefaultDroolsRuntime((DroolsRuntime)event.getElement());
                } else {
                    DroolsRuntimesBlock.this.setDefaultDroolsRuntime(null);
                }
            }
        });
        this.droolsRuntimesList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                if (!DroolsRuntimesBlock.this.droolsRuntimesList.getSelection().isEmpty()) {
                    DroolsRuntimesBlock.this.editDroolsRuntime();
                }
            }
        });
        this.fTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0 && DroolsRuntimesBlock.this.fRemoveButton.isEnabled()) {
                    DroolsRuntimesBlock.this.removeDroolsRuntimes();
                }
            }
        });
        Composite buttons = SWTFactory.createComposite((Composite)parent, (Font)font, (int)1, (int)1, (int)2, (int)0, (int)0);
        this.fAddButton = SWTFactory.createPushButton((Composite)buttons, (String)"Add...", null);
        this.fAddButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                DroolsRuntimesBlock.this.addDroolsRuntime();
            }
        });
        this.fEditButton = SWTFactory.createPushButton((Composite)buttons, (String)"Edit...", null);
        this.fEditButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                DroolsRuntimesBlock.this.editDroolsRuntime();
            }
        });
        this.fRemoveButton = SWTFactory.createPushButton((Composite)buttons, (String)"Remove", null);
        this.fRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                DroolsRuntimesBlock.this.removeDroolsRuntimes();
            }
        });
        SWTFactory.createVerticalSpacer((Composite)parent, (int)1);
        this.enableButtons();
        this.fAddButton.setEnabled(true);
    }

    private void enableButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.droolsRuntimesList.getSelection();
        int selectionCount = selection.size();
        this.fEditButton.setEnabled(selectionCount == 1);
        this.fRemoveButton.setEnabled(selectionCount > 0);
    }

    public Control getControl() {
        return this.fControl;
    }

    public void setDroolsRuntimes(DroolsRuntime[] runtimes) {
        this.droolsRuntimes.clear();
        int i = 0;
        while (i < runtimes.length) {
            this.droolsRuntimes.add(runtimes[i]);
            ++i;
        }
        this.droolsRuntimesList.setInput(this.droolsRuntimes);
        this.droolsRuntimesList.refresh();
    }

    public DroolsRuntime[] getDroolsRuntimes() {
        DroolsRuntime selected = this.getDefaultDroolsRuntime();
        for (DroolsRuntime runtime : this.droolsRuntimes) {
            runtime.setDefault(runtime.equals(selected));
        }
        return this.droolsRuntimes.toArray(new DroolsRuntime[this.droolsRuntimes.size()]);
    }

    private void addDroolsRuntime() {
        DroolsRuntime result;
        DroolsRuntimeDialog dialog = new DroolsRuntimeDialog(this.getShell(), this.droolsRuntimes);
        if (dialog.open() == 0 && (result = dialog.getResult()) != null) {
            DroolsRuntimeManager.recognizeJars(result);
            this.droolsRuntimes.add(result);
            this.droolsRuntimesList.refresh();
            this.droolsRuntimesList.setSelection((ISelection)new StructuredSelection((Object)result));
        }
    }

    private void editDroolsRuntime() {
        DroolsRuntime result;
        IStructuredSelection selection = (IStructuredSelection)this.droolsRuntimesList.getSelection();
        DroolsRuntime runtime = (DroolsRuntime)selection.getFirstElement();
        if (runtime == null) {
            return;
        }
        DroolsRuntimeDialog dialog = new DroolsRuntimeDialog(this.getShell(), this.droolsRuntimes);
        dialog.setDroolsRuntime(runtime);
        if (dialog.open() == 0 && (result = dialog.getResult()) != null) {
            DroolsRuntimeManager.recognizeJars(result);
            int index = this.droolsRuntimes.indexOf(runtime);
            this.droolsRuntimes.remove(index);
            this.droolsRuntimes.add(index, result);
            this.droolsRuntimesList.refresh();
            this.droolsRuntimesList.setSelection((ISelection)new StructuredSelection((Object)result));
        }
    }

    private void removeDroolsRuntimes() {
        IStructuredSelection selection = (IStructuredSelection)this.droolsRuntimesList.getSelection();
        DroolsRuntime[] runtimes = new DroolsRuntime[selection.size()];
        Iterator iter = selection.iterator();
        int i = 0;
        while (iter.hasNext()) {
            runtimes[i] = (DroolsRuntime)iter.next();
            ++i;
        }
        this.removeDroolsRuntimes(runtimes);
    }

    public void removeDroolsRuntimes(DroolsRuntime[] runtimes) {
        IStructuredSelection prev = (IStructuredSelection)this.getSelection();
        int i = 0;
        while (i < runtimes.length) {
            this.droolsRuntimes.remove(runtimes[i]);
            ++i;
        }
        this.droolsRuntimesList.refresh();
        IStructuredSelection curr = (IStructuredSelection)this.getSelection();
        if (!curr.equals(prev)) {
            runtimes = this.getDroolsRuntimes();
            if (curr.size() == 0 && runtimes.length == 1) {
                this.setSelection((ISelection)new StructuredSelection((Object)runtimes[0]));
            } else {
                this.fireSelectionChanged();
            }
        }
    }

    protected Shell getShell() {
        return this.getControl().getShell();
    }

    public void setDefaultDroolsRuntime(DroolsRuntime runtime) {
        if (runtime == null) {
            this.setSelection((ISelection)new StructuredSelection());
        } else {
            this.setSelection((ISelection)new StructuredSelection((Object)runtime));
        }
    }

    public DroolsRuntime getDefaultDroolsRuntime() {
        Object[] objects = this.droolsRuntimesList.getCheckedElements();
        if (objects.length == 0) {
            return null;
        }
        return (DroolsRuntime)objects[0];
    }

    class DroolsRuntimesContentProvider
    implements IStructuredContentProvider {
        DroolsRuntimesContentProvider() {
        }

        public Object[] getElements(Object input) {
            return DroolsRuntimesBlock.this.droolsRuntimes.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    class DroolsRuntimesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        DroolsRuntimesLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof DroolsRuntime) {
                DroolsRuntime runtime = (DroolsRuntime)element;
                switch (columnIndex) {
                    case 0: {
                        return runtime.getName();
                    }
                    case 1: {
                        return runtime.getPath();
                    }
                }
            }
            return element.toString();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

