/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.ui;

import org.drools.eclipse.rulebuilder.modeldriven.HumanReadable;
import org.drools.eclipse.rulebuilder.ui.ActionSetFieldDialog;
import org.drools.eclipse.rulebuilder.ui.NumericKeyFilter;
import org.drools.eclipse.rulebuilder.ui.RuleModeller;
import org.drools.eclipse.rulebuilder.ui.Widget;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.ActionSetField;
import org.drools.ide.common.client.modeldriven.brl.ActionUpdateField;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class ActionSetFieldWidget
extends Widget {
    private ActionSetField set;
    private final String[] fieldCompletions;
    private boolean isBoundFact = false;
    private String variableClass;

    public ActionSetFieldWidget(FormToolkit toolkit, Composite parent, RuleModeller mod, RuleModel rule, ActionSetField set, int index) {
        super(parent, toolkit, mod, index);
        this.set = set;
        if (this.getCompletion().isGlobalVariable(set.variable)) {
            this.fieldCompletions = this.getCompletion().getFieldCompletionsForGlobalVariable(set.variable);
            this.variableClass = this.getCompletion().getGlobalVariable(set.variable);
        } else {
            FactPattern pattern = rule.getLHSBoundFact(set.variable);
            this.fieldCompletions = this.getCompletion().getFieldCompletions(pattern.getFactType());
            this.isBoundFact = true;
            this.variableClass = pattern.getFactType();
        }
        GridLayout l = new GridLayout();
        l.numColumns = 6;
        l.marginBottom = 0;
        l.marginHeight = 0;
        l.marginLeft = 0;
        l.marginRight = 0;
        l.marginTop = 0;
        l.marginWidth = 0;
        l.verticalSpacing = 0;
        parent.setLayout((Layout)l);
        this.create();
    }

    private void create() {
        String modifyType = "set";
        if (this.set instanceof ActionUpdateField) {
            modifyType = "modify";
        }
        this.toolkit.createLabel(this.parent, String.valueOf(HumanReadable.getActionDisplayName(modifyType)) + " [" + this.set.variable + "]");
        this.addDeleteRHSAction();
        this.addMoreOptionsAction();
        this.addRows();
    }

    private void addRows() {
        Composite constraintComposite = this.toolkit.createComposite(this.parent);
        GridLayout constraintLayout = new GridLayout();
        constraintLayout.numColumns = 3;
        constraintComposite.setLayout((Layout)constraintLayout);
        int i = 0;
        while (i < this.set.fieldValues.length) {
            ActionFieldValue val = this.set.fieldValues[i];
            this.toolkit.createLabel(constraintComposite, val.field);
            this.valueEditor(constraintComposite, val);
            this.addRemoveFieldAction(constraintComposite, i);
            ++i;
        }
        this.toolkit.paintBordersFor(constraintComposite);
    }

    private void addMoreOptionsAction() {
        ImageHyperlink link = this.addImage(this.parent, "icons/new_item.gif");
        link.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                ActionSetFieldDialog popup = new ActionSetFieldDialog(ActionSetFieldWidget.this.parent.getShell(), ActionSetFieldWidget.this.getModeller(), ActionSetFieldWidget.this.set, ActionSetFieldWidget.this.fieldCompletions, ActionSetFieldWidget.this.variableClass);
                popup.open();
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        link.setToolTipText("Add a field");
    }

    private void addRemoveFieldAction(Composite constraintComposite, final int currentRow) {
        ImageHyperlink delLink = this.addImage(constraintComposite, "icons/delete_item_small.gif");
        delLink.setToolTipText("Remove this field action");
        delLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                MessageBox dialog = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                dialog.setMessage("Remove this item?");
                dialog.setText("Remove this item?");
                if (dialog.open() == 64) {
                    ActionSetFieldWidget.this.set.removeField(currentRow);
                    ActionSetFieldWidget.this.getModeller().setDirty(true);
                    ActionSetFieldWidget.this.getModeller().reloadRhs();
                }
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
    }

    private void valueEditor(Composite parent, final ActionFieldValue val) {
        final Text box = this.toolkit.createText(parent, "");
        if (val.value != null) {
            box.setText(val.value);
        }
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.minimumWidth = 100;
        box.setLayoutData((Object)gd);
        box.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                val.value = box.getText();
                ActionSetFieldWidget.this.getModeller().setDirty(true);
            }
        });
        if (val.type.equals("Numeric")) {
            new NumericKeyFilter(box);
        }
    }

    private SuggestionCompletionEngine getCompletion() {
        return this.getModeller().getSuggestionCompletionEngine();
    }
}

