/*
 * Decompiled with CFR 0.152.
 */
package org.drools.contrib;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.MatchingTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuvnorJRClusterConfigAntTask
extends MatchingTask {
    private String verbose;
    private String nodecount;
    private String nodenames;
    private String destinationdir;
    private String dbtype;
    private String dbdriver;
    private String dburl;
    private String dbuser;
    private String dbpasswd;
    private String journalsyncdelay;
    private String journaldbdriver;
    private String journaldburl;
    private String journaldbuser;
    private String journaldbpasswd;
    private List<String> nodes = new ArrayList<String>();
    private Map<String, Map<String, Object>> repoTemplateDataMap = new HashMap<String, Map<String, Object>>();
    private List<String> availDbTypes = Arrays.asList("mssql", "mysql", "oracle10g", "oracle11", "oracle9i", "postgresql");
    private int nodeCountVal;
    private int journalSyncDelayVal;
    private boolean verboseVal;

    public void execute() throws BuildException {
        super.execute();
        this.verboseVal = this.verbose != null && this.verbose.equalsIgnoreCase("true");
        String inputErrors = this.checkInput();
        if (inputErrors.length() > 0) {
            throw new BuildException(inputErrors);
        }
        this.createConfigDirectoryStructure();
        this.setupRepositoryTemplateData();
        for (Map.Entry<String, Map<String, Object>> entry : this.repoTemplateDataMap.entrySet()) {
            this.createConfigEntries(entry.getKey(), entry.getValue());
        }
    }

    private void createConfigEntries(String node, Map<String, Object> data) {
        String repositoryConfig = this.processTemplate(this.dbtype + "-repository.xml", data);
        try {
            boolean success;
            File repoFile = new File(this.destinationdir + "jrcluster/" + node + "/repository.xml");
            if (!repoFile.exists() && !(success = repoFile.createNewFile())) {
                throw new BuildException("Unable to create file [" + repoFile.getPath() + "]");
            }
            FileOutputStream fosr = new FileOutputStream(repoFile);
            fosr.write(repositoryConfig.getBytes());
            fosr.flush();
            fosr.close();
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage());
        }
    }

    private void setupRepositoryTemplateData() {
        for (String node : this.nodes) {
            HashMap<String, String> nodeMap = new HashMap<String, String>();
            nodeMap.put("nodeID", node);
            nodeMap.put("dbType", this.dbtype);
            nodeMap.put("dbDriver", this.dbdriver);
            nodeMap.put("dbUrl", this.dburl);
            nodeMap.put("dbUser", this.dbuser);
            nodeMap.put("dbPass", this.dbpasswd);
            nodeMap.put("journalSyncDelay", this.journalsyncdelay);
            nodeMap.put("journalDriver", this.journaldbdriver);
            nodeMap.put("journalUrl", this.journaldburl);
            nodeMap.put("journalUser", this.journaldbuser);
            nodeMap.put("journalPass", this.journaldbpasswd);
            this.repoTemplateDataMap.put(node, nodeMap);
        }
    }

    private void createConfigDirectoryStructure() {
        boolean success;
        if (!this.destinationdir.endsWith("/")) {
            this.destinationdir = this.destinationdir + "/";
        }
        if (!(success = new File(this.destinationdir + "jrcluster").mkdir())) {
            throw new BuildException("Unable to create directory: [" + this.destinationdir + "jrcluster/]");
        }
        for (int i = 0; i < this.nodeCountVal; ++i) {
            success = new File(this.destinationdir + "jrcluster/" + this.nodes.get(i)).mkdirs();
            if (success) continue;
            throw new BuildException("Unable to create directory: [" + this.destinationdir + "jrcluster/" + this.nodes.get(i) + "]");
        }
    }

    private String checkInput() {
        String errors = "";
        if (this.nodecount == null) {
            errors = errors + "\nInvalid node count.";
        }
        try {
            this.nodeCountVal = Integer.parseInt(this.nodecount);
            if (this.nodeCountVal <= 0) {
                errors = errors + "\nNode count must be greater than zero.";
            }
        }
        catch (NumberFormatException e) {
            errors = errors + "\nNode count is not a number";
        }
        if (this.destinationdir == null) {
            errors = errors + "\nInvalid destination directory.";
        }
        if (this.dbtype == null) {
            errors = errors + "\nInvalid database type.";
        }
        if (!this.availDbTypes.contains(this.dbtype)) {
            errors = errors + "\nInvalid db type [" + this.dbtype + "].";
        }
        if (this.dbdriver == null) {
            errors = errors + "\nInvalid database driver.";
        }
        if (this.dburl == null) {
            errors = errors + "\nInvalid database url.";
        }
        if (this.dbuser == null) {
            errors = errors + "\nInvalid database user.";
        }
        if (this.dbpasswd == null) {
            errors = errors + "\nInvalid database password.";
        }
        if (this.journalsyncdelay == null) {
            errors = errors + "\nInvalid journal sync delay.";
        }
        try {
            this.journalSyncDelayVal = Integer.parseInt(this.journalsyncdelay);
            if (this.journalSyncDelayVal <= 0) {
                errors = errors + "\nJournal sync delay must be greater than zero.";
            }
        }
        catch (NumberFormatException e) {
            errors = errors + "\nJournal sync delay is not a number";
        }
        if (this.journaldbdriver == null) {
            errors = errors + "\nInvalid journal database driver.";
        }
        if (this.journaldburl == null) {
            errors = errors + "\nInvalid journal database url.";
        }
        if (this.journaldbuser == null) {
            errors = errors + "\nInvalid journal database user.";
        }
        if (this.journaldbpasswd == null) {
            errors = errors + "\nInvalid journal database password.";
        }
        if (this.nodenames != null) {
            this.nodes = Arrays.asList(this.nodenames.split(","));
            if (this.nodes.size() != this.nodeCountVal) {
                errors = errors + "\nNumber of node names [" + this.nodes.size() + "] does not match given node count [" + this.nodecount + "]";
            }
        } else {
            for (int i = 0; i < this.nodeCountVal; ++i) {
                if (i < 10) {
                    this.nodes.add("0" + (i + 1));
                    continue;
                }
                this.nodes.add(i + 1 + "");
            }
        }
        return errors;
    }

    private String processTemplate(String name, Map<String, Object> data) {
        if (this.verboseVal) {
            this.log("Processing template [" + name + "] with data: ");
            for (String key : data.keySet()) {
                this.log("\t" + key + " - " + data.get(key));
            }
        }
        try {
            Configuration cfg = new Configuration();
            cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            cfg.setTemplateUpdateDelay(0);
            Template temp = new Template(name, (Reader)new InputStreamReader(GuvnorJRClusterConfigAntTask.class.getResourceAsStream("/jrcluster/templates/repository/" + name)), cfg);
            StringWriter strw = new StringWriter();
            temp.process(data, (Writer)strw);
            return strw.toString();
        }
        catch (Exception e) {
            this.log("Exception processing template: " + e.getMessage());
            return null;
        }
    }

    public void setNodecount(String nodecount) {
        this.nodecount = nodecount;
    }

    public void setNodenames(String nodenames) {
        this.nodenames = nodenames;
    }

    public void setDestinationdir(String destinationdir) {
        this.destinationdir = destinationdir;
    }

    public void setDbtype(String dbtype) {
        this.dbtype = dbtype;
    }

    public void setDbdriver(String dbdriver) {
        this.dbdriver = dbdriver;
    }

    public void setDburl(String dburl) {
        this.dburl = dburl;
    }

    public void setDbuser(String dbuser) {
        this.dbuser = dbuser;
    }

    public void setDbpasswd(String dbpasswd) {
        this.dbpasswd = dbpasswd;
    }

    public void setJournaldbdriver(String journaldbdriver) {
        this.journaldbdriver = journaldbdriver;
    }

    public void setJournaldburl(String journaldburl) {
        this.journaldburl = journaldburl;
    }

    public void setJournaldbuser(String journaldbuser) {
        this.journaldbuser = journaldbuser;
    }

    public void setJournaldbpasswd(String journaldbpasswd) {
        this.journaldbpasswd = journaldbpasswd;
    }

    public void setJournalsyncdelay(String journalsyncdelay) {
        this.journalsyncdelay = journalsyncdelay;
    }

    public void setVerbose(String verbose) {
        this.verbose = verbose;
    }
}

