/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreDocComparator;
import org.apache.lucene.search.SortComparatorSource;

public class LowerCaseSortComparator
implements SortComparatorSource {
    private static final long serialVersionUID = 5396206509020979445L;
    private final SortComparatorSource base;

    public LowerCaseSortComparator(SortComparatorSource base) {
        this.base = base;
    }

    public ScoreDocComparator newComparator(IndexReader reader, String fieldname) throws IOException {
        return new Comparator(this.base.newComparator(reader, fieldname));
    }

    private static final class Comparator
    implements ScoreDocComparator {
        private ScoreDocComparator base;

        private Comparator(ScoreDocComparator base) {
            this.base = base;
        }

        public int compare(ScoreDoc i, ScoreDoc j) {
            return Util.compare(this.sortValue(i), this.sortValue(j));
        }

        public Comparable sortValue(ScoreDoc i) {
            Comparable c = this.base.sortValue(i);
            if (c != null) {
                return c.toString().toLowerCase();
            }
            return null;
        }

        public int sortType() {
            return 9;
        }
    }
}

