/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.core.query.lucene.FilterMultiColumnQueryHits;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQueryHits;
import org.apache.jackrabbit.core.query.lucene.Ordering;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.jackrabbit.spi.Name;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreDocComparator;
import org.apache.lucene.search.SortField;

public class SortedMultiColumnQueryHits
extends FilterMultiColumnQueryHits {
    private final Iterator<ScoreNode[]> it;

    public SortedMultiColumnQueryHits(MultiColumnQueryHits hits, Ordering[] orderings, IndexReader reader) throws IOException {
        super(hits);
        ScoreNode[] next;
        ArrayList<ScoreNode[]> sortedHits = new ArrayList<ScoreNode[]>();
        while ((next = hits.nextScoreNodes()) != null) {
            sortedHits.add(next);
        }
        try {
            Collections.sort(sortedHits, new ScoreNodeComparator(reader, orderings, hits.getSelectorNames()));
        }
        catch (RuntimeException e) {
            throw Util.createIOException(e);
        }
        this.it = sortedHits.iterator();
    }

    public ScoreNode[] nextScoreNodes() throws IOException {
        if (this.it.hasNext()) {
            return this.it.next();
        }
        return null;
    }

    public void skip(int n) throws IOException {
        while (n-- > 0) {
            this.nextScoreNodes();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ScoreNodeComparator
    implements Comparator<ScoreNode[]> {
        private final IndexReader reader;
        private final Ordering[] orderings;
        private final int[] idx;
        private final ScoreDocComparator[] comparators;
        private final boolean[] isReverse;
        private final ScoreDoc doc1 = new ScoreDoc(0, 1.0f);
        private final ScoreDoc doc2 = new ScoreDoc(0, 1.0f);

        private ScoreNodeComparator(IndexReader reader, Ordering[] orderings, Name[] selectorNames) throws IOException {
            this.reader = reader;
            this.orderings = orderings;
            List<Name> names = Arrays.asList(selectorNames);
            this.idx = new int[orderings.length];
            this.comparators = new ScoreDocComparator[orderings.length];
            this.isReverse = new boolean[orderings.length];
            for (int i = 0; i < orderings.length; ++i) {
                this.idx[i] = names.indexOf(orderings[i].getSelectorName());
                SortField sf = orderings[i].getSortField();
                if (sf.getFactory() != null) {
                    this.comparators[i] = sf.getFactory().newComparator(reader, sf.getField());
                }
                this.isReverse[i] = sf.getReverse();
            }
        }

        @Override
        public int compare(ScoreNode[] sn1, ScoreNode[] sn2) {
            for (int i = 0; i < this.orderings.length; ++i) {
                int c;
                int scoreNodeIndex = this.idx[i];
                ScoreNode n1 = sn1[scoreNodeIndex];
                ScoreNode n2 = sn2[scoreNodeIndex];
                if (n1 == n2) continue;
                if (n1 == null) {
                    c = -1;
                } else if (n2 == null) {
                    c = 1;
                } else if (this.comparators[i] != null) {
                    try {
                        this.doc1.doc = n1.getDoc(this.reader);
                        this.doc1.score = n1.getScore();
                        this.doc2.doc = n2.getDoc(this.reader);
                        this.doc2.score = n2.getScore();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                    c = this.comparators[i].compare(this.doc1, this.doc2);
                } else {
                    c = new Float(n1.getScore()).compareTo(Float.valueOf(n2.getScore()));
                }
                if (c == 0) continue;
                if (this.isReverse[i]) {
                    c = -c;
                }
                return c;
            }
            return 0;
        }
    }
}

