/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jsr94.rules.admin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.rules.ObjectFilter;
import javax.rules.admin.RuleExecutionSet;
import org.drools.IntegrationException;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.SessionConfiguration;
import org.drools.StatefulSession;
import org.drools.StatelessSession;
import org.drools.jsr94.rules.Jsr94FactHandleFactory;
import org.drools.jsr94.rules.admin.RuleImpl;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.spi.FactHandleFactory;

public class RuleExecutionSetImpl
implements RuleExecutionSet {
    private static final long serialVersionUID = 510L;
    private String description;
    private String defaultObjectFilterClassName;
    private Map properties;
    private RuleBase ruleBase;
    private Package pkg;
    private ObjectFilter objectFilter;

    RuleExecutionSetImpl(Package pkg, Map properties) throws IntegrationException {
        this.properties = null == properties ? new HashMap() : properties;
        this.pkg = pkg;
        this.description = pkg.getName();
        RuleBaseConfiguration config = (RuleBaseConfiguration)this.properties.get("javax.rules.admin.RuleExecutionSet.ruleBaseConfiguration");
        ReteooRuleBase ruleBase = config != null ? new ReteooRuleBase(null, config, (FactHandleFactory)new Jsr94FactHandleFactory()) : new ReteooRuleBase(null, (FactHandleFactory)new Jsr94FactHandleFactory());
        ruleBase.addPackage(pkg);
        this.ruleBase = ruleBase;
    }

    public synchronized ObjectFilter getObjectFilter() {
        if (this.objectFilter != null) {
            return this.objectFilter;
        }
        if (this.defaultObjectFilterClassName != null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = RuleExecutionSetImpl.class.getClassLoader();
            }
            try {
                Class<?> filterClass = cl.loadClass(this.defaultObjectFilterClassName);
                this.objectFilter = (ObjectFilter)filterClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e.toString());
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e.toString());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e.toString());
            }
        }
        return this.objectFilter;
    }

    public StatefulSession newStatefulSession(SessionConfiguration conf) {
        return this.ruleBase.newStatefulSession(conf, null);
    }

    public StatelessSession newStatelessSession() {
        return this.ruleBase.newStatelessSession();
    }

    public String getName() {
        return this.pkg.getName();
    }

    public String getDescription() {
        return this.description;
    }

    public Object getProperty(Object key) {
        return this.properties.get(key);
    }

    public void setProperty(Object key, Object value) {
        this.properties.put(key, value);
    }

    public void setDefaultObjectFilter(String objectFilterClassname) {
        this.defaultObjectFilterClassName = objectFilterClassname;
    }

    public String getDefaultObjectFilter() {
        return this.defaultObjectFilterClassName;
    }

    public List getRules() {
        ArrayList<RuleImpl> jsr94Rules = new ArrayList<RuleImpl>();
        Rule[] rules = this.pkg.getRules();
        for (int i = 0; i < rules.length; ++i) {
            jsr94Rules.add(new RuleImpl(rules[i]));
        }
        return jsr94Rules;
    }
}

