/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.hornetq;

import java.util.HashMap;
import java.util.Map;
import org.drools.SystemEventListener;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.ClientSession;
import org.jbpm.task.service.SessionWriter;
import org.jbpm.task.service.TaskServerHandler;
import org.jbpm.task.service.TaskService;
import org.jbpm.task.service.hornetq.HornetQSessionWriter;

public class HornetQTaskServerHandler {
    private TaskServerHandler handler;
    private Map<String, ClientProducer> producers;

    public HornetQTaskServerHandler(TaskService service, SystemEventListener systemEventListener) {
        this.handler = new TaskServerHandler(service, systemEventListener);
        this.producers = new HashMap<String, ClientProducer>();
    }

    public void messageReceived(ClientSession session, Object message, String destination) throws Exception {
        ClientProducer producer = this.producers.get(destination);
        if (producer == null) {
            producer = session.createProducer(destination);
            this.producers.put(destination, producer);
        }
        this.handler.messageReceived((SessionWriter)new HornetQSessionWriter(session, producer), message);
    }
}

