/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.iwork;

import org.apache.tika.metadata.Metadata;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class KeynoteContentHandler
extends DefaultHandler {
    public static final String PRESENTATION_WIDTH = "slides-width";
    public static final String PRESENTATION_HEIGHT = "slides-height";
    private final XHTMLContentHandler xhtml;
    private final Metadata metadata;
    private boolean inSlide = false;
    private boolean inTheme = false;
    private boolean inTitle = false;
    private boolean inBody = false;
    private String tableId;
    private Integer numberOfColumns = null;
    private Integer currentColumn = null;
    private boolean inMetadata = false;
    private boolean inMetaDataTitle = false;
    private boolean inMetaDataAuthors = false;
    private boolean inParsableText = false;
    private int numberOfSlides = 0;

    KeynoteContentHandler(XHTMLContentHandler xhtml, Metadata metadata) {
        this.xhtml = xhtml;
        this.metadata = metadata;
    }

    public void endDocument() throws SAXException {
        this.metadata.set("Slide-Count", String.valueOf(this.numberOfSlides));
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("key:theme".equals(qName)) {
            this.inTheme = true;
        } else if ("key:slide".equals(qName)) {
            this.inSlide = true;
            ++this.numberOfSlides;
            this.xhtml.startElement("div");
        } else if ("key:title-placeholder".equals(qName) && this.inSlide) {
            this.inTitle = true;
            this.xhtml.startElement("h1");
        } else if ("sf:sticky-note".equals(qName) && this.inSlide) {
            this.xhtml.startElement("p");
        } else if ("key:notes".equals(qName) && this.inSlide) {
            this.xhtml.startElement("p");
        } else if ("key:body-placeholder".equals(qName) && this.inSlide) {
            this.xhtml.startElement("p");
            this.inBody = true;
        } else if ("key:size".equals(qName) && !this.inTheme) {
            String width = attributes.getValue("sfa:w");
            String height = attributes.getValue("sfa:h");
            this.metadata.set(PRESENTATION_WIDTH, width);
            this.metadata.set(PRESENTATION_HEIGHT, height);
        } else if ("sf:text-body".equals(qName)) {
            this.inParsableText = true;
        } else if ("key:metadata".equals(qName)) {
            this.inMetadata = true;
        } else if (this.inMetadata && "key:title".equals(qName)) {
            this.inMetaDataTitle = true;
        } else if (this.inMetadata && "key:authors".equals(qName)) {
            this.inMetaDataAuthors = true;
        } else if (this.inMetaDataTitle && "key:string".equals(qName)) {
            this.metadata.set("title", attributes.getValue("sfa:string"));
        } else if (this.inMetaDataAuthors && "key:string".equals(qName)) {
            this.metadata.add("Author", attributes.getValue("sfa:string"));
        } else if (this.inSlide && "sf:tabular-model".equals(qName)) {
            this.tableId = attributes.getValue("sfa:ID");
            this.xhtml.startElement("table");
        } else if (this.tableId != null && "sf:columns".equals(qName)) {
            this.numberOfColumns = Integer.parseInt(attributes.getValue("sf:count"));
            this.currentColumn = 0;
        } else if (this.tableId != null && "sf:ct".equals(qName)) {
            this.parseTableData(attributes.getValue("sfa:s"));
        } else if (this.tableId != null && "sf:n".equals(qName)) {
            this.parseTableData(attributes.getValue("sf:v"));
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("key:theme".equals(qName)) {
            this.inTheme = false;
        } else if ("key:slide".equals(qName)) {
            this.inSlide = false;
            this.xhtml.endElement("div");
        } else if ("key:title-placeholder".equals(qName) && this.inSlide) {
            this.inTitle = false;
            this.xhtml.endElement("h1");
        } else if ("sf:sticky-note".equals(qName) && this.inSlide) {
            this.xhtml.endElement("p");
        } else if ("key:notes".equals(qName) && this.inSlide) {
            this.xhtml.endElement("p");
        } else if ("key:body-placeholder".equals(qName) && this.inSlide) {
            this.xhtml.endElement("p");
            this.inBody = false;
        } else if ("sf:text-body".equals(qName)) {
            this.inParsableText = false;
        } else if ("key:metadata".equals(qName)) {
            this.inMetadata = false;
        } else if (this.inMetadata && "key:title".equals(qName)) {
            this.inMetaDataTitle = false;
        } else if (this.inMetadata && "key:authors".equals(qName)) {
            this.inMetaDataAuthors = false;
        } else if (this.inSlide && "sf:tabular-model".equals(qName)) {
            this.xhtml.endElement("table");
            this.tableId = null;
            this.numberOfColumns = null;
            this.currentColumn = null;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inParsableText && this.inSlide && length != 0) {
            this.xhtml.characters(ch, start, length);
        }
    }

    private void parseTableData(String value) throws SAXException {
        if (this.currentColumn == 0) {
            this.xhtml.startElement("tr");
        }
        this.xhtml.element("td", value);
        if (this.currentColumn.equals(this.numberOfColumns)) {
            this.xhtml.endElement("tr");
        }
    }
}

