/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.util.Date;
import org.apache.poi.POIXMLProperties;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.openxml4j.opc.internal.PackagePropertiesPart;
import org.apache.poi.openxml4j.util.Nullable;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.PagedText;
import org.apache.tika.metadata.Property;
import org.openxmlformats.schemas.officeDocument.x2006.extendedProperties.CTProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataExtractor {
    private final POIXMLTextExtractor extractor;
    private final String type;

    public MetadataExtractor(POIXMLTextExtractor extractor, String type) {
        this.extractor = extractor;
        this.type = type;
    }

    public void extract(Metadata metadata) throws TikaException {
        this.addProperty(metadata, "Content-Type", this.type);
        this.extractMetadata(this.extractor.getCoreProperties(), metadata);
        this.extractMetadata(this.extractor.getExtendedProperties(), metadata);
    }

    private void extractMetadata(POIXMLProperties.CoreProperties properties, Metadata metadata) {
        PackagePropertiesPart propsHolder = properties.getUnderlyingProperties();
        this.addProperty(metadata, "Category", propsHolder.getCategoryProperty());
        this.addProperty(metadata, "Content-Status", propsHolder.getContentStatusProperty());
        this.addProperty(metadata, Metadata.DATE, (Nullable<Date>)propsHolder.getCreatedProperty());
        this.addProperty(metadata, Metadata.CREATION_DATE, (Nullable<Date>)propsHolder.getCreatedProperty());
        this.addProperty(metadata, "creator", propsHolder.getCreatorProperty());
        this.addProperty(metadata, "Author", propsHolder.getCreatorProperty());
        this.addProperty(metadata, "description", propsHolder.getDescriptionProperty());
        this.addProperty(metadata, "identifier", propsHolder.getIdentifierProperty());
        this.addProperty(metadata, "Keywords", propsHolder.getKeywordsProperty());
        this.addProperty(metadata, "language", propsHolder.getLanguageProperty());
        this.addProperty(metadata, "Last-Author", propsHolder.getLastModifiedByProperty());
        this.addProperty(metadata, "Last-Printed", propsHolder.getLastPrintedPropertyString());
        this.addProperty(metadata, Metadata.LAST_MODIFIED, (Nullable<Date>)propsHolder.getModifiedProperty());
        this.addProperty(metadata, "Revision-Number", propsHolder.getRevisionProperty());
        this.addProperty(metadata, "subject", propsHolder.getSubjectProperty());
        this.addProperty(metadata, "title", propsHolder.getTitleProperty());
        this.addProperty(metadata, "Version", propsHolder.getVersionProperty());
    }

    private void extractMetadata(POIXMLProperties.ExtendedProperties properties, Metadata metadata) {
        CTProperties propsHolder = properties.getUnderlyingProperties();
        this.addProperty(metadata, "Application-Name", propsHolder.getApplication());
        this.addProperty(metadata, "Application-Version", propsHolder.getAppVersion());
        this.addProperty(metadata, "Character Count", propsHolder.getCharacters());
        this.addProperty(metadata, "Character-Count-With-Spaces", propsHolder.getCharactersWithSpaces());
        this.addProperty(metadata, "publisher", propsHolder.getCompany());
        this.addProperty(metadata, "Line-Count", propsHolder.getLines());
        this.addProperty(metadata, "Manager", propsHolder.getManager());
        this.addProperty(metadata, "Notes", propsHolder.getNotes());
        this.addProperty(metadata, "Page-Count", propsHolder.getPages());
        if (propsHolder.getPages() > 0) {
            metadata.set(PagedText.N_PAGES, propsHolder.getPages());
        } else if (propsHolder.getSlides() > 0) {
            metadata.set(PagedText.N_PAGES, propsHolder.getSlides());
        }
        this.addProperty(metadata, "Paragraph-Count", propsHolder.getParagraphs());
        this.addProperty(metadata, "Presentation-Format", propsHolder.getPresentationFormat());
        this.addProperty(metadata, "Slide-Count", propsHolder.getSlides());
        this.addProperty(metadata, "Template", propsHolder.getTemplate());
        this.addProperty(metadata, "Total-Time", propsHolder.getTotalTime());
        this.addProperty(metadata, "Word-Count", propsHolder.getWords());
    }

    private void addProperty(Metadata metadata, Property property, Nullable<Date> value) {
        if (value.getValue() != null) {
            metadata.set(property, (Date)value.getValue());
        }
    }

    private void addProperty(Metadata metadata, String name, Nullable<?> value) {
        if (value.getValue() != null) {
            this.addProperty(metadata, name, value.getValue().toString());
        }
    }

    private void addProperty(Metadata metadata, String name, String value) {
        if (value != null) {
            metadata.set(name, value);
        }
    }

    private void addProperty(Metadata metadata, String name, long value) {
        if (value > 0L) {
            metadata.set(name, Long.toString(value));
        }
    }
}

