/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.visitor;

import org.drools.lang.descr.AccessorDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.DeclarativeInvokerDescr;
import org.drools.lang.descr.FieldAccessDescr;
import org.drools.lang.descr.FunctionCallDescr;
import org.drools.lang.descr.MethodAccessDescr;
import org.drools.verifier.components.RuleComponent;
import org.drools.verifier.components.VerifierAccessorDescr;
import org.drools.verifier.components.VerifierFieldAccessDescr;
import org.drools.verifier.components.VerifierFunctionCallDescr;
import org.drools.verifier.components.VerifierMethodAccessDescr;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.data.VerifierComponent;
import org.drools.verifier.data.VerifierData;
import org.drools.verifier.visitor.UnknownDescriptionException;

public class DeclarativeInvokerDescrVisitor {
    private final VerifierData data;
    private final VerifierRule rule;
    private int orderNumber = 0;

    public DeclarativeInvokerDescrVisitor(VerifierData data, VerifierRule rule) {
        this.data = data;
        this.rule = rule;
    }

    public VerifierComponent visit(DeclarativeInvokerDescr descr) throws UnknownDescriptionException {
        RuleComponent ds;
        if (descr instanceof AccessorDescr) {
            ds = this.visit((AccessorDescr)descr);
        } else if (descr instanceof FieldAccessDescr) {
            ds = this.visit((FieldAccessDescr)descr);
        } else if (descr instanceof FunctionCallDescr) {
            ds = this.visit((FunctionCallDescr)descr);
        } else if (descr instanceof MethodAccessDescr) {
            ds = this.visit((MethodAccessDescr)descr);
        } else {
            throw new UnknownDescriptionException((BaseDescr)descr);
        }
        return ds;
    }

    private VerifierFunctionCallDescr visit(FunctionCallDescr descr) {
        VerifierFunctionCallDescr functionCall = new VerifierFunctionCallDescr(this.rule);
        functionCall.setName(descr.getName());
        functionCall.setArguments(descr.getArguments());
        functionCall.setOrderNumber(this.orderNumber);
        functionCall.setParentPath(this.rule.getPath());
        functionCall.setParentType(this.rule.getVerifierComponentType());
        return functionCall;
    }

    private VerifierFieldAccessDescr visit(FieldAccessDescr descr) {
        VerifierFieldAccessDescr accessor = new VerifierFieldAccessDescr(this.rule);
        accessor.setFieldName(descr.getFieldName());
        accessor.setArgument(descr.getArgument());
        accessor.setOrderNumber(this.orderNumber);
        accessor.setParentPath(this.rule.getPath());
        accessor.setParentType(this.rule.getVerifierComponentType());
        this.data.add(accessor);
        return accessor;
    }

    private VerifierAccessorDescr visit(AccessorDescr descr) {
        VerifierAccessorDescr accessor = new VerifierAccessorDescr(this.rule);
        accessor.setOrderNumber(this.orderNumber);
        accessor.setParentPath(this.rule.getPath());
        accessor.setParentType(this.rule.getVerifierComponentType());
        this.data.add(accessor);
        return accessor;
    }

    private VerifierMethodAccessDescr visit(MethodAccessDescr descr) {
        VerifierMethodAccessDescr accessor = new VerifierMethodAccessDescr(this.rule);
        accessor.setMethodName(descr.getMethodName());
        accessor.setArguments(descr.getArguments());
        accessor.setOrderNumber(this.orderNumber);
        accessor.setParentPath(this.rule.getPath());
        accessor.setParentType(this.rule.getVerifierComponentType());
        this.data.add(accessor);
        return accessor;
    }
}

