/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.wsht;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.drools.runtime.KnowledgeRuntime;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemManager;
import org.jbpm.eventmessaging.EventResponseHandler;
import org.jbpm.eventmessaging.Payload;
import org.jbpm.process.workitem.wsht.AbstractHTWorkItemHandler;
import org.jbpm.process.workitem.wsht.GenericHTWorkItemHandler;
import org.jbpm.task.AsyncTaskService;
import org.jbpm.task.Content;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.event.TaskEventKey;
import org.jbpm.task.event.entity.TaskCompletedEvent;
import org.jbpm.task.event.entity.TaskEvent;
import org.jbpm.task.event.entity.TaskFailedEvent;
import org.jbpm.task.event.entity.TaskSkippedEvent;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.responsehandlers.AbstractBaseResponseHandler;
import org.jbpm.task.utils.ContentMarshallerHelper;
import org.jbpm.task.utils.OnErrorAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncGenericHTWorkItemHandler
extends AbstractHTWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(GenericHTWorkItemHandler.class);
    private AsyncTaskService client;
    private String ipAddress;
    private int port;
    private boolean local = false;
    private boolean connected = false;
    private ClassLoader classLoader;
    private boolean owningSessionOnly = false;

    public AsyncGenericHTWorkItemHandler(KnowledgeRuntime session, OnErrorAction action, ClassLoader classLoader) {
        super(session, action);
        this.classLoader = classLoader;
    }

    public AsyncGenericHTWorkItemHandler(KnowledgeRuntime session, OnErrorAction action) {
        super(session, action);
    }

    public AsyncGenericHTWorkItemHandler(KnowledgeRuntime session) {
        super(session);
    }

    public AsyncGenericHTWorkItemHandler(KnowledgeRuntime session, boolean owningSessionOnly) {
        super(session);
        this.owningSessionOnly = owningSessionOnly;
    }

    public AsyncTaskService getClient() {
        return this.client;
    }

    public void setClient(AsyncTaskService client) {
        this.client = client;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public boolean isLocal() {
        return this.local;
    }

    public int getPort() {
        return this.port;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private void registerTaskEvents() {
        TaskCompletedHandler eventResponseHandler = new TaskCompletedHandler(this.client, this.classLoader);
        TaskEventKey key = new TaskEventKey(TaskCompletedEvent.class, -1L);
        this.client.registerForEvent(key, false, eventResponseHandler);
        this.eventHandlers.put(key, eventResponseHandler);
        key = new TaskEventKey(TaskFailedEvent.class, -1L);
        this.client.registerForEvent(key, false, eventResponseHandler);
        this.eventHandlers.put(key, eventResponseHandler);
        key = new TaskEventKey(TaskSkippedEvent.class, -1L);
        this.client.registerForEvent(key, false, eventResponseHandler);
        this.eventHandlers.put(key, eventResponseHandler);
    }

    public void connect() {
        if (this.client == null) {
            throw new IllegalStateException("You must set the Task Service Client to the work item to work");
        }
        if (this.ipAddress == null || this.ipAddress.equals("") || this.port <= 0) {
            throw new IllegalStateException("You must set the IP and Port to the work item to work");
        }
        if (this.client != null && !this.connected) {
            this.connected = this.client.connect(this.ipAddress, this.port);
            if (!this.connected) {
                throw new IllegalArgumentException("Could not connect task client");
            }
            this.registerTaskEvents();
        }
    }

    public void dispose() throws Exception {
        for (TaskEventKey key : this.eventHandlers.keySet()) {
            this.client.unregisterForEvent(key);
        }
        this.eventHandlers.clear();
        if (this.client != null) {
            this.client.disconnect();
        }
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        Task task = this.createTaskBasedOnWorkItemParams(workItem);
        ContentData content = this.createTaskContentBasedOnWorkItemParams(workItem);
        this.connect();
        this.client.addTask(task, content, new TaskAddedHandler(workItem.getId()));
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        AbortTaskResponseHandler abortTaskResponseHandler = new AbortTaskResponseHandler(this.client);
        this.client.getTaskByWorkItemId(workItem.getId(), abortTaskResponseHandler);
    }

    public boolean isOwningSessionOnly() {
        return this.owningSessionOnly;
    }

    public void setOwningSessionOnly(boolean owningSessionOnly) {
        this.owningSessionOnly = owningSessionOnly;
    }

    private class AbortTaskResponseHandler
    extends AbstractBaseResponseHandler
    implements TaskClientHandler.GetTaskResponseHandler {
        private AsyncTaskService client;

        public AbortTaskResponseHandler(AsyncTaskService client) {
            this.client = client;
        }

        public void execute(Task task) {
            if (task != null) {
                this.client.exit(task.getId(), "Administrator", null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetResultContentResponseHandler
    extends AbstractBaseResponseHandler
    implements TaskClientHandler.GetContentResponseHandler {
        private Task task;
        private Map<String, Object> results;
        private ClassLoader classLoader;

        public GetResultContentResponseHandler(Task task, Map<String, Object> results, ClassLoader classLoader) {
            this.task = task;
            this.results = results;
            this.classLoader = classLoader;
        }

        @Override
        public void execute(Content content) {
            Object result = ContentMarshallerHelper.unmarshall(content.getContent(), AsyncGenericHTWorkItemHandler.this.session.getEnvironment(), this.classLoader);
            this.results.put("Result", result);
            if (result instanceof Map) {
                Map map = (Map)result;
                for (Map.Entry entry : map.entrySet()) {
                    if (!(entry.getKey() instanceof String)) continue;
                    this.results.put((String)entry.getKey(), entry.getValue());
                }
            }
            AsyncGenericHTWorkItemHandler.this.session.getWorkItemManager().completeWorkItem(this.task.getTaskData().getWorkItemId(), this.results);
        }
    }

    private class GetCompletedTaskResponseHandler
    extends AbstractBaseResponseHandler
    implements TaskClientHandler.GetTaskResponseHandler {
        private AsyncTaskService client;
        private ClassLoader classLoader;

        public GetCompletedTaskResponseHandler(AsyncTaskService client, ClassLoader classLoader) {
            this.client = client;
            this.classLoader = classLoader;
        }

        public void execute(Task task) {
            long workItemId = task.getTaskData().getWorkItemId();
            if (task.getTaskData().getStatus() == Status.Completed) {
                String userId = task.getTaskData().getActualOwner().getId();
                HashMap<String, Object> results = new HashMap<String, Object>();
                results.put("ActorId", userId);
                long contentId = task.getTaskData().getOutputContentId();
                if (contentId != -1L) {
                    GetResultContentResponseHandler getContentResponseHandler = new GetResultContentResponseHandler(task, results, this.classLoader);
                    this.client.getContent(contentId, getContentResponseHandler);
                } else {
                    AsyncGenericHTWorkItemHandler.this.session.getWorkItemManager().completeWorkItem(workItemId, results);
                }
            } else {
                AsyncGenericHTWorkItemHandler.this.session.getWorkItemManager().abortWorkItem(workItemId);
            }
        }
    }

    private class TaskCompletedHandler
    extends AbstractBaseResponseHandler
    implements EventResponseHandler {
        private AsyncTaskService client;
        private ClassLoader classLoader;

        public TaskCompletedHandler(AsyncTaskService client, ClassLoader classLoader) {
            this.client = client;
            this.classLoader = classLoader;
        }

        public void execute(Payload payload) {
            TaskEvent event = (TaskEvent)payload.get();
            if (AsyncGenericHTWorkItemHandler.this.owningSessionOnly && AsyncGenericHTWorkItemHandler.this.session instanceof StatefulKnowledgeSession && ((StatefulKnowledgeSession)AsyncGenericHTWorkItemHandler.this.session).getId() != event.getSessionId()) {
                return;
            }
            long taskId = event.getTaskId();
            GetCompletedTaskResponseHandler getTaskResponseHandler = new GetCompletedTaskResponseHandler(this.client, this.classLoader);
            this.client.getTask(taskId, getTaskResponseHandler);
        }

        public boolean isRemove() {
            return false;
        }
    }

    private class TaskAddedHandler
    extends AbstractBaseResponseHandler
    implements TaskClientHandler.AddTaskResponseHandler {
        private long workItemId;

        public TaskAddedHandler(long workItemId) {
            this.workItemId = workItemId;
        }

        public void execute(long taskId) {
        }

        public synchronized void setError(RuntimeException error) {
            super.setError(error);
            if (AsyncGenericHTWorkItemHandler.this.action.equals((Object)OnErrorAction.ABORT)) {
                AsyncGenericHTWorkItemHandler.this.session.getWorkItemManager().abortWorkItem(this.workItemId);
            } else {
                if (AsyncGenericHTWorkItemHandler.this.action.equals((Object)OnErrorAction.RETHROW)) {
                    throw this.getError();
                }
                if (AsyncGenericHTWorkItemHandler.this.action.equals((Object)OnErrorAction.LOG)) {
                    StringBuffer logMsg = new StringBuffer();
                    logMsg.append(new Date() + ": Error when creating task on task server for work item id " + this.workItemId);
                    logMsg.append(". Error reported by task server: " + this.getError().getMessage());
                    logger.error(logMsg.toString(), (Throwable)this.getError());
                }
            }
        }
    }
}

