/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.identity;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.jbpm.task.Group;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.User;
import org.jbpm.task.UserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPUserInfoImpl
implements UserInfo {
    private static final Logger logger = LoggerFactory.getLogger(LDAPUserInfoImpl.class);
    protected static final String DEFAULT_PROPERTIES_NAME = "/jbpm.user.info.properties";
    public static final String BIND_USER = "ldap.bind.user";
    public static final String BIND_PWD = "ldap.bind.pwd";
    public static final String USER_CTX = "ldap.user.ctx";
    public static final String ROLE_CTX = "ldap.role.ctx";
    public static final String USER_FILTER = "ldap.user.filter";
    public static final String ROLE_FILTER = "ldap.role.filter";
    public static final String ROLE_MEMBERS_FILTER = "ldap.role.members.filter";
    public static final String EMAIL_ATTR_ID = "ldap.email.attr.id";
    public static final String NAME_ATTR_ID = "ldap.name.attr.id";
    public static final String LANG_ATTR_ID = "ldap.lang.attr.id";
    public static final String MEMBER_ATTR_ID = "ldap.member.attr.id";
    public static final String USER_ATTR_ID = "ldap.user.attr.id";
    public static final String ROLE_ATTR_ID = "ldap.role.attr.id";
    public static final String IS_ENTITY_ID_DN = "ldap.entity.id.dn";
    protected static final String[] requiredProperties = new String[]{"ldap.user.ctx", "ldap.role.ctx", "ldap.user.filter", "ldap.role.filter"};
    private Properties config;

    public LDAPUserInfoImpl() {
        String propertiesLocation = System.getProperty("jbpm.user.info.properties");
        if (propertiesLocation == null) {
            propertiesLocation = DEFAULT_PROPERTIES_NAME;
        }
        logger.debug("Callback properties will be loaded from " + propertiesLocation);
        InputStream in = this.getClass().getResourceAsStream(propertiesLocation);
        if (in != null) {
            this.config = new Properties();
            try {
                this.config.load(in);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.config = null;
            }
        }
        this.validate();
    }

    public LDAPUserInfoImpl(Properties config) {
        this.config = config;
        this.validate();
    }

    @Override
    public String getDisplayName(OrganizationalEntity entity) {
        String context = null;
        String filter = null;
        String attrId = null;
        if (entity instanceof User) {
            context = this.config.getProperty(USER_CTX);
            filter = this.config.getProperty(USER_FILTER);
            attrId = this.config.getProperty(NAME_ATTR_ID, "displayName");
        } else if (entity instanceof Group) {
            context = this.config.getProperty(ROLE_CTX);
            filter = this.config.getProperty(ROLE_FILTER);
            attrId = this.config.getProperty(NAME_ATTR_ID, "displayName");
        } else {
            throw new IllegalArgumentException("Unknown organizational entity " + entity);
        }
        String result = this.searchLdap(context, filter, attrId, entity);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<OrganizationalEntity> getMembersForGroup(Group group) {
        InitialLdapContext ctx = null;
        ArrayList<User> memebers = new ArrayList<User>();
        try {
            ctx = this.buildInitialLdapContext();
            String roleContext = this.config.getProperty(ROLE_CTX);
            String roleFilter = this.config.getProperty(ROLE_MEMBERS_FILTER, this.config.getProperty(ROLE_FILTER));
            String roleAttrId = this.config.getProperty(MEMBER_ATTR_ID, "member");
            roleFilter = roleFilter.replaceAll("\\{0\\}", group.getId());
            SearchControls constraints = new SearchControls();
            NamingEnumeration<SearchResult> result = ctx.search(roleContext, roleFilter, constraints);
            while (result.hasMore()) {
                SearchResult sr = result.next();
                Attribute member = sr.getAttributes().get(roleAttrId);
                for (int i = 0; i < member.size(); ++i) {
                    memebers.add(new User(member.get(i).toString()));
                }
            }
            result.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
            }
        }
        return memebers.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasEmail(Group group) {
        InitialLdapContext ctx = null;
        boolean exists = false;
        try {
            SearchResult sr;
            Attribute ldapGroupEmail;
            ctx = this.buildInitialLdapContext();
            String roleContext = this.config.getProperty(ROLE_CTX);
            String roleFilter = this.config.getProperty(ROLE_FILTER);
            String roleAttrId = this.config.getProperty(EMAIL_ATTR_ID, "mail");
            roleFilter = roleFilter.replaceAll("\\{0\\}", group.getId());
            SearchControls constraints = new SearchControls();
            NamingEnumeration<SearchResult> result = ctx.search(roleContext, roleFilter, constraints);
            if (result.hasMore() && (ldapGroupEmail = (sr = result.next()).getAttributes().get(roleAttrId)) != null && ldapGroupEmail.get() != null) {
                exists = true;
            }
            result.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
            }
        }
        return exists;
    }

    @Override
    public String getEmailForEntity(OrganizationalEntity entity) {
        String context = null;
        String filter = null;
        String attrId = null;
        if (entity instanceof User) {
            context = this.config.getProperty(USER_CTX);
            filter = this.config.getProperty(USER_FILTER);
            attrId = this.config.getProperty(EMAIL_ATTR_ID, "mail");
        } else if (entity instanceof Group) {
            context = this.config.getProperty(ROLE_CTX);
            filter = this.config.getProperty(ROLE_FILTER);
            attrId = this.config.getProperty(EMAIL_ATTR_ID, "mail");
        } else {
            throw new IllegalArgumentException("Unknown organizational entity " + entity);
        }
        String result = this.searchLdap(context, filter, attrId, entity);
        return result;
    }

    @Override
    public String getLanguageForEntity(OrganizationalEntity entity) {
        String context = null;
        String filter = null;
        String attrId = null;
        if (entity instanceof User) {
            context = this.config.getProperty(USER_CTX);
            filter = this.config.getProperty(USER_FILTER);
            attrId = this.config.getProperty(LANG_ATTR_ID, "locale");
        } else if (entity instanceof Group) {
            context = this.config.getProperty(ROLE_CTX);
            filter = this.config.getProperty(ROLE_FILTER);
            attrId = this.config.getProperty(LANG_ATTR_ID, "locale");
        } else {
            throw new IllegalArgumentException("Unknown organizational entity " + entity);
        }
        String result = this.searchLdap(context, filter, attrId, entity);
        if (result == null) {
            result = "en-UK";
        }
        return result;
    }

    protected void validate() {
        if (this.config == null) {
            throw new IllegalArgumentException("No configuration found for LDAPUserInfoImpl, aborting...");
        }
        StringBuffer missingRequiredProps = new StringBuffer();
        for (String requiredProp : requiredProperties) {
            if (this.config.containsKey(requiredProp)) continue;
            if (missingRequiredProps.length() > 0) {
                missingRequiredProps.append(", ");
            }
            missingRequiredProps.append(requiredProp);
        }
        if (missingRequiredProps.length() > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("Validation failed due to missing required properties: " + missingRequiredProps.toString());
            }
            throw new IllegalArgumentException("Missing required properties to configure LDAPUserInfoImpl: " + missingRequiredProps.toString());
        }
    }

    protected InitialLdapContext buildInitialLdapContext() throws NamingException {
        String authType;
        String factoryName = this.config.getProperty("java.naming.factory.initial");
        if (factoryName == null) {
            factoryName = "com.sun.jndi.ldap.LdapCtxFactory";
            this.config.setProperty("java.naming.factory.initial", factoryName);
        }
        if ((authType = this.config.getProperty("java.naming.security.authentication")) == null) {
            this.config.setProperty("java.naming.security.authentication", "simple");
        }
        String protocol = this.config.getProperty("java.naming.security.protocol");
        String providerURL = this.config.getProperty("java.naming.provider.url");
        if (providerURL == null) {
            providerURL = "ldap://localhost:" + (protocol != null && protocol.equals("ssl") ? "636" : "389");
            this.config.setProperty("java.naming.provider.url", providerURL);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Using following InitialLdapContext properties:");
            logger.debug("Factory " + this.config.getProperty("java.naming.factory.initial"));
            logger.debug("Authentication " + this.config.getProperty("java.naming.security.authentication"));
            logger.debug("Protocol " + this.config.getProperty("java.naming.security.protocol"));
            logger.debug("Provider URL " + this.config.getProperty("java.naming.provider.url"));
        }
        return new InitialLdapContext(this.config, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String searchLdap(String context, String filter, String attrId, OrganizationalEntity entity) {
        InitialLdapContext ctx = null;
        String result = null;
        try {
            SearchResult sr;
            Attribute entry;
            SearchControls constraints;
            NamingEnumeration<SearchResult> ldapResult;
            ctx = this.buildInitialLdapContext();
            String entityId = entity.getId();
            if (Boolean.parseBoolean(this.config.getProperty(IS_ENTITY_ID_DN, "false"))) {
                entityId = this.extractUserId(entityId, entity);
            }
            if ((ldapResult = ctx.search(context, filter = filter.replaceAll("\\{0\\}", entityId), constraints = new SearchControls())).hasMore() && (entry = (sr = ldapResult.next()).getAttributes().get(attrId)) != null) {
                result = (String)entry.get();
            }
            ldapResult.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    protected String extractUserId(String userDN, OrganizationalEntity entity) {
        String[] attributes = userDN.split(",");
        if (attributes.length == 1) {
            return userDN;
        }
        String entityAttrId = null;
        if (entity instanceof User) {
            entityAttrId = this.config.getProperty(USER_ATTR_ID, "uid");
        } else if (entity instanceof Group) {
            entityAttrId = this.config.getProperty(ROLE_ATTR_ID, "cn");
        }
        if (attributes != null) {
            for (String attribute : attributes) {
                String[] keyValue = attribute.split("=");
                if (!keyValue[0].equalsIgnoreCase(entityAttrId)) continue;
                return keyValue[1];
            }
        }
        return null;
    }
}

