/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.example.factorial;

import java.math.BigInteger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.CorruptedFrameException;
import org.jboss.netty.handler.codec.frame.FrameDecoder;

public class BigIntegerDecoder
extends FrameDecoder {
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        if (buffer.readableBytes() < 5) {
            return null;
        }
        buffer.markReaderIndex();
        short magicNumber = buffer.readUnsignedByte();
        if (magicNumber != 70) {
            buffer.resetReaderIndex();
            throw new CorruptedFrameException("Invalid magic number: " + magicNumber);
        }
        int dataLength = buffer.readInt();
        if (buffer.readableBytes() < dataLength) {
            buffer.resetReaderIndex();
            return null;
        }
        byte[] decoded = new byte[dataLength];
        buffer.readBytes(decoded);
        return new BigInteger(decoded);
    }
}

