/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.example.proxy;

import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.example.proxy.HexDumpProxyPipelineFactory;

public class HexDumpProxy {
    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.err.println("Usage: " + HexDumpProxy.class.getSimpleName() + " <local port> <remote host> <remote port>");
            return;
        }
        int localPort = Integer.parseInt(args[0]);
        String remoteHost = args[1];
        int remotePort = Integer.parseInt(args[2]);
        System.err.println("Proxying *:" + localPort + " to " + remoteHost + ':' + remotePort + " ...");
        ExecutorService executor = Executors.newCachedThreadPool();
        ServerBootstrap sb = new ServerBootstrap(new NioServerSocketChannelFactory(executor, executor));
        NioClientSocketChannelFactory cf = new NioClientSocketChannelFactory(executor, executor);
        sb.setPipelineFactory(new HexDumpProxyPipelineFactory(cf, remoteHost, remotePort));
        sb.bind(new InetSocketAddress(localPort));
    }
}

