/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.example.qotm;

import java.net.InetSocketAddress;
import java.util.concurrent.Executors;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.FixedReceiveBufferSizePredictorFactory;
import org.jboss.netty.channel.socket.DatagramChannel;
import org.jboss.netty.channel.socket.nio.NioDatagramChannelFactory;
import org.jboss.netty.example.qotm.QuoteOfTheMomentClientHandler;
import org.jboss.netty.handler.codec.string.StringDecoder;
import org.jboss.netty.handler.codec.string.StringEncoder;
import org.jboss.netty.util.CharsetUtil;

public class QuoteOfTheMomentClient {
    public static void main(String[] args) throws Exception {
        NioDatagramChannelFactory f = new NioDatagramChannelFactory(Executors.newCachedThreadPool());
        ConnectionlessBootstrap b = new ConnectionlessBootstrap(f);
        b.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                return Channels.pipeline(new StringEncoder(CharsetUtil.ISO_8859_1), new StringDecoder(CharsetUtil.ISO_8859_1), new QuoteOfTheMomentClientHandler());
            }
        });
        b.setOption("broadcast", "true");
        b.setOption("receiveBufferSizePredictorFactory", new FixedReceiveBufferSizePredictorFactory(1024));
        DatagramChannel c = (DatagramChannel)b.bind(new InetSocketAddress(0));
        c.write("QOTM?", new InetSocketAddress("255.255.255.255", 8080));
        if (!c.getCloseFuture().awaitUninterruptibly(5000L)) {
            System.err.println("QOTM request timed out.");
            c.close().awaitUninterruptibly();
        }
        f.releaseExternalResources();
    }
}

