/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import org.hornetq.core.logging.Logger;

public class SoftValueHashMap<K, V extends ValueCache>
implements Map<K, V> {
    private static final Logger log = Logger.getLogger(SoftValueHashMap.class);
    private final boolean isTrace = log.isTraceEnabled();
    private final ReferenceQueue<V> refQueue = new ReferenceQueue();
    private final Map<K, AggregatedSoftReference> mapDelegate = new HashMap<K, AggregatedSoftReference>();
    private final AtomicLong usedCounter = new AtomicLong(0L);
    private int maxElements;

    public SoftValueHashMap(int maxElements) {
        this.maxElements = maxElements;
    }

    public void setMaxElements(int maxElements) {
        this.maxElements = maxElements;
        this.checkCacheSize();
    }

    public int getMaxEelements() {
        return this.maxElements;
    }

    @Override
    public int size() {
        this.processQueue();
        return this.mapDelegate.size();
    }

    @Override
    public boolean isEmpty() {
        this.processQueue();
        return this.mapDelegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.processQueue();
        return this.mapDelegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.processQueue();
        for (AggregatedSoftReference valueIter : this.mapDelegate.values()) {
            ValueCache valueElement = (ValueCache)valueIter.get();
            if (valueElement == null || !value.equals(valueElement)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        this.processQueue();
        AggregatedSoftReference value = this.mapDelegate.get(key);
        if (value != null) {
            value.used();
            return (V)((ValueCache)value.get());
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        AggregatedSoftReference newRef = this.createReference(key, value);
        AggregatedSoftReference oldRef = this.mapDelegate.put(key, newRef);
        this.checkCacheSize();
        newRef.used();
        if (oldRef != null) {
            return (V)((ValueCache)oldRef.get());
        }
        return null;
    }

    private void checkCacheSize() {
        if (this.maxElements > 0 && this.mapDelegate.size() > this.maxElements) {
            TreeSet<AggregatedSoftReference> usedReferences = new TreeSet<AggregatedSoftReference>(new ComparatorAgregated());
            for (AggregatedSoftReference ref : this.mapDelegate.values()) {
                ValueCache v = (ValueCache)ref.get();
                if (v == null || v.isLive()) continue;
                usedReferences.add(ref);
            }
            for (AggregatedSoftReference ref : usedReferences) {
                if (ref.used <= 0L) continue;
                AggregatedSoftReference removed = this.mapDelegate.remove(ref.key);
                if (this.isTrace) {
                    log.trace("Removing " + removed + " with id = " + ref.key + " from SoftValueHashMap");
                }
                if (this.mapDelegate.size() > this.maxElements) continue;
                break;
            }
        }
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        AggregatedSoftReference ref = this.mapDelegate.remove(key);
        if (ref != null) {
            return (V)((ValueCache)ref.get());
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.processQueue();
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), (V)((ValueCache)e.getValue()));
        }
    }

    @Override
    public void clear() {
        this.mapDelegate.clear();
    }

    @Override
    public Set<K> keySet() {
        this.processQueue();
        return this.mapDelegate.keySet();
    }

    @Override
    public Collection<V> values() {
        this.processQueue();
        ArrayList<ValueCache> list = new ArrayList<ValueCache>();
        for (AggregatedSoftReference refs : this.mapDelegate.values()) {
            ValueCache value = (ValueCache)refs.get();
            if (value == null) continue;
            list.add(value);
        }
        return list;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.processQueue();
        HashSet<Map.Entry<K, V>> set = new HashSet<Map.Entry<K, V>>();
        for (Map.Entry<K, AggregatedSoftReference> pair : this.mapDelegate.entrySet()) {
            ValueCache value = (ValueCache)pair.getValue().get();
            if (value == null) continue;
            set.add(new EntryElement<K, ValueCache>(pair.getKey(), value));
        }
        return set;
    }

    @Override
    public boolean equals(Object o) {
        this.processQueue();
        return ((Object)this.mapDelegate).equals(o);
    }

    @Override
    public int hashCode() {
        return ((Object)this.mapDelegate).hashCode();
    }

    private void processQueue() {
        AggregatedSoftReference ref = null;
        while ((ref = (AggregatedSoftReference)this.refQueue.poll()) != null) {
            this.mapDelegate.remove(ref.key);
        }
    }

    private AggregatedSoftReference createReference(K key, V value) {
        AggregatedSoftReference ref = new AggregatedSoftReference(this, key, value);
        return ref;
    }

    static final class EntryElement<K, V>
    implements Map.Entry<K, V> {
        final K key;
        volatile V value;

        EntryElement(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            this.value = value;
            return value;
        }
    }

    static class AggregatedSoftReference
    extends SoftReference<V> {
        final K key;
        long used;
        final /* synthetic */ SoftValueHashMap this$0;

        public long getUsed() {
            return this.used;
        }

        public void used() {
            this.used = this.this$0.usedCounter.incrementAndGet();
        }

        public AggregatedSoftReference(K key, V referent) {
            this.this$0 = var1_1;
            super(referent, ((SoftValueHashMap)var1_1).refQueue);
            this.used = 0L;
            this.key = key;
        }

        public String toString() {
            return "AggregatedSoftReference [key=" + this.key + ", used=" + this.used + "]";
        }
    }

    class ComparatorAgregated
    implements Comparator<AggregatedSoftReference> {
        ComparatorAgregated() {
        }

        @Override
        public int compare(AggregatedSoftReference o1, AggregatedSoftReference o2) {
            long k = o1.used - o2.used;
            if (k > 0L) {
                return 1;
            }
            if (k < 0L) {
                return -1;
            }
            k = o1.hashCode() - o2.hashCode();
            if (k > 0L) {
                return 1;
            }
            if (k < 0L) {
                return -1;
            }
            return 0;
        }
    }

    public static interface ValueCache {
        public boolean isLive();
    }
}

