/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import java.security.ProtectionDomain;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.drools.RuntimeDroolsException;
import org.drools.base.AccessorKey;
import org.drools.base.BaseClassFieldReader;
import org.drools.base.BaseClassFieldWriter;
import org.drools.base.ClassFieldAccessorFactory;
import org.drools.base.ClassFieldReader;
import org.drools.base.ClassFieldWriter;
import org.drools.base.ClassObjectType;
import org.drools.core.util.asm.ClassFieldInspector;

public class ClassFieldAccessorCache {
    private Map<ClassLoader, CacheEntry> cacheByClassLoader = new WeakHashMap<ClassLoader, CacheEntry>();
    private ClassLoader classLoader;

    public ClassFieldAccessorCache(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ClassObjectType getClassObjectType(ClassObjectType objectType) {
        Class cls = this.getClass(objectType.getClassName());
        CacheEntry cache = this.getCacheEntry(cls);
        return cache.getClassObjectType(cls, objectType);
    }

    public BaseClassFieldReader getReadAcessor(ClassFieldReader reader) {
        String className = reader.getClassName();
        String fieldName = reader.getFieldName();
        Class cls = this.getClass(className);
        CacheEntry cache = this.getCacheEntry(cls);
        return cache.getReadAccessor(new AccessorKey(className, fieldName, AccessorKey.AccessorType.FieldAccessor), cls);
    }

    public BaseClassFieldWriter getWriteAcessor(ClassFieldWriter writer) {
        String className = writer.getClassName();
        String fieldName = writer.getFieldName();
        Class cls = this.getClass(className);
        CacheEntry cache = this.getCacheEntry(cls);
        return cache.getWriteAccessor(new AccessorKey(className, fieldName, AccessorKey.AccessorType.FieldAccessor), cls);
    }

    public Class getClass(String className) {
        try {
            return this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeDroolsException("Unable to resolve class '" + className + "'");
        }
    }

    public CacheEntry getCacheEntry(Class cls) {
        ClassLoader cl = cls.getClassLoader() != null ? cls.getClassLoader() : this.classLoader;
        CacheEntry cache = this.cacheByClassLoader.get(cl);
        if (cache == null) {
            cache = new CacheEntry(this.classLoader);
            this.cacheByClassLoader.put(cl, cache);
        }
        return cache;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ByteArrayClassLoader
    extends ClassLoader {
        public ByteArrayClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class<?> defineClass(String name, byte[] bytes, ProtectionDomain domain) {
            return this.defineClass(name, bytes, 0, bytes.length, domain);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CacheEntry {
        private ByteArrayClassLoader byteArrayClassLoader;
        private final ConcurrentMap<AccessorKey, BaseClassFieldReader> readCache = new ConcurrentHashMap<AccessorKey, BaseClassFieldReader>();
        private final ConcurrentMap<AccessorKey, BaseClassFieldWriter> writeCache = new ConcurrentHashMap<AccessorKey, BaseClassFieldWriter>();
        private final ConcurrentMap<Class<?>, ClassFieldInspector> inspectors = new ConcurrentHashMap();
        private final ConcurrentMap<ClassObjectTypeKey, ClassObjectType> objectTypes = new ConcurrentHashMap<ClassObjectTypeKey, ClassObjectType>();

        public CacheEntry(ClassLoader parentClassLoader) {
            if (parentClassLoader == null) {
                throw new RuntimeDroolsException("ClassFieldAccessorFactory cannot have a null parent ClassLoader");
            }
            this.byteArrayClassLoader = new ByteArrayClassLoader(parentClassLoader);
        }

        public ByteArrayClassLoader getByteArrayClassLoader() {
            return this.byteArrayClassLoader;
        }

        public BaseClassFieldReader getReadAccessor(AccessorKey key, Class cls) {
            BaseClassFieldReader existingReader;
            BaseClassFieldReader reader = (BaseClassFieldReader)this.readCache.get(key);
            if (reader == null && (reader = ClassFieldAccessorFactory.getInstance().getClassFieldReader(cls, key.getFieldName(), this)) != null && (existingReader = this.readCache.putIfAbsent(key, reader)) != null) {
                reader = existingReader;
            }
            return reader;
        }

        public BaseClassFieldWriter getWriteAccessor(AccessorKey key, Class cls) {
            BaseClassFieldWriter existingWriter;
            BaseClassFieldWriter writer = (BaseClassFieldWriter)this.writeCache.get(key);
            if (writer == null && (existingWriter = this.writeCache.putIfAbsent(key, writer = ClassFieldAccessorFactory.getInstance().getClassFieldWriter(cls, key.getFieldName(), this))) != null) {
                writer = existingWriter;
            }
            return writer;
        }

        public Map<Class<?>, ClassFieldInspector> getInspectors() {
            return this.inspectors;
        }

        public ClassObjectType getClassObjectType(Class<?> cls, ClassObjectType objectType) {
            ClassObjectTypeKey key = new ClassObjectTypeKey(cls, objectType.isEvent());
            ClassObjectType existing = (ClassObjectType)this.objectTypes.get(key);
            if (existing == null) {
                objectType.setClassType(cls);
                existing = this.objectTypes.putIfAbsent(key, objectType);
                if (existing == null) {
                    existing = objectType;
                }
            }
            return existing;
        }
    }

    public static class ClassObjectTypeKey {
        private Class cls;
        private boolean event;

        public ClassObjectTypeKey(Class cls, boolean event) {
            this.cls = cls;
            this.event = event;
        }

        public Class getCls() {
            return this.cls;
        }

        public boolean isEvent() {
            return this.event;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.cls == null ? 0 : this.cls.hashCode());
            result = 31 * result + (this.event ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ClassObjectTypeKey)) {
                return false;
            }
            ClassObjectTypeKey other = (ClassObjectTypeKey)obj;
            if (this.cls == null ? other.cls != null : !this.cls.equals(other.cls)) {
                return false;
            }
            return this.event == other.event;
        }
    }
}

