/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.base.evaluators.TimeIntervalParser;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.time.Interval;

public class FinishedByEvaluatorDefinition
implements EvaluatorDefinition {
    protected static final String finishedByOp = "finishedby";
    public static Operator FINISHED_BY;
    public static Operator NOT_FINISHED_BY;
    private static String[] SUPPORTED_IDS;
    private Map<String, FinishedByEvaluator> cache;
    private volatile TimeIntervalParser parser;

    public FinishedByEvaluatorDefinition() {
        FinishedByEvaluatorDefinition.init();
        this.cache = Collections.emptyMap();
        this.parser = new TimeIntervalParser();
    }

    static void init() {
        if (Operator.determineOperator(finishedByOp, false) == null) {
            FINISHED_BY = Operator.addOperatorToRegistry(finishedByOp, false);
            NOT_FINISHED_BY = Operator.addOperatorToRegistry(finishedByOp, true);
            SUPPORTED_IDS = new String[]{finishedByOp};
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cache = (Map)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.cache);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.HANDLE, EvaluatorDefinition.Target.HANDLE);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        String key;
        FinishedByEvaluator eval;
        if (this.cache == Collections.EMPTY_MAP) {
            this.cache = new HashMap<String, FinishedByEvaluator>();
        }
        if ((eval = this.cache.get(key = isNegated + ":" + parameterText)) == null) {
            Long[] params = this.parser.parse(parameterText);
            eval = new FinishedByEvaluator(type, isNegated, params, parameterText);
            this.cache.put(key, eval);
        }
        return eval;
    }

    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    public boolean isNegatable() {
        return true;
    }

    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.HANDLE;
    }

    public boolean supportsType(ValueType type) {
        return true;
    }

    public static class FinishedByEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 510L;
        private long endDev;
        private String paramText;

        public FinishedByEvaluator() {
            FinishedByEvaluatorDefinition.init();
        }

        public FinishedByEvaluator(ValueType type, boolean isNegated, Long[] parameters, String paramText) {
            super(type, isNegated ? NOT_FINISHED_BY : FINISHED_BY);
            FinishedByEvaluatorDefinition.init();
            this.paramText = paramText;
            this.setParameters(parameters);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.endDev = in.readLong();
            this.paramText = (String)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeLong(this.endDev);
            out.writeObject(this.paramText);
        }

        public boolean isTemporal() {
            return true;
        }

        public Interval getInterval() {
            if (this.getOperator().isNegated()) {
                return new Interval(Long.MIN_VALUE, Long.MAX_VALUE);
            }
            return new Interval(Long.MIN_VALUE, 0L);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, InternalFactHandle object1, FieldValue object2) {
            throw new RuntimeDroolsException("The 'finishedby' operator can only be used to compare one event to another, and never to compare to literal constraints.");
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, InternalFactHandle left) {
            if (context.rightNull || context.declaration.getExtractor().isNullValue(workingMemory, left.getObject())) {
                return false;
            }
            long distStart = ((EventFactHandle)left).getStartTimestamp() - ((VariableRestriction.TemporalVariableContextEntry)context).startTS;
            long distEnd = Math.abs(((EventFactHandle)left).getEndTimestamp() - ((VariableRestriction.TemporalVariableContextEntry)context).endTS);
            return this.getOperator().isNegated() ^ (distStart > 0L && distEnd <= this.endDev);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, InternalFactHandle right) {
            if (context.leftNull || context.extractor.isNullValue(workingMemory, right.getObject())) {
                return false;
            }
            long distStart = ((VariableRestriction.TemporalVariableContextEntry)context).startTS - ((EventFactHandle)right).getStartTimestamp();
            long distEnd = Math.abs(((VariableRestriction.TemporalVariableContextEntry)context).endTS - ((EventFactHandle)right).getEndTimestamp());
            return this.getOperator().isNegated() ^ (distStart > 0L && distEnd <= this.endDev);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, InternalFactHandle handle1, InternalReadAccessor extractor2, InternalFactHandle handle2) {
            if (extractor1.isNullValue(workingMemory, handle1.getObject()) || extractor2.isNullValue(workingMemory, handle2.getObject())) {
                return false;
            }
            long distStart = ((EventFactHandle)handle2).getStartTimestamp() - ((EventFactHandle)handle1).getStartTimestamp();
            long distEnd = Math.abs(((EventFactHandle)handle2).getEndTimestamp() - ((EventFactHandle)handle1).getEndTimestamp());
            return this.getOperator().isNegated() ^ (distStart > 0L && distEnd <= this.endDev);
        }

        public String toString() {
            return "finishedby[" + (this.paramText != null ? this.paramText : "") + "]";
        }

        public int hashCode() {
            int PRIME = 31;
            int result = super.hashCode();
            result = 31 * result + (int)(this.endDev ^ this.endDev >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FinishedByEvaluator other = (FinishedByEvaluator)obj;
            return this.endDev == other.endDev;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void setParameters(Long[] parameters) {
            if (parameters == null || parameters.length == 0) {
                this.endDev = 0L;
                return;
            } else {
                if (parameters.length != 1) throw new RuntimeDroolsException("[FinishedBy Evaluator]: Not possible to use " + parameters.length + " parameters: '" + this.paramText + "'");
                if (parameters[0] < 0L) throw new RuntimeDroolsException("[FinishedBy Evaluator]: Not possible to use negative parameter: '" + this.paramText + "'");
                this.endDev = parameters[0];
            }
        }
    }
}

