/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.drools.RuleBaseConfiguration;
import org.drools.base.ClassObjectType;
import org.drools.base.DroolsQuery;
import org.drools.common.BetaConstraints;
import org.drools.common.EmptyBetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.Memory;
import org.drools.common.NodeMemory;
import org.drools.common.UpdateContext;
import org.drools.core.util.FastIterator;
import org.drools.core.util.LinkedList;
import org.drools.core.util.index.LeftTupleList;
import org.drools.marshalling.impl.PersisterHelper;
import org.drools.marshalling.impl.ProtobufInputMarshaller;
import org.drools.marshalling.impl.ProtobufMessages;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.ClassObjectTypeConf;
import org.drools.reteoo.FromNodeLeftTuple;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSinkNode;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.NodeSet;
import org.drools.reteoo.ObjectTypeConf;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.ContextEntry;
import org.drools.rule.From;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.DataProvider;
import org.drools.spi.PropagationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FromNode
extends LeftTupleSource
implements LeftTupleSinkNode,
NodeMemory {
    private static final long serialVersionUID = 510L;
    protected DataProvider dataProvider;
    protected LeftTupleSource tupleSource;
    protected AlphaNodeFieldConstraint[] alphaConstraints;
    protected BetaConstraints betaConstraints;
    protected LeftTupleSinkNode previousTupleSinkNode;
    protected LeftTupleSinkNode nextTupleSinkNode;
    protected From from;
    protected Class<?> resultClass;
    protected boolean tupleMemoryEnabled;
    protected transient ObjectTypeConf objectTypeConf;

    public FromNode() {
    }

    public FromNode(int id, DataProvider dataProvider, LeftTupleSource tupleSource, AlphaNodeFieldConstraint[] constraints, BetaConstraints binder, boolean tupleMemoryEnabled, BuildContext context, From from) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation());
        this.dataProvider = dataProvider;
        this.tupleSource = tupleSource;
        this.alphaConstraints = constraints;
        this.betaConstraints = binder == null ? EmptyBetaConstraints.getInstance() : binder;
        this.tupleMemoryEnabled = tupleMemoryEnabled;
        this.from = from;
        this.resultClass = ((ClassObjectType)this.from.getResultPattern().getObjectType()).getClassType();
        this.initMasks(context, tupleSource);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.dataProvider = (DataProvider)in.readObject();
        this.tupleSource = (LeftTupleSource)in.readObject();
        this.alphaConstraints = (AlphaNodeFieldConstraint[])in.readObject();
        this.betaConstraints = (BetaConstraints)in.readObject();
        this.tupleMemoryEnabled = in.readBoolean();
        this.from = (From)in.readObject();
        this.resultClass = ((ClassObjectType)this.from.getResultPattern().getObjectType()).getClassType();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.dataProvider);
        out.writeObject(this.tupleSource);
        out.writeObject(this.alphaConstraints);
        out.writeObject(this.betaConstraints);
        out.writeBoolean(this.tupleMemoryEnabled);
        out.writeObject(this.from);
    }

    @Override
    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        Object object;
        FromMemory memory = (FromMemory)workingMemory.getNodeMemory(this);
        LinkedHashMap<Object, RightTuple> matches = null;
        boolean useLeftMemory = true;
        if (!(this.tupleMemoryEnabled || (object = leftTuple.get(0).getObject()) instanceof DroolsQuery && ((DroolsQuery)object).isOpen())) {
            useLeftMemory = false;
        }
        if (useLeftMemory) {
            memory.betaMemory.getLeftTupleMemory().add(leftTuple);
            matches = new LinkedHashMap<Object, RightTuple>();
            leftTuple.setObject(matches);
        }
        this.betaConstraints.updateFromTuple(memory.betaMemory.getContext(), workingMemory, leftTuple);
        Iterator it = this.dataProvider.getResults(leftTuple, workingMemory, context, memory.providerContext);
        while (it.hasNext()) {
            Object object2 = it.next();
            if (object2 == null || !this.resultClass.isAssignableFrom(object2.getClass())) continue;
            RightTuple rightTuple = this.createRightTuple(leftTuple, context, workingMemory, object2);
            this.checkConstraintsAndPropagate(leftTuple, rightTuple, context, workingMemory, memory, useLeftMemory);
            if (!useLeftMemory) continue;
            this.addToCreatedHandlesMap(matches, rightTuple);
        }
        this.betaConstraints.resetTuple(memory.betaMemory.getContext());
    }

    protected RightTuple createRightTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory, Object object) {
        Map map;
        InternalFactHandle handle = null;
        ProtobufMessages.FactHandle _handle = null;
        if (this.objectTypeConf == null) {
            this.objectTypeConf = new ClassObjectTypeConf(workingMemory.getEntryPoint(), this.resultClass, (InternalRuleBase)workingMemory.getRuleBase());
        }
        if (context.getReaderContext() != null && (map = (Map)context.getReaderContext().nodeMemories.get(this.getId())) != null) {
            ProtobufInputMarshaller.TupleKey key = PersisterHelper.createTupleKey(leftTuple);
            List list = (List)map.get(key);
            if (list.isEmpty()) {
                map.remove(key);
            } else {
                _handle = (ProtobufMessages.FactHandle)((java.util.LinkedList)list).removeFirst();
            }
        }
        handle = _handle != null ? workingMemory.getFactHandleFactory().newFactHandle(_handle.getId(), object, _handle.getRecency(), this.objectTypeConf, workingMemory, null) : workingMemory.getFactHandleFactory().newFactHandle(object, this.objectTypeConf, workingMemory, null);
        RightTuple rightTuple = this.newRightTuple(handle, null);
        return rightTuple;
    }

    protected RightTuple newRightTuple(InternalFactHandle handle, Object o) {
        return new RightTuple(handle, null);
    }

    private void addToCreatedHandlesMap(Map<Object, RightTuple> matches, RightTuple rightTuple) {
        if (rightTuple.getFactHandle().isValid()) {
            Object object = rightTuple.getFactHandle().getObject();
            RightTuple existingMatch = matches.get(object);
            if (existingMatch != null) {
                rightTuple.setNext(existingMatch);
            }
            matches.put(object, rightTuple);
        }
    }

    @Override
    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        FromMemory memory = (FromMemory)workingMemory.getNodeMemory(this);
        memory.betaMemory.getLeftTupleMemory().removeAdd(leftTuple);
        Map previousMatches = (Map)leftTuple.getObject();
        HashMap<Object, RightTuple> newMatches = new HashMap<Object, RightTuple>();
        leftTuple.setObject(newMatches);
        this.betaConstraints.updateFromTuple(memory.betaMemory.getContext(), workingMemory, leftTuple);
        FastIterator rightIt = LinkedList.fastIterator;
        Iterator it = this.dataProvider.getResults(leftTuple, workingMemory, context, memory.providerContext);
        while (it.hasNext()) {
            Object object = it.next();
            if (!this.resultClass.isAssignableFrom(object.getClass())) continue;
            RightTuple rightTuple = (RightTuple)previousMatches.remove(object);
            if (rightTuple == null) {
                rightTuple = this.createRightTuple(leftTuple, context, workingMemory, object);
            } else if (rightIt.next(rightTuple) != null) {
                previousMatches.put(object, (RightTuple)rightIt.next(rightTuple));
                rightTuple.setNext(null);
            }
            this.checkConstraintsAndPropagate(leftTuple, rightTuple, context, workingMemory, memory, true);
            this.addToCreatedHandlesMap(newMatches, rightTuple);
        }
        this.betaConstraints.resetTuple(memory.betaMemory.getContext());
        Iterator i$ = previousMatches.values().iterator();
        while (i$.hasNext()) {
            RightTuple rightTuple;
            RightTuple current = rightTuple = (RightTuple)i$.next();
            while (current != null) {
                this.retractMatch(leftTuple, current, context, workingMemory);
                current = (RightTuple)rightIt.next(current);
            }
        }
    }

    protected void checkConstraintsAndPropagate(LeftTuple leftTuple, RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory, FromMemory memory, boolean useLeftMemory) {
        boolean isAllowed = true;
        if (this.alphaConstraints != null) {
            int length = this.alphaConstraints.length;
            for (int i = 0; i < length; ++i) {
                if (this.alphaConstraints[i].isAllowed(rightTuple.getFactHandle(), workingMemory, memory.alphaContexts[i])) continue;
                isAllowed = false;
                break;
            }
        }
        if (isAllowed && this.betaConstraints.isAllowedCachedLeft(memory.betaMemory.getContext(), rightTuple.getFactHandle())) {
            if (rightTuple.firstChild == null) {
                this.sink.propagateAssertLeftTuple(leftTuple, rightTuple, null, null, context, workingMemory, useLeftMemory);
            } else {
                this.sink.propagateModifyChildLeftTuple(rightTuple.firstChild, leftTuple, context, workingMemory, useLeftMemory);
            }
        } else {
            this.retractMatch(leftTuple, rightTuple, context, workingMemory);
        }
    }

    protected void retractMatch(LeftTuple leftTuple, RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (rightTuple.firstChild != null) {
            this.sink.propagateRetractChildLeftTuple(rightTuple.firstChild, leftTuple, context, workingMemory);
        }
    }

    @Override
    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        FromMemory memory = (FromMemory)workingMemory.getNodeMemory(this);
        memory.betaMemory.getLeftTupleMemory().remove(leftTuple);
        this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
        this.unlinkCreatedHandles(workingMemory, memory, leftTuple);
    }

    private void unlinkCreatedHandles(InternalWorkingMemory workingMemory, FromMemory memory, LeftTuple leftTuple) {
        Map matches = (Map)leftTuple.getObject();
        FastIterator rightIt = LinkedList.fastIterator;
        Iterator i$ = matches.values().iterator();
        while (i$.hasNext()) {
            RightTuple rightTuple;
            RightTuple current = rightTuple = (RightTuple)i$.next();
            while (current != null) {
                RightTuple next = (RightTuple)rightIt.next(current);
                current.unlinkFromRightParent();
                current = next;
            }
        }
    }

    @Override
    public void attach(BuildContext context) {
        this.betaConstraints.init(context, this.getType());
        this.tupleSource.addTupleSink(this, context);
    }

    @Override
    public void updateSinkOnAttach(BuildContext context, PropagationContext propagationContext, InternalWorkingMemory workingMemory) {
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.tupleSource.networkUpdated(updateContext);
    }

    @Override
    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, InternalWorkingMemory[] workingMemories) {
        if (!this.isInUse()) {
            for (InternalWorkingMemory workingMemory : workingMemories) {
                FromMemory memory = (FromMemory)workingMemory.getNodeMemory(this);
                org.drools.core.util.Iterator it = memory.betaMemory.getLeftTupleMemory().iterator();
                LeftTuple leftTuple = (LeftTuple)it.next();
                while (leftTuple != null) {
                    this.unlinkCreatedHandles(workingMemory, memory, leftTuple);
                    leftTuple.unlinkFromLeftParent();
                    leftTuple.unlinkFromRightParent();
                    leftTuple = (LeftTuple)it.next();
                }
                workingMemory.clearNodeMemory(this);
            }
            this.tupleSource.removeTupleSink(this);
        }
    }

    @Override
    protected void doCollectAncestors(NodeSet nodeSet) {
        this.tupleSource.collectAncestors(nodeSet);
    }

    @Override
    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        FromMemory memory = (FromMemory)workingMemory.getNodeMemory(this);
        FastIterator rightIter = LinkedList.fastIterator;
        org.drools.core.util.Iterator tupleIter = memory.betaMemory.getLeftTupleMemory().iterator();
        LeftTuple leftTuple = (LeftTuple)tupleIter.next();
        while (leftTuple != null) {
            this.betaConstraints.updateFromTuple(memory.betaMemory.getContext(), workingMemory, leftTuple);
            Map matches = (Map)leftTuple.getObject();
            Iterator i$ = matches.values().iterator();
            while (i$.hasNext()) {
                RightTuple rightTuples;
                RightTuple rightTuple = rightTuples = (RightTuple)i$.next();
                while (rightTuple != null) {
                    boolean isAllowed = true;
                    if (this.alphaConstraints != null) {
                        int length = this.alphaConstraints.length;
                        for (int i = 0; i < length; ++i) {
                            if (this.alphaConstraints[i].isAllowed(rightTuple.getFactHandle(), workingMemory, memory.alphaContexts[i])) continue;
                            isAllowed = false;
                            break;
                        }
                    }
                    if (isAllowed && this.betaConstraints.isAllowedCachedLeft(memory.betaMemory.getContext(), rightTuple.getFactHandle())) {
                        sink.assertLeftTuple(sink.createLeftTuple(leftTuple, rightTuple, null, null, sink, this.tupleMemoryEnabled), context, workingMemory);
                    }
                    rightTuple = (RightTuple)rightIter.next(rightTuple);
                }
            }
            this.betaConstraints.resetTuple(memory.betaMemory.getContext());
            leftTuple = (LeftTuple)tupleIter.next();
        }
    }

    @Override
    public Memory createMemory(RuleBaseConfiguration config) {
        BetaMemory beta = new BetaMemory(new LeftTupleList(), null, this.betaConstraints.createContext(), 4);
        return new FromMemory(beta, this.dataProvider.createContext(), this.alphaConstraints);
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    @Override
    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    @Override
    public short getType() {
        return 4;
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new FromNodeLeftTuple(factHandle, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new FromNodeLeftTuple(leftTuple, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSink sink) {
        return new FromNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new FromNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTupleSource getLeftTupleSource() {
        return this.tupleSource;
    }

    @Override
    protected ObjectTypeNode getObjectTypeNode() {
        return this.tupleSource.getObjectTypeNode();
    }

    public static class FromMemory
    implements Serializable,
    Memory {
        private static final long serialVersionUID = 510L;
        public BetaMemory betaMemory;
        public Object providerContext;
        public ContextEntry[] alphaContexts;

        public FromMemory(BetaMemory betaMemory, Object providerContext, AlphaNodeFieldConstraint[] constraints) {
            this.betaMemory = betaMemory;
            this.providerContext = providerContext;
            this.alphaContexts = new ContextEntry[constraints.length];
            for (int i = 0; i < constraints.length; ++i) {
                this.alphaContexts[i] = constraints[i].createContextEntry();
            }
        }

        public short getNodeType() {
            return 4;
        }
    }
}

