/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.drools.util.AbstractCodedHierarchyImpl;
import org.drools.util.CodedHierarchyImpl;
import org.drools.util.HierarchyEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchyEncoderImpl<T>
extends CodedHierarchyImpl<T>
implements HierarchyEncoder<T>,
Externalizable {
    private ImmutableBitSet bottom = new ImmutableBitSet();

    @Override
    public BitSet getBottom() {
        return this.bottom;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.bottom);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.bottom = (ImmutableBitSet)objectInput.readObject();
    }

    @Override
    public BitSet encode(T member, Collection<T> parents) {
        BitSet existing = this.getCode(member);
        if (existing != null) {
            return existing;
        }
        AbstractCodedHierarchyImpl.HierNode<T> node = new AbstractCodedHierarchyImpl.HierNode<T>(member);
        Set<AbstractCodedHierarchyImpl.HierNode<T>> parentNodes = this.floor(parents);
        for (AbstractCodedHierarchyImpl.HierNode<T> parentNode : parentNodes) {
            node.addParent(parentNode);
            parentNode.addChild(node);
        }
        this.encode(node);
        this.add(node);
        return node.getBitMask();
    }

    @Override
    protected void add(AbstractCodedHierarchyImpl.HierNode<T> node) {
        super.add(node);
        this.bottom.merge(node.getBitMask());
    }

    @Override
    public void clear() {
        super.clear();
        this.bottom = new ImmutableBitSet();
    }

    List<T> ancestorValues(T name) {
        ArrayList<T> anx = new ArrayList<T>();
        Set<AbstractCodedHierarchyImpl.HierNode<T>> nodes = this.ancestorNodes(this.getNode(name));
        for (AbstractCodedHierarchyImpl.HierNode<T> node : nodes) {
            anx.add(node.getValue());
        }
        return anx;
    }

    protected void encode(AbstractCodedHierarchyImpl.HierNode<T> node) {
        Collection<AbstractCodedHierarchyImpl.HierNode<T>> parents = node.getParents();
        switch (parents.size()) {
            case 0: {
                BitSet zero = new BitSet();
                if (this.hasKey(zero)) {
                    AbstractCodedHierarchyImpl.HierNode<Object> root = this.getNodeByKey(zero);
                    if (root.getValue() != null) {
                        this.fixedRoot = true;
                        AbstractCodedHierarchyImpl.HierNode<Object> previousRoot = root;
                        root = new AbstractCodedHierarchyImpl.HierNode<Object>((Object)null);
                        root.addChild(previousRoot);
                        previousRoot.addParent(root);
                        root.setBitMask(zero);
                        this.propagate(previousRoot, this.freeBit(root));
                        this.add(root);
                    }
                    node.addParent(root);
                    this.updateMask(node, this.increment(root.getBitMask(), this.freeBit(root)));
                    break;
                }
                this.updateMask(node, new BitSet());
                break;
            }
            case 1: {
                AbstractCodedHierarchyImpl.HierNode<T> parent = parents.iterator().next();
                this.updateMask(node, this.increment(parent.getBitMask(), this.freeBit(parent)));
                break;
            }
            default: {
                this.inheritMerged(node);
                this.resolveConflicts(node);
            }
        }
    }

    protected void resolveConflicts(AbstractCodedHierarchyImpl.HierNode<T> x) {
        boolean conflicted = false;
        ArrayList nodes = new ArrayList(this.getNodes());
        for (AbstractCodedHierarchyImpl.HierNode hierNode : nodes) {
            int sub;
            if (!this.incomparable(x, hierNode)) continue;
            int sup = this.superset(hierNode, x);
            if (sup == 0) {
                x.setBitMask(this.increment(x.getBitMask(), this.freeBit(x)));
                this.propagate(hierNode, this.freeBit(x, hierNode));
            }
            if (sup > 0) {
                this.updateMask(x, this.increment(x.getBitMask(), this.freeBit(x)));
            }
            if ((sub = this.superset(x, hierNode)) <= 0) continue;
            this.modify(x, hierNode);
            conflicted = true;
        }
        if (conflicted) {
            this.inheritMerged(x);
            this.resolveConflicts(x);
        }
    }

    protected void modify(AbstractCodedHierarchyImpl.HierNode<T> x, AbstractCodedHierarchyImpl.HierNode<T> y) {
        int i = this.freeBit(x, y);
        Collection<AbstractCodedHierarchyImpl.HierNode<T>> py = y.getParents();
        BitSet t = new BitSet(y.getBitMask().length());
        for (AbstractCodedHierarchyImpl.HierNode<T> parent : py) {
            t.or(parent.getBitMask());
        }
        BitSet d = this.singleBitDiff(t, y.getBitMask());
        int inDex = d.nextSetBit(0);
        if (inDex < 0) {
            this.propagate(y, i);
        } else {
            Set<AbstractCodedHierarchyImpl.HierNode<T>> ancestors = this.ancestorNodes(x);
            HashSet<AbstractCodedHierarchyImpl.HierNode<T>> affectedAncestors = new HashSet<AbstractCodedHierarchyImpl.HierNode<T>>();
            for (AbstractCodedHierarchyImpl.HierNode<T> anc : ancestors) {
                if (!anc.getBitMask().get(inDex)) continue;
                affectedAncestors.add(anc);
            }
            if (affectedAncestors.size() == 0) {
                return;
            }
            Set<AbstractCodedHierarchyImpl.HierNode<T>> gcs = this.gcs(affectedAncestors);
            HashSet<AbstractCodedHierarchyImpl.HierNode<T>> affectedDescendants = new HashSet<AbstractCodedHierarchyImpl.HierNode<T>>();
            for (AbstractCodedHierarchyImpl.HierNode<T> g : gcs) {
                affectedDescendants.addAll(this.descendantNodes(g));
            }
            affectedDescendants.remove(x);
            int dx = this.firstOne(d);
            if (this.bottom.get(i)) {
                i = this.freeBit(new AbstractCodedHierarchyImpl.HierNode(this.bottom));
            }
            for (AbstractCodedHierarchyImpl.HierNode hierNode : affectedDescendants) {
                boolean keepsBit = false;
                for (AbstractCodedHierarchyImpl.HierNode sup : hierNode.getParents()) {
                    if (keepsBit || affectedDescendants.contains(sup) || !sup.getBitMask().get(inDex)) continue;
                    keepsBit = true;
                }
                BitSet subMask = hierNode.getBitMask();
                if (!keepsBit) {
                    subMask = this.decrement(subMask, dx);
                }
                subMask = this.increment(subMask, i);
                this.updateMask(hierNode, subMask);
            }
            inDex = d.nextSetBit(inDex + 1);
        }
    }

    protected void updateMask(AbstractCodedHierarchyImpl.HierNode<T> node, BitSet mask) {
        boolean in;
        boolean bl = in = node.getBitMask() != null && this.contains(node);
        if (in) {
            this.remove(node);
        }
        node.setBitMask(mask);
        if (in) {
            this.add(node);
        }
    }

    protected void inheritMerged(AbstractCodedHierarchyImpl.HierNode<T> x) {
        BitSet mask = new BitSet(x.getBitMask() != null ? x.getBitMask().length() : 1);
        for (AbstractCodedHierarchyImpl.HierNode<T> p : x.getParents()) {
            mask.or(p.getBitMask());
        }
        this.updateMask(x, mask);
    }

    protected Set<AbstractCodedHierarchyImpl.HierNode<T>> gcs(Set<AbstractCodedHierarchyImpl.HierNode<T>> set) {
        HashSet<AbstractCodedHierarchyImpl.HierNode<T>> s = new HashSet<AbstractCodedHierarchyImpl.HierNode<T>>();
        Iterator<AbstractCodedHierarchyImpl.HierNode<T>> iter = set.iterator();
        BitSet a = new BitSet(this.size());
        a.or(iter.next().getBitMask());
        while (iter.hasNext()) {
            a.and(iter.next().getBitMask());
        }
        for (AbstractCodedHierarchyImpl.HierNode node : this.getNodes()) {
            if (this.superset(node.getBitMask(), a) < 0) continue;
            s.add(node);
        }
        Set<AbstractCodedHierarchyImpl.HierNode<T>> cl = this.ceil(s);
        return cl;
    }

    protected Set<AbstractCodedHierarchyImpl.HierNode<T>> ceil(Set<AbstractCodedHierarchyImpl.HierNode<T>> s) {
        if (s.size() <= 1) {
            return s;
        }
        HashSet<AbstractCodedHierarchyImpl.HierNode<T>> ceil = new HashSet<AbstractCodedHierarchyImpl.HierNode<T>>(s);
        block0: for (AbstractCodedHierarchyImpl.HierNode<T> x : s) {
            for (AbstractCodedHierarchyImpl.HierNode<T> y : s) {
                if (this.superset(x, y) <= 0) continue;
                ceil.remove(x);
                continue block0;
            }
        }
        return ceil;
    }

    protected Set<AbstractCodedHierarchyImpl.HierNode<T>> floor(Set<AbstractCodedHierarchyImpl.HierNode<T>> s) {
        if (s.size() <= 1) {
            return s;
        }
        HashSet<AbstractCodedHierarchyImpl.HierNode<T>> ceil = new HashSet<AbstractCodedHierarchyImpl.HierNode<T>>(s);
        block0: for (AbstractCodedHierarchyImpl.HierNode<T> x : s) {
            for (AbstractCodedHierarchyImpl.HierNode<T> y : s) {
                if (this.superset(y, x) <= 0) continue;
                ceil.remove(x);
                continue block0;
            }
        }
        return ceil;
    }

    private Set<AbstractCodedHierarchyImpl.HierNode<T>> floor(Collection<T> parents) {
        HashSet<AbstractCodedHierarchyImpl.HierNode<T>> floor = new HashSet<AbstractCodedHierarchyImpl.HierNode<T>>();
        HashSet<AbstractCodedHierarchyImpl.HierNode<T>> subs = new HashSet<AbstractCodedHierarchyImpl.HierNode<T>>();
        for (T s : parents) {
            AbstractCodedHierarchyImpl.HierNode<T> x = this.getNode(s);
            subs.addAll(floor);
            boolean minimal = true;
            for (AbstractCodedHierarchyImpl.HierNode hierNode : subs) {
                if (this.superset(x, hierNode) > 0) {
                    floor.remove(hierNode);
                }
                if (this.superset(hierNode, x) <= 0) continue;
                minimal = false;
                break;
            }
            if (minimal) {
                floor.add(x);
            }
            subs.clear();
        }
        return floor;
    }

    protected void propagate(AbstractCodedHierarchyImpl.HierNode<T> y, int bit) {
        Set<AbstractCodedHierarchyImpl.HierNode<T>> descendants = this.descendantNodes(y);
        for (AbstractCodedHierarchyImpl.HierNode<T> s : descendants) {
            this.updateMask(s, this.increment(s.getBitMask(), bit));
        }
    }

    protected int freeBit(AbstractCodedHierarchyImpl.HierNode<T> x) {
        return this.freeBit(x, null);
    }

    protected int freeBit(AbstractCodedHierarchyImpl.HierNode<T> x, AbstractCodedHierarchyImpl.HierNode<T> z) {
        BitSet forbid = new BitSet(this.size());
        forbid.or(x.getBitMask());
        for (AbstractCodedHierarchyImpl.HierNode y : this.getNodes()) {
            if (this.superset(y, x) > 0) {
                forbid.or(y.getBitMask());
            }
            if (z != null && this.superset(y, z) > 0) {
                forbid.or(y.getBitMask());
            }
            if (this.superset(x, y) >= 0) continue;
            BitSet diff = this.singleBitDiff(x.getBitMask(), y.getBitMask());
            forbid.or(diff);
        }
        return this.firstZero(forbid);
    }

    protected boolean incomparable(AbstractCodedHierarchyImpl.HierNode<T> c1, AbstractCodedHierarchyImpl.HierNode<T> c2) {
        if (c1 == c2) {
            return false;
        }
        Set<AbstractCodedHierarchyImpl.HierNode<T>> sup1 = this.ancestorNodes(c1);
        Set<AbstractCodedHierarchyImpl.HierNode<T>> sup2 = this.ancestorNodes(c2);
        return !sup1.contains(c2) && !sup2.contains(c1);
    }

    BitSet increment(BitSet id, int i) {
        BitSet x = new BitSet(Math.max(i + 1, id.length()));
        x.or(id);
        x.set(i);
        return x;
    }

    BitSet decrement(BitSet id, int d) {
        BitSet x = new BitSet(id.length());
        x.or(id);
        x.clear(d);
        return x;
    }

    BitSet singleBitDiff(BitSet x, BitSet y) {
        BitSet t = new BitSet(x.length());
        t.or(x);
        t.flip(0, t.size());
        t.and(y);
        switch (t.cardinality()) {
            case 0: {
                return t;
            }
            case 1: {
                return t;
            }
        }
        return new BitSet();
    }

    int firstOne(BitSet t) {
        return t.nextSetBit(0);
    }

    int firstZero(BitSet t) {
        return t.nextClearBit(0);
    }

    private class ImmutableBitSet
    extends BitSet {
        private ImmutableBitSet() {
        }

        public void flip(int bitIndex) {
            throw new UnsupportedOperationException("Read Only");
        }

        public void flip(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException("Read Only");
        }

        public void set(int bitIndex) {
            throw new UnsupportedOperationException("Read Only");
        }

        public void set(int bitIndex, boolean value) {
            throw new UnsupportedOperationException("Read Only");
        }

        public void set(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException("Read Only");
        }

        public void set(int fromIndex, int toIndex, boolean value) {
            throw new UnsupportedOperationException("Read Only");
        }

        public void clear(int bitIndex) {
            throw new UnsupportedOperationException("Read Only");
        }

        public void clear(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException("Read Only");
        }

        public void clear() {
            throw new UnsupportedOperationException("Read Only");
        }

        public void and(BitSet set) {
            throw new UnsupportedOperationException("Read Only");
        }

        public void or(BitSet set) {
            throw new UnsupportedOperationException("Read Only");
        }

        public void xor(BitSet set) {
            throw new UnsupportedOperationException("Read Only");
        }

        public void andNot(BitSet set) {
            throw new UnsupportedOperationException("Read Only");
        }

        protected void merge(BitSet set) {
            super.or(set);
        }
    }
}

