/*
 * Decompiled with CFR 0.152.
 */
package org.drools;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.drools.ActivationListenerFactory;
import org.drools.QueryActivationListenerFactory;
import org.drools.RuleActivationListenerFactory;
import org.drools.RuntimeDroolsException;
import org.drools.common.AgendaGroupFactory;
import org.drools.common.ArrayAgendaGroupFactory;
import org.drools.common.PriorityQueueAgendaGroupFactory;
import org.drools.conflict.DepthConflictResolver;
import org.drools.core.util.ConfFileUtils;
import org.drools.core.util.StringUtils;
import org.drools.reteoo.ReteooComponentFactory;
import org.drools.runtime.rule.impl.DefaultConsequenceExceptionHandler;
import org.drools.spi.ConflictResolver;
import org.kie.KieBaseConfiguration;
import org.kie.builder.conf.ClassLoaderCacheOption;
import org.kie.builder.conf.DeclarativeAgendaOption;
import org.kie.builder.conf.LRUnlinkingOption;
import org.kie.conf.AlphaThresholdOption;
import org.kie.conf.CompositeKeyDepthOption;
import org.kie.conf.ConsequenceExceptionHandlerOption;
import org.kie.conf.EqualityBehaviorOption;
import org.kie.conf.EventProcessingOption;
import org.kie.conf.IndexLeftBetaMemoryOption;
import org.kie.conf.IndexPrecedenceOption;
import org.kie.conf.IndexRightBetaMemoryOption;
import org.kie.conf.KieBaseOption;
import org.kie.conf.MBeansOption;
import org.kie.conf.MaxThreadsOption;
import org.kie.conf.MultiValueKnowledgeBaseOption;
import org.kie.conf.MultithreadEvaluationOption;
import org.kie.conf.PermGenThresholdOption;
import org.kie.conf.RemoveIdentitiesOption;
import org.kie.conf.SequentialAgendaOption;
import org.kie.conf.SequentialOption;
import org.kie.conf.ShareAlphaNodesOption;
import org.kie.conf.ShareBetaNodesOption;
import org.kie.conf.SingleValueKieBaseOption;
import org.kie.internal.utils.ChainedProperties;
import org.kie.internal.utils.ClassLoaderUtil;
import org.kie.internal.utils.CompositeClassLoader;
import org.mvel2.MVEL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleBaseConfiguration
implements KieBaseConfiguration,
Externalizable {
    private static final long serialVersionUID = 510L;
    public static final String DEFAULT_SIGN_ON_SERIALIZATION = "false";
    protected static transient Logger logger = LoggerFactory.getLogger(RuleBaseConfiguration.class);
    private ChainedProperties chainedProperties;
    private boolean immutable;
    private boolean sequential;
    private SequentialAgenda sequentialAgenda;
    private boolean maintainTms;
    private boolean removeIdentities;
    private boolean shareAlphaNodes;
    private boolean shareBetaNodes;
    private int permGenThreshold;
    private int alphaNodeHashingThreshold;
    private int compositeKeyDepth;
    private boolean indexLeftBetaMemory;
    private boolean indexRightBetaMemory;
    private AssertBehaviour assertBehaviour;
    private String executorService;
    private String consequenceExceptionHandler;
    private String ruleBaseUpdateHandler;
    private boolean classLoaderCacheEnabled;
    private boolean unlinkingEnabled;
    private boolean declarativeAgenda;
    private EventProcessingOption eventProcessingMode;
    private IndexPrecedenceOption indexPrecedenceOption;
    private boolean multithread;
    private int maxThreads;
    private boolean mbeansEnabled;
    private ConflictResolver conflictResolver;
    private Map<String, ActivationListenerFactory> activationListeners;
    private List<Map<String, Object>> workDefinitions;
    private boolean advancedProcessRuleIntegration;
    private transient CompositeClassLoader classLoader;
    private ReteooComponentFactory componentFactory;
    private static final RuleBaseConfiguration defaultConf = new RuleBaseConfiguration();

    public static RuleBaseConfiguration getDefaultInstance() {
        return defaultConf;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.chainedProperties);
        out.writeBoolean(this.immutable);
        out.writeBoolean(this.sequential);
        out.writeObject(this.sequentialAgenda);
        out.writeBoolean(this.maintainTms);
        out.writeBoolean(this.removeIdentities);
        out.writeBoolean(this.shareAlphaNodes);
        out.writeBoolean(this.shareBetaNodes);
        out.writeInt(this.permGenThreshold);
        out.writeInt(this.alphaNodeHashingThreshold);
        out.writeInt(this.compositeKeyDepth);
        out.writeBoolean(this.indexLeftBetaMemory);
        out.writeBoolean(this.indexRightBetaMemory);
        out.writeObject(this.indexPrecedenceOption);
        out.writeObject(this.assertBehaviour);
        out.writeObject(this.executorService);
        out.writeObject(this.consequenceExceptionHandler);
        out.writeObject(this.ruleBaseUpdateHandler);
        out.writeObject(this.conflictResolver);
        out.writeBoolean(this.advancedProcessRuleIntegration);
        out.writeBoolean(this.multithread);
        out.writeInt(this.maxThreads);
        out.writeObject(this.eventProcessingMode);
        out.writeBoolean(this.classLoaderCacheEnabled);
        out.writeBoolean(this.unlinkingEnabled);
        out.writeBoolean(this.declarativeAgenda);
        out.writeObject(this.componentFactory);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.chainedProperties = (ChainedProperties)in.readObject();
        this.immutable = in.readBoolean();
        this.sequential = in.readBoolean();
        this.sequentialAgenda = (SequentialAgenda)in.readObject();
        this.maintainTms = in.readBoolean();
        this.removeIdentities = in.readBoolean();
        this.shareAlphaNodes = in.readBoolean();
        this.shareBetaNodes = in.readBoolean();
        this.permGenThreshold = in.readInt();
        this.alphaNodeHashingThreshold = in.readInt();
        this.compositeKeyDepth = in.readInt();
        this.indexLeftBetaMemory = in.readBoolean();
        this.indexRightBetaMemory = in.readBoolean();
        this.indexPrecedenceOption = (IndexPrecedenceOption)in.readObject();
        this.assertBehaviour = (AssertBehaviour)in.readObject();
        this.executorService = (String)in.readObject();
        this.consequenceExceptionHandler = (String)in.readObject();
        this.ruleBaseUpdateHandler = (String)in.readObject();
        this.conflictResolver = (ConflictResolver)in.readObject();
        this.advancedProcessRuleIntegration = in.readBoolean();
        this.multithread = in.readBoolean();
        this.maxThreads = in.readInt();
        this.eventProcessingMode = (EventProcessingOption)in.readObject();
        this.classLoaderCacheEnabled = in.readBoolean();
        this.unlinkingEnabled = in.readBoolean();
        this.declarativeAgenda = in.readBoolean();
        this.componentFactory = (ReteooComponentFactory)in.readObject();
    }

    public RuleBaseConfiguration(Properties properties) {
        this.init(properties, null);
    }

    public RuleBaseConfiguration() {
        this.init(null, null);
    }

    public RuleBaseConfiguration(ClassLoader ... classLoaders) {
        this.init(null, classLoaders);
    }

    @Override
    public void setProperty(String name, String value) {
        if (StringUtils.isEmpty(name = name.trim())) {
            return;
        }
        if (name.equals("drools.sequential.agenda")) {
            this.setSequentialAgenda(SequentialAgenda.determineSequentialAgenda(StringUtils.isEmpty(value) ? "sequential" : value));
        } else if (name.equals("drools.sequential")) {
            this.setSequential(StringUtils.isEmpty(value) ? false : Boolean.valueOf(value));
        } else if (name.equals("drools.removeIdentities")) {
            this.setRemoveIdentities(StringUtils.isEmpty(value) ? false : Boolean.valueOf(value));
        } else if (name.equals("drools.shareAlphaNodes")) {
            this.setShareAlphaNodes(StringUtils.isEmpty(value) ? false : Boolean.valueOf(value));
        } else if (name.equals("drools.shareBetaNodes")) {
            this.setShareBetaNodes(StringUtils.isEmpty(value) ? false : Boolean.valueOf(value));
        } else if (name.equals("drools.permgenThreshold")) {
            this.setPermGenThreshold(StringUtils.isEmpty(value) ? 90 : Integer.parseInt(value));
        } else if (name.equals("drools.alphaNodeHashingThreshold")) {
            this.setAlphaNodeHashingThreshold(StringUtils.isEmpty(value) ? 3 : Integer.parseInt(value));
        } else if (name.equals("drools.compositeKeyDepth")) {
            this.setCompositeKeyDepth(StringUtils.isEmpty(value) ? 3 : Integer.parseInt(value));
        } else if (name.equals("drools.indexLeftBetaMemory")) {
            this.setIndexLeftBetaMemory(StringUtils.isEmpty(value) ? true : Boolean.valueOf(value));
        } else if (name.equals("drools.indexRightBetaMemory")) {
            this.setIndexRightBetaMemory(StringUtils.isEmpty(value) ? true : Boolean.valueOf(value));
        } else if (name.equals("drools.indexPrecedence")) {
            this.setIndexPrecedenceOption(StringUtils.isEmpty(value) ? IndexPrecedenceOption.EQUALITY_PRIORITY : IndexPrecedenceOption.determineIndexPrecedence(value));
        } else if (name.equals("drools.equalityBehavior")) {
            this.setAssertBehaviour(AssertBehaviour.determineAssertBehaviour(StringUtils.isEmpty(value) ? "identity" : value));
        } else if (name.equals("drools.consequenceExceptionHandler")) {
            this.setConsequenceExceptionHandler(StringUtils.isEmpty(value) ? DefaultConsequenceExceptionHandler.class.getName() : value);
        } else if (name.equals("drools.ruleBaseUpdateHandler")) {
            this.setRuleBaseUpdateHandler(StringUtils.isEmpty(value) ? "" : value);
        } else if (name.equals("drools.conflictResolver")) {
            this.setConflictResolver(this.determineConflictResolver(StringUtils.isEmpty(value) ? DepthConflictResolver.class.getName() : value));
        } else if (name.equals("drools.advancedProcessRuleIntegration")) {
            this.setAdvancedProcessRuleIntegration(StringUtils.isEmpty(value) ? false : Boolean.valueOf(value));
        } else if (name.equals("drools.multithreadEvaluation")) {
            this.setMultithreadEvaluation(StringUtils.isEmpty(value) ? false : Boolean.valueOf(value));
        } else if (name.equals("drools.maxThreads")) {
            this.setMaxThreads(StringUtils.isEmpty(value) ? 3 : Integer.parseInt(value));
        } else if (name.equals("drools.eventProcessingMode")) {
            this.setEventProcessingMode(EventProcessingOption.determineEventProcessingMode(StringUtils.isEmpty(value) ? "cloud" : value));
        } else if (name.equals("kie.mbeans")) {
            this.setMBeansEnabled(MBeansOption.isEnabled(value));
        } else if (name.equals("drools.classLoaderCacheEnabled")) {
            this.setClassLoaderCacheEnabled(StringUtils.isEmpty(value) ? true : Boolean.valueOf(value));
        } else if (name.equals("drools.lrUnlinkingEnabled")) {
            this.setUnlinkingEnabled(StringUtils.isEmpty(value) ? false : Boolean.valueOf(value));
        }
    }

    @Override
    public String getProperty(String name) {
        if (StringUtils.isEmpty(name = name.trim())) {
            return null;
        }
        if (name.equals("drools.sequential.agenda")) {
            return this.getSequentialAgenda().toExternalForm();
        }
        if (name.equals("drools.sequential")) {
            return Boolean.toString(this.isSequential());
        }
        if (name.equals("drools.removeIdentities")) {
            return Boolean.toString(this.isRemoveIdentities());
        }
        if (name.equals("drools.shareAlphaNodes")) {
            return Boolean.toString(this.isShareAlphaNodes());
        }
        if (name.equals("drools.shareBetaNodes")) {
            return Boolean.toString(this.isShareBetaNodes());
        }
        if (name.equals("drools.permgenThreshold")) {
            return Integer.toString(this.getPermGenThreshold());
        }
        if (name.equals("drools.alphaNodeHashingThreshold")) {
            return Integer.toString(this.getAlphaNodeHashingThreshold());
        }
        if (name.equals("drools.compositeKeyDepth")) {
            return Integer.toString(this.getCompositeKeyDepth());
        }
        if (name.equals("drools.indexLeftBetaMemory")) {
            return Boolean.toString(this.isIndexLeftBetaMemory());
        }
        if (name.equals("drools.indexRightBetaMemory")) {
            return Boolean.toString(this.isIndexRightBetaMemory());
        }
        if (name.equals("drools.indexPrecedence")) {
            return this.getIndexPrecedenceOption().getValue();
        }
        if (name.equals("drools.equalityBehavior")) {
            return this.getAssertBehaviour().toExternalForm();
        }
        if (name.equals("drools.executorService")) {
            return this.getExecutorService();
        }
        if (name.equals("drools.consequenceExceptionHandler")) {
            return this.getConsequenceExceptionHandler();
        }
        if (name.equals("drools.ruleBaseUpdateHandler")) {
            return this.getRuleBaseUpdateHandler();
        }
        if (name.equals("drools.conflictResolver")) {
            return this.getConflictResolver().getClass().getName();
        }
        if (name.equals("drools.advancedProcessRuleIntegration")) {
            return Boolean.toString(this.isAdvancedProcessRuleIntegration());
        }
        if (name.equals("drools.multithreadEvaluation")) {
            return Boolean.toString(this.isMultithreadEvaluation());
        }
        if (name.equals("drools.maxThreads")) {
            return Integer.toString(this.getMaxThreads());
        }
        if (name.equals("drools.eventProcessingMode")) {
            return this.getEventProcessingMode().getMode();
        }
        if (name.equals("kie.mbeans")) {
            return this.isMBeansEnabled() ? "enabled" : "disabled";
        }
        if (name.equals("drools.classLoaderCacheEnabled")) {
            return Boolean.toString(this.isClassLoaderCacheEnabled());
        }
        if (name.equals("drools.lrUnlinkingEnabled")) {
            return Boolean.toString(this.isUnlinkingEnabled());
        }
        return null;
    }

    public RuleBaseConfiguration(Properties properties, ClassLoader ... classLoaders) {
        this.init(properties, classLoaders);
    }

    public RuleBaseConfiguration(Properties properties, CompositeClassLoader classLoader) {
        this.classLoader = classLoader;
        this.init(properties);
    }

    private void init(Properties properties, ClassLoader ... classLoaders) {
        this.setClassLoader(classLoaders);
        this.init(properties);
    }

    private void init(Properties properties) {
        this.immutable = false;
        this.chainedProperties = new ChainedProperties("rulebase.conf", this.classLoader, true);
        if (properties != null) {
            this.chainedProperties.addProperties(properties);
        }
        this.setSequentialAgenda(SequentialAgenda.determineSequentialAgenda(this.chainedProperties.getProperty("drools.sequential.agenda", "sequential")));
        this.setSequential(Boolean.valueOf(this.chainedProperties.getProperty("drools.sequential", DEFAULT_SIGN_ON_SERIALIZATION)));
        this.setRemoveIdentities(Boolean.valueOf(this.chainedProperties.getProperty("drools.removeIdentities", DEFAULT_SIGN_ON_SERIALIZATION)));
        this.setShareAlphaNodes(Boolean.valueOf(this.chainedProperties.getProperty("drools.shareAlphaNodes", "true")));
        this.setShareBetaNodes(Boolean.valueOf(this.chainedProperties.getProperty("drools.shareBetaNodes", "true")));
        this.setPermGenThreshold(Integer.parseInt(this.chainedProperties.getProperty("drools.permgenThreshold", "90")));
        this.setAlphaNodeHashingThreshold(Integer.parseInt(this.chainedProperties.getProperty("drools.alphaNodeHashingThreshold", "3")));
        this.setCompositeKeyDepth(Integer.parseInt(this.chainedProperties.getProperty("drools.compositeKeyDepth", "3")));
        this.setIndexLeftBetaMemory(Boolean.valueOf(this.chainedProperties.getProperty("drools.indexLeftBetaMemory", "true")));
        this.setIndexRightBetaMemory(Boolean.valueOf(this.chainedProperties.getProperty("drools.indexRightBetaMemory", "true")));
        this.setIndexPrecedenceOption(IndexPrecedenceOption.determineIndexPrecedence(this.chainedProperties.getProperty("drools.indexPrecedence", "equality")));
        this.setAssertBehaviour(AssertBehaviour.determineAssertBehaviour(this.chainedProperties.getProperty("drools.equalityBehavior", "identity")));
        this.setExecutorService(this.chainedProperties.getProperty("drools.executorService", "org.drools.concurrent.DefaultExecutorService"));
        this.setConsequenceExceptionHandler(this.chainedProperties.getProperty("drools.consequenceExceptionHandler", "org.drools.runtime.rule.impl.DefaultConsequenceExceptionHandler"));
        this.setRuleBaseUpdateHandler(this.chainedProperties.getProperty("drools.ruleBaseUpdateHandler", ""));
        this.setConflictResolver(this.determineConflictResolver(this.chainedProperties.getProperty("drools.conflictResolver", "org.drools.conflict.DepthConflictResolver")));
        this.setAdvancedProcessRuleIntegration(Boolean.valueOf(this.chainedProperties.getProperty("drools.advancedProcessRuleIntegration", DEFAULT_SIGN_ON_SERIALIZATION)));
        this.setMultithreadEvaluation(Boolean.valueOf(this.chainedProperties.getProperty("drools.multithreadEvaluation", DEFAULT_SIGN_ON_SERIALIZATION)));
        this.setMaxThreads(Integer.parseInt(this.chainedProperties.getProperty("drools.maxThreads", "3")));
        this.setEventProcessingMode(EventProcessingOption.determineEventProcessingMode(this.chainedProperties.getProperty("drools.eventProcessingMode", "cloud")));
        this.setMBeansEnabled(MBeansOption.isEnabled(this.chainedProperties.getProperty("kie.mbeans", "disabled")));
        this.setClassLoaderCacheEnabled(Boolean.valueOf(this.chainedProperties.getProperty("drools.classLoaderCacheEnabled", "true")));
        this.setUnlinkingEnabled(Boolean.valueOf(this.chainedProperties.getProperty("drools.lrUnlinkingEnabled", DEFAULT_SIGN_ON_SERIALIZATION)));
        this.setDeclarativeAgendaEnabled(Boolean.valueOf(this.chainedProperties.getProperty("drools.declarativeAgendaEnabled", DEFAULT_SIGN_ON_SERIALIZATION)));
        this.componentFactory = new ReteooComponentFactory();
    }

    public void makeImmutable() {
        this.immutable = true;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    private void checkCanChange() {
        if (this.immutable) {
            throw new UnsupportedOperationException("Can't set a property after configuration becomes immutable");
        }
    }

    public void setSequential(boolean sequential) {
        this.sequential = sequential;
        if (sequential && this.isUnlinkingEnabled()) {
            throw new IllegalArgumentException("Sequential mode cannot be used when Left & Right unlinking is enabled.");
        }
    }

    public boolean isSequential() {
        return this.sequential;
    }

    public boolean isMaintainTms() {
        return this.maintainTms;
    }

    public void setMaintainTms(boolean maintainTms) {
        this.checkCanChange();
        this.maintainTms = maintainTms;
    }

    public boolean isRemoveIdentities() {
        return this.removeIdentities;
    }

    public void setRemoveIdentities(boolean removeIdentities) {
        this.checkCanChange();
        this.removeIdentities = removeIdentities;
    }

    public boolean isShareAlphaNodes() {
        return this.shareAlphaNodes;
    }

    public void setShareAlphaNodes(boolean shareAlphaNodes) {
        this.checkCanChange();
        this.shareAlphaNodes = shareAlphaNodes;
    }

    public boolean isShareBetaNodes() {
        return this.shareBetaNodes;
    }

    public void setShareBetaNodes(boolean shareBetaNodes) {
        this.checkCanChange();
        this.shareBetaNodes = shareBetaNodes;
    }

    public int getPermGenThreshold() {
        return this.permGenThreshold;
    }

    public void setPermGenThreshold(int permGenThreshold) {
        this.checkCanChange();
        if (permGenThreshold < 0 || permGenThreshold > 100) {
            throw new UnsupportedOperationException("The PermGen threshold should be a number between 0 and 100");
        }
        this.permGenThreshold = permGenThreshold;
    }

    public int getAlphaNodeHashingThreshold() {
        return this.alphaNodeHashingThreshold;
    }

    public void setAlphaNodeHashingThreshold(int alphaNodeHashingThreshold) {
        this.checkCanChange();
        this.alphaNodeHashingThreshold = alphaNodeHashingThreshold;
    }

    public AssertBehaviour getAssertBehaviour() {
        return this.assertBehaviour;
    }

    public void setAssertBehaviour(AssertBehaviour assertBehaviour) {
        this.checkCanChange();
        this.assertBehaviour = assertBehaviour;
    }

    public EventProcessingOption getEventProcessingMode() {
        return this.eventProcessingMode;
    }

    public void setEventProcessingMode(EventProcessingOption mode) {
        this.checkCanChange();
        this.eventProcessingMode = mode;
    }

    public int getCompositeKeyDepth() {
        return this.compositeKeyDepth;
    }

    public void setCompositeKeyDepth(int compositeKeyDepth) {
        if (!this.immutable) {
            if (compositeKeyDepth > 3) {
                throw new UnsupportedOperationException("compositeKeyDepth cannot be greater than 3");
            }
        } else {
            throw new UnsupportedOperationException("Can't set a property after configuration becomes immutable");
        }
        this.compositeKeyDepth = compositeKeyDepth;
    }

    public boolean isIndexLeftBetaMemory() {
        return this.indexLeftBetaMemory;
    }

    public void setIndexLeftBetaMemory(boolean indexLeftBetaMemory) {
        this.checkCanChange();
        this.indexLeftBetaMemory = indexLeftBetaMemory;
    }

    public boolean isIndexRightBetaMemory() {
        return this.indexRightBetaMemory;
    }

    public void setIndexRightBetaMemory(boolean indexRightBetaMemory) {
        this.checkCanChange();
        this.indexRightBetaMemory = indexRightBetaMemory;
    }

    public IndexPrecedenceOption getIndexPrecedenceOption() {
        return this.indexPrecedenceOption;
    }

    public void setIndexPrecedenceOption(IndexPrecedenceOption precedence) {
        this.checkCanChange();
        this.indexPrecedenceOption = precedence;
    }

    public String getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(String executorService) {
        this.checkCanChange();
        this.executorService = executorService;
    }

    public String getConsequenceExceptionHandler() {
        return this.consequenceExceptionHandler;
    }

    public void setConsequenceExceptionHandler(String consequenceExceptionHandler) {
        this.checkCanChange();
        this.consequenceExceptionHandler = consequenceExceptionHandler;
    }

    public String getRuleBaseUpdateHandler() {
        return this.ruleBaseUpdateHandler;
    }

    public void setRuleBaseUpdateHandler(String ruleBaseUpdateHandler) {
        this.checkCanChange();
        this.ruleBaseUpdateHandler = ruleBaseUpdateHandler;
    }

    public AgendaGroupFactory getAgendaGroupFactory() {
        if (this.isSequential()) {
            if (this.sequentialAgenda == SequentialAgenda.SEQUENTIAL) {
                return ArrayAgendaGroupFactory.getInstance();
            }
            return PriorityQueueAgendaGroupFactory.getInstance();
        }
        return PriorityQueueAgendaGroupFactory.getInstance();
    }

    public SequentialAgenda getSequentialAgenda() {
        return this.sequentialAgenda;
    }

    public void setSequentialAgenda(SequentialAgenda sequentialAgenda) {
        this.checkCanChange();
        this.sequentialAgenda = sequentialAgenda;
    }

    public void setMultithreadEvaluation(boolean enableMultithread) {
        this.checkCanChange();
        if (enableMultithread) {
            throw new IllegalArgumentException("Multithread mode is currently not supported. Please disable it.");
        }
        this.multithread = enableMultithread;
        if (this.multithread && this.isUnlinkingEnabled()) {
            throw new IllegalArgumentException("Multithread evaluation cannot be used when Left & Right Unlinking is enabled.");
        }
    }

    public boolean isMultithreadEvaluation() {
        return this.multithread;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public boolean isClassLoaderCacheEnabled() {
        return this.classLoaderCacheEnabled;
    }

    public void setClassLoaderCacheEnabled(boolean classLoaderCacheEnabled) {
        this.checkCanChange();
        this.classLoaderCacheEnabled = classLoaderCacheEnabled;
        this.classLoader.setCachingEnabled(this.classLoaderCacheEnabled);
    }

    public boolean isUnlinkingEnabled() {
        return this.unlinkingEnabled;
    }

    public void setUnlinkingEnabled(boolean enabled) {
        this.checkCanChange();
        this.unlinkingEnabled = enabled;
        if (enabled && this.isSequential()) {
            throw new IllegalArgumentException("Sequential mode cannot be used when Left & Right Unlinking is enabled.");
        }
        if (enabled && this.isMultithreadEvaluation()) {
            throw new IllegalArgumentException("Multithread evaluation cannot be used when Left & Right Unlinking is enabled.");
        }
    }

    public boolean isDeclarativeAgenda() {
        return this.declarativeAgenda;
    }

    public void setDeclarativeAgendaEnabled(boolean enabled) {
        this.checkCanChange();
        this.declarativeAgenda = enabled;
    }

    public List<Map<String, Object>> getWorkDefinitions() {
        if (this.workDefinitions == null) {
            this.initWorkDefinitions();
        }
        return this.workDefinitions;
    }

    private void initWorkDefinitions() {
        String[] locations;
        this.workDefinitions = new ArrayList<Map<String, Object>>();
        for (String factoryLocation : locations = this.chainedProperties.getProperty("drools.workDefinitions", "").split("\\s")) {
            if ((factoryLocation = factoryLocation.trim()).startsWith("\"")) {
                factoryLocation = factoryLocation.substring(1);
            }
            if (factoryLocation.endsWith("\"")) {
                factoryLocation = factoryLocation.substring(0, factoryLocation.length() - 1);
            }
            if (factoryLocation.equals("")) continue;
            this.loadWorkItems(factoryLocation);
        }
    }

    private void loadWorkItems(String location) {
        String content = ConfFileUtils.URLContentsToString(ConfFileUtils.getURL(location, null, RuleBaseConfiguration.class));
        try {
            this.workDefinitions.addAll((List)MVEL.eval((String)content, new HashMap()));
        }
        catch (Throwable t) {
            logger.error("Error occurred while loading work definitions " + location + "\nContinuing without reading these work definitions", t);
            throw new RuntimeException("Could not parse work definitions " + location + ": " + t.getMessage());
        }
    }

    public boolean isAdvancedProcessRuleIntegration() {
        return this.advancedProcessRuleIntegration;
    }

    public void setAdvancedProcessRuleIntegration(boolean advancedProcessRuleIntegration) {
        this.advancedProcessRuleIntegration = advancedProcessRuleIntegration;
    }

    public void addActivationListener(String name, ActivationListenerFactory factory) {
        if (this.activationListeners == null) {
            this.activationListeners = new HashMap<String, ActivationListenerFactory>();
        }
        this.activationListeners.put(name, factory);
    }

    public ActivationListenerFactory getActivationListenerFactory(String name) {
        ActivationListenerFactory factory = null;
        if (this.activationListeners != null) {
            factory = this.activationListeners.get(name);
        }
        if (factory != null) {
            return factory;
        }
        if ("query".equals(name)) {
            return QueryActivationListenerFactory.INSTANCE;
        }
        if ("agenda".equals(name) || "direct".equals(name)) {
            return RuleActivationListenerFactory.INSTANCE;
        }
        throw new IllegalArgumentException("ActivationListenerFactory not found for '" + name + "'");
    }

    private boolean determineShadowProxy(String userValue) {
        if (this.isSequential()) {
            return false;
        }
        if (userValue != null) {
            return Boolean.valueOf(userValue);
        }
        return true;
    }

    private ConflictResolver determineConflictResolver(String className) {
        Class<?> clazz = null;
        try {
            clazz = this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("conflict Resolver '" + className + "' not found");
        }
        try {
            return (ConflictResolver)clazz.getMethod("getInstance", null).invoke(null, null);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to set Conflict Resolver '" + className + "'");
        }
    }

    public void setConflictResolver(ConflictResolver conflictResolver) {
        this.checkCanChange();
        this.conflictResolver = conflictResolver;
    }

    public ConflictResolver getConflictResolver() {
        return this.conflictResolver;
    }

    public CompositeClassLoader getClassLoader() {
        return this.classLoader.clone();
    }

    public void setClassLoader(ClassLoader ... classLoaders) {
        this.classLoader = ClassLoaderUtil.getClassLoader(classLoaders, this.getClass(), this.isClassLoaderCacheEnabled());
    }

    public ReteooComponentFactory getComponentFactory() {
        return this.componentFactory;
    }

    public void setComponentFactory(ReteooComponentFactory componentFactory) {
        this.componentFactory = componentFactory;
    }

    public void setMBeansEnabled(boolean mbeansEnabled) {
        this.checkCanChange();
        this.mbeansEnabled = mbeansEnabled;
    }

    public boolean isMBeansEnabled() {
        return this.mbeansEnabled;
    }

    @Override
    public <T extends SingleValueKieBaseOption> T getOption(Class<T> option) {
        if (SequentialOption.class.equals(option)) {
            return (T)(this.sequential ? SequentialOption.YES : SequentialOption.NO);
        }
        if (RemoveIdentitiesOption.class.equals(option)) {
            return (T)(this.removeIdentities ? RemoveIdentitiesOption.YES : RemoveIdentitiesOption.NO);
        }
        if (ShareAlphaNodesOption.class.equals(option)) {
            return (T)(this.shareAlphaNodes ? ShareAlphaNodesOption.YES : ShareAlphaNodesOption.NO);
        }
        if (ShareBetaNodesOption.class.equals(option)) {
            return (T)(this.shareBetaNodes ? ShareBetaNodesOption.YES : ShareBetaNodesOption.NO);
        }
        if (IndexLeftBetaMemoryOption.class.equals(option)) {
            return (T)(this.indexLeftBetaMemory ? IndexLeftBetaMemoryOption.YES : IndexLeftBetaMemoryOption.NO);
        }
        if (IndexRightBetaMemoryOption.class.equals(option)) {
            return (T)(this.indexRightBetaMemory ? IndexRightBetaMemoryOption.YES : IndexRightBetaMemoryOption.NO);
        }
        if (IndexPrecedenceOption.class.equals(option)) {
            return (T)this.getIndexPrecedenceOption();
        }
        if (EqualityBehaviorOption.class.equals(option)) {
            return (T)(this.assertBehaviour == AssertBehaviour.IDENTITY ? EqualityBehaviorOption.IDENTITY : EqualityBehaviorOption.EQUALITY);
        }
        if (SequentialAgendaOption.class.equals(option)) {
            return (T)(this.sequentialAgenda == SequentialAgenda.SEQUENTIAL ? SequentialAgendaOption.SEQUENTIAL : SequentialAgendaOption.DYNAMIC);
        }
        if (PermGenThresholdOption.class.equals(option)) {
            return (T)PermGenThresholdOption.get(this.permGenThreshold);
        }
        if (AlphaThresholdOption.class.equals(option)) {
            return (T)AlphaThresholdOption.get(this.alphaNodeHashingThreshold);
        }
        if (CompositeKeyDepthOption.class.equals(option)) {
            return (T)CompositeKeyDepthOption.get(this.compositeKeyDepth);
        }
        if (ConsequenceExceptionHandlerOption.class.equals(option)) {
            Class<?> handler;
            try {
                handler = Class.forName(this.consequenceExceptionHandler);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeDroolsException("Unable to resolve ConsequenceExceptionHandler class: " + this.consequenceExceptionHandler, e);
            }
            return (T)ConsequenceExceptionHandlerOption.get(handler);
        }
        if (EventProcessingOption.class.equals(option)) {
            return (T)this.getEventProcessingMode();
        }
        if (MaxThreadsOption.class.equals(option)) {
            return (T)MaxThreadsOption.get(this.getMaxThreads());
        }
        if (MultithreadEvaluationOption.class.equals(option)) {
            return (T)(this.multithread ? MultithreadEvaluationOption.YES : MultithreadEvaluationOption.NO);
        }
        if (MBeansOption.class.equals(option)) {
            return (T)(this.isMBeansEnabled() ? MBeansOption.ENABLED : MBeansOption.DISABLED);
        }
        if (ClassLoaderCacheOption.class.equals(option)) {
            return (T)(this.isClassLoaderCacheEnabled() ? ClassLoaderCacheOption.ENABLED : ClassLoaderCacheOption.DISABLED);
        }
        if (LRUnlinkingOption.class.equals(option)) {
            return (T)(this.isUnlinkingEnabled() ? LRUnlinkingOption.ENABLED : LRUnlinkingOption.DISABLED);
        }
        if (DeclarativeAgendaOption.class.equals(option)) {
            return (T)(this.isDeclarativeAgenda() ? DeclarativeAgendaOption.ENABLED : DeclarativeAgendaOption.DISABLED);
        }
        return null;
    }

    @Override
    public <T extends KieBaseOption> void setOption(T option) {
        if (option instanceof SequentialOption) {
            this.setSequential(((SequentialOption)option).isSequential());
        } else if (option instanceof RemoveIdentitiesOption) {
            this.setRemoveIdentities(((RemoveIdentitiesOption)option).isRemoveIdentities());
        } else if (option instanceof ShareAlphaNodesOption) {
            this.setShareAlphaNodes(((ShareAlphaNodesOption)option).isShareAlphaNodes());
        } else if (option instanceof ShareBetaNodesOption) {
            this.setShareBetaNodes(((ShareBetaNodesOption)option).isShareBetaNodes());
        } else if (option instanceof IndexLeftBetaMemoryOption) {
            this.setIndexLeftBetaMemory(((IndexLeftBetaMemoryOption)option).isIndexLeftBetaMemory());
        } else if (option instanceof IndexRightBetaMemoryOption) {
            this.setIndexRightBetaMemory(((IndexRightBetaMemoryOption)option).isIndexRightBetaMemory());
        } else if (option instanceof IndexPrecedenceOption) {
            this.setIndexPrecedenceOption((IndexPrecedenceOption)option);
        } else if (option instanceof EqualityBehaviorOption) {
            this.setAssertBehaviour(option == EqualityBehaviorOption.IDENTITY ? AssertBehaviour.IDENTITY : AssertBehaviour.EQUALITY);
        } else if (option instanceof SequentialAgendaOption) {
            this.setSequentialAgenda(option == SequentialAgendaOption.SEQUENTIAL ? SequentialAgenda.SEQUENTIAL : SequentialAgenda.DYNAMIC);
        } else if (option instanceof PermGenThresholdOption) {
            this.setPermGenThreshold(((PermGenThresholdOption)option).getThreshold());
        } else if (option instanceof AlphaThresholdOption) {
            this.setAlphaNodeHashingThreshold(((AlphaThresholdOption)option).getThreshold());
        } else if (option instanceof CompositeKeyDepthOption) {
            this.setCompositeKeyDepth(((CompositeKeyDepthOption)option).getDepth());
        } else if (option instanceof ConsequenceExceptionHandlerOption) {
            this.setConsequenceExceptionHandler(((ConsequenceExceptionHandlerOption)option).getHandler().getName());
        } else if (option instanceof EventProcessingOption) {
            this.setEventProcessingMode((EventProcessingOption)option);
        } else if (option instanceof MaxThreadsOption) {
            this.setMaxThreads(((MaxThreadsOption)option).getMaxThreads());
        } else if (option instanceof MultithreadEvaluationOption) {
            this.setMultithreadEvaluation(((MultithreadEvaluationOption)option).isMultithreadEvaluation());
        } else if (option instanceof MBeansOption) {
            this.setMBeansEnabled(((MBeansOption)option).isEnabled());
        } else if (option instanceof ClassLoaderCacheOption) {
            this.setClassLoaderCacheEnabled(((ClassLoaderCacheOption)option).isClassLoaderCacheEnabled());
        } else if (option instanceof LRUnlinkingOption) {
            this.setUnlinkingEnabled(((LRUnlinkingOption)option).isLRUnlinkingEnabled());
        } else if (option instanceof DeclarativeAgendaOption) {
            this.setDeclarativeAgendaEnabled(((DeclarativeAgendaOption)option).isDeclarativeAgendaEnabled());
        }
    }

    @Override
    public <T extends MultiValueKnowledgeBaseOption> T getOption(Class<T> option, String key) {
        return null;
    }

    public static class SequentialAgenda
    implements Externalizable {
        private static final long serialVersionUID = 510L;
        public static final SequentialAgenda SEQUENTIAL = new SequentialAgenda(0);
        public static final SequentialAgenda DYNAMIC = new SequentialAgenda(1);
        private int value;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.value = in.readInt();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.value);
        }

        public SequentialAgenda() {
        }

        private SequentialAgenda(int value) {
            this.value = value;
        }

        public static SequentialAgenda determineSequentialAgenda(String value) {
            if ("sequential".equalsIgnoreCase(value)) {
                return SEQUENTIAL;
            }
            if ("dynamic".equalsIgnoreCase(value)) {
                return DYNAMIC;
            }
            throw new IllegalArgumentException("Illegal enum value '" + value + "' for SequentialAgenda");
        }

        private Object readResolve() throws ObjectStreamException {
            switch (this.value) {
                case 0: {
                    return SEQUENTIAL;
                }
                case 1: {
                    return DYNAMIC;
                }
            }
            throw new IllegalArgumentException("Illegal enum value '" + this.value + "' for SequentialAgenda");
        }

        public String toExternalForm() {
            return this.value == 0 ? "sequential" : "dynamic";
        }

        public String toString() {
            return "SequentialAgenda : " + (this.value == 0 ? "sequential" : "dynamic");
        }
    }

    public static class LogicalOverride
    implements Externalizable {
        private static final long serialVersionUID = 510L;
        public static final LogicalOverride PRESERVE = new LogicalOverride(0);
        public static final LogicalOverride DISCARD = new LogicalOverride(1);
        private int value;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.value = in.readInt();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.value);
        }

        public LogicalOverride() {
        }

        private LogicalOverride(int value) {
            this.value = value;
        }

        public static LogicalOverride determineLogicalOverride(String value) {
            if ("PRESERVE".equalsIgnoreCase(value)) {
                return PRESERVE;
            }
            if ("DISCARD".equalsIgnoreCase(value)) {
                return DISCARD;
            }
            throw new IllegalArgumentException("Illegal enum value '" + value + "' for LogicalOverride");
        }

        private Object readResolve() throws ObjectStreamException {
            switch (this.value) {
                case 0: {
                    return PRESERVE;
                }
                case 1: {
                    return DISCARD;
                }
            }
            throw new IllegalArgumentException("Illegal enum value '" + this.value + "' for LogicalOverride");
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof LogicalOverride) {
                return this.value == ((LogicalOverride)obj).value;
            }
            return false;
        }

        public String toExternalForm() {
            return this.value == 0 ? "preserve" : "discard";
        }

        public String toString() {
            return "LogicalOverride : " + (this.value == 0 ? "preserve" : "discard");
        }
    }

    public static class AssertBehaviour
    implements Externalizable {
        private static final long serialVersionUID = 510L;
        public static final AssertBehaviour IDENTITY = new AssertBehaviour(0);
        public static final AssertBehaviour EQUALITY = new AssertBehaviour(1);
        private int value;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.value = in.readInt();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.value);
        }

        public AssertBehaviour() {
        }

        private AssertBehaviour(int value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof AssertBehaviour) {
                AssertBehaviour that = (AssertBehaviour)obj;
                return this.value == that.value;
            }
            return false;
        }

        public static AssertBehaviour determineAssertBehaviour(String value) {
            if ("IDENTITY".equalsIgnoreCase(value)) {
                return IDENTITY;
            }
            if ("EQUALITY".equalsIgnoreCase(value)) {
                return EQUALITY;
            }
            throw new IllegalArgumentException("Illegal enum value '" + value + "' for AssertBehaviour");
        }

        private Object readResolve() throws ObjectStreamException {
            switch (this.value) {
                case 0: {
                    return IDENTITY;
                }
                case 1: {
                    return EQUALITY;
                }
            }
            throw new IllegalArgumentException("Illegal enum value '" + this.value + "' for AssertBehaviour");
        }

        public String toExternalForm() {
            return this.value == 0 ? "identity" : "equality";
        }

        public String toString() {
            return "AssertBehaviour : " + (this.value == 0 ? "identity" : "equality");
        }
    }
}

