/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.extractors;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.base.extractors.BaseNumberClassFieldReader;
import org.drools.base.extractors.MVELClassFieldReader;
import org.drools.base.extractors.MVELObjectClassFieldReader;
import org.drools.base.mvel.MVELCompileable;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.MVELDialectRuntimeData;
import org.mvel2.MVEL;
import org.mvel2.compiler.ExecutableStatement;

public class MVELNumberClassFieldReader
extends BaseNumberClassFieldReader
implements Externalizable,
MVELCompileable,
MVELClassFieldReader {
    private static final long serialVersionUID = 510L;
    private ExecutableStatement mvelExpression = null;
    private String className;
    private String expr;
    private boolean typesafe;

    public MVELNumberClassFieldReader() {
    }

    public MVELNumberClassFieldReader(String className, String expr, boolean typesafe) {
        this.className = className;
        this.expr = expr;
        this.typesafe = typesafe;
        this.setIndex(-1);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.className = (String)in.readObject();
        this.expr = (String)in.readObject();
        this.typesafe = in.readBoolean();
        this.setIndex(-1);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.className);
        out.writeObject(this.expr);
        out.writeBoolean(this.typesafe);
    }

    @Override
    public void setExecutableStatement(ExecutableStatement expression) {
        this.mvelExpression = expression;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public boolean isTypeSafe() {
        return this.typesafe;
    }

    @Override
    public String getExpression() {
        return this.expr;
    }

    @Override
    public void compile(MVELDialectRuntimeData runtimeData) {
        MVELObjectClassFieldReader.doCompile(this, runtimeData);
    }

    @Override
    public Object getValue(InternalWorkingMemory workingMemory, Object object) {
        return MVEL.executeExpression((Object)this.mvelExpression, (Object)object);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
        result = 31 * result + (this.typesafe ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MVELNumberClassFieldReader other = (MVELNumberClassFieldReader)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.expr == null ? other.expr != null : !this.expr.equals(other.expr)) {
            return false;
        }
        return this.typesafe == other.typesafe;
    }

    public String toString() {
        return "[MVELDateClassFieldReader className=" + this.className + ", expr=" + this.expr + ", typesafe=" + this.typesafe + "]";
    }
}

