/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.mina;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.transport.socket.SocketConnector;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.jbpm.task.service.BaseHandler;
import org.jbpm.task.service.TaskClientConnector;
import org.jbpm.task.service.mina.BaseMinaHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinaTaskClientConnector
implements TaskClientConnector {
    protected IoSession session;
    protected final BaseMinaHandler handler;
    protected final String name;
    protected AtomicInteger counter;
    protected SocketConnector connector;
    protected SocketAddress address;
    private static final Logger logger = LoggerFactory.getLogger(MinaTaskClientConnector.class);

    public MinaTaskClientConnector(String name, BaseMinaHandler handler) {
        if (name == null) {
            throw new IllegalArgumentException("Name can not be null");
        }
        this.name = name;
        this.handler = handler;
        this.counter = new AtomicInteger();
    }

    public boolean connect(SocketConnector connector, SocketAddress address) {
        this.connector = connector;
        this.address = address;
        this.connector.setHandler((IoHandler)this.handler);
        return this.connect();
    }

    public boolean connect(String address, int port) {
        this.connector = new NioSocketConnector();
        this.address = new InetSocketAddress(address, port);
        this.connector.setHandler((IoHandler)this.handler);
        return this.connect();
    }

    public boolean connect() {
        if (this.session != null && this.session.isConnected()) {
            throw new IllegalStateException("Already connected. Disconnect first.");
        }
        if (this.connector == null) {
            this.connector = new NioSocketConnector();
            this.connector.setHandler((IoHandler)this.handler);
        }
        if (this.address == null) {
            this.address = new InetSocketAddress("127.0.0.1", 9123);
        }
        try {
            this.connector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new ObjectSerializationCodecFactory()));
            ConnectFuture future1 = this.connector.connect(this.address);
            future1.awaitUninterruptibly();
            if (!future1.isConnected()) {
                return false;
            }
            this.session = future1.getSession();
            return true;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void disconnect() {
        if (this.session != null && this.session.isConnected()) {
            this.session.close(true).awaitUninterruptibly();
        }
        if (this.connector != null && this.connector.isActive()) {
            this.connector.dispose();
            this.connector = null;
        }
    }

    public void write(Object message) {
        this.session.write(message);
    }

    public BaseHandler getHandler() {
        return this.handler;
    }

    public String getName() {
        return this.name;
    }

    public AtomicInteger getCounter() {
        return this.counter;
    }
}

