/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.datatype.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.eclipse.flow.common.datatype.DataTypeRegistry;
import org.drools.process.core.datatype.DataTypeFactory;

public class DataTypeRegistryImpl
implements DataTypeRegistry {
    private Map dataTypes = new HashMap();

    @Override
    public Set getDataTypes() {
        return new HashSet(this.dataTypes.values());
    }

    @Override
    public void registerDataType(Class type, DataTypeFactory dataTypeFactory, String name, Class valueEditorClass, Class dataTypeEditorClass) {
        if (dataTypeFactory == null) {
            throw new NullPointerException("Data type factory may not be null");
        }
        if (name == null) {
            throw new NullPointerException("Name may not be null");
        }
        if (valueEditorClass == null) {
            throw new NullPointerException("valueEditorClass may not be null");
        }
        if (dataTypeEditorClass == null) {
            throw new NullPointerException("dataTypeEditorClass may not be null");
        }
        this.dataTypes.put(type, new DataTypeInfo(type, dataTypeFactory, name, valueEditorClass, dataTypeEditorClass));
    }

    @Override
    public DataTypeRegistry.IDataTypeInfo getDataTypeInfo(Class type) {
        DataTypeRegistry.IDataTypeInfo dataTypeInfo = (DataTypeRegistry.IDataTypeInfo)this.dataTypes.get(type);
        if (dataTypeInfo == null) {
            throw new IllegalArgumentException("Cannot find data type info with type " + type);
        }
        return dataTypeInfo;
    }

    public class DataTypeInfo
    implements DataTypeRegistry.IDataTypeInfo {
        private Class type;
        private DataTypeFactory dataTypeFactory;
        private String name;
        private Class valueEditorClass;
        private Class dataTypeEditorClass;

        private DataTypeInfo(Class type, DataTypeFactory dataTypeFactory, String name, Class valueEditorClass, Class dataTypeEditorClass) {
            this.type = type;
            this.dataTypeFactory = dataTypeFactory;
            this.name = name;
            this.valueEditorClass = valueEditorClass;
            this.dataTypeEditorClass = dataTypeEditorClass;
        }

        @Override
        public Class getType() {
            return this.type;
        }

        @Override
        public DataTypeFactory getDataTypeFactory() {
            return this.dataTypeFactory;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Class getValueEditorClass() {
            return this.valueEditorClass;
        }

        @Override
        public Class getDataTypeEditorClass() {
            return this.dataTypeEditorClass;
        }
    }
}

