/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.core;

import java.util.HashMap;
import java.util.Map;
import org.drools.eclipse.flow.common.editor.core.ElementConnection;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.drools.eclipse.flow.ruleflow.core.ConnectionWrapper;
import org.drools.eclipse.flow.ruleflow.core.StateBasedNodeWrapper;
import org.drools.eclipse.flow.ruleflow.view.property.constraint.StateConstraintsPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.jbpm.workflow.core.Constraint;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.WorkflowProcess;
import org.jbpm.workflow.core.impl.ConnectionRef;
import org.jbpm.workflow.core.node.StateNode;
import org.kie.definition.process.Connection;

public class StateNodeWrapper
extends StateBasedNodeWrapper {
    public static final String CONSTRAINTS = "constraints";
    private static final long serialVersionUID = 510L;

    public StateNodeWrapper() {
        this.setNode((Node)new StateNode());
        this.getStateNode().setName("State");
    }

    @Override
    protected void initDescriptors() {
        super.initDescriptors();
        IPropertyDescriptor[] oldDescriptors = this.descriptors;
        this.descriptors = new IPropertyDescriptor[oldDescriptors.length + 3];
        System.arraycopy(oldDescriptors, 0, this.descriptors, 0, oldDescriptors.length);
        this.descriptors[this.descriptors.length - 3] = this.getOnEntryPropertyDescriptor();
        this.descriptors[this.descriptors.length - 2] = this.getOnExitPropertyDescriptor();
        this.descriptors[this.descriptors.length - 1] = new StateConstraintsPropertyDescriptor(CONSTRAINTS, "Constraints", this.getStateNode(), (WorkflowProcess)this.getParent().getProcessWrapper().getProcess());
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptors == null) {
            this.initDescriptors();
        }
        return this.descriptors;
    }

    @Override
    public void setNode(Node node) {
        super.setNode(node);
        for (Connection connection : this.getStateNode().getOutgoingConnections("DROOLS_DEFAULT")) {
            String label = null;
            Constraint constraint = this.getStateNode().getConstraint(connection);
            if (constraint != null) {
                label = constraint.getName();
            }
            ((org.jbpm.workflow.core.Connection)connection).setMetaData("label", (Object)label);
        }
    }

    public StateNode getStateNode() {
        return (StateNode)this.getNode();
    }

    private void updateConnectionLabels() {
        for (ElementConnection connection : this.getOutgoingConnections()) {
            this.updateConnectionLabel(connection);
        }
    }

    private void updateConnectionLabel(ElementConnection connection) {
        ConnectionWrapper connectionWrapper = (ConnectionWrapper)connection;
        String label = null;
        Constraint constraint = this.getStateNode().getConstraint((Connection)connectionWrapper.getConnection());
        if (constraint != null) {
            label = constraint.getName();
        }
        connectionWrapper.getConnection().setMetaData("label", (Object)label);
        connectionWrapper.notifyListeners(2);
    }

    @Override
    public boolean acceptsIncomingConnection(ElementConnection connection, ElementWrapper source) {
        return super.acceptsIncomingConnection(connection, source) && this.getIncomingConnections().isEmpty();
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (CONSTRAINTS.equals(id)) {
            return new MyHashMap(this.getStateNode().getConstraints());
        }
        return super.getPropertyValue(id);
    }

    @Override
    public void resetPropertyValue(Object id) {
        if (CONSTRAINTS.equals(id)) {
            for (Connection connection : this.getStateNode().getOutgoingConnections("DROOLS_DEFAULT")) {
                this.getStateNode().setConstraint(connection, null);
            }
            this.updateConnectionLabels();
        } else {
            super.resetPropertyValue(id);
        }
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (CONSTRAINTS.equals(id)) {
            for (Map.Entry element : ((Map)value).entrySet()) {
                ConnectionRef connectionRef = (ConnectionRef)element.getKey();
                Connection outgoingConnection = null;
                for (Connection out : this.getStateNode().getOutgoingConnections("DROOLS_DEFAULT")) {
                    if (!out.getToType().equals(connectionRef.getToType()) || out.getTo().getId() != connectionRef.getNodeId()) continue;
                    outgoingConnection = out;
                }
                if (outgoingConnection == null) {
                    throw new IllegalArgumentException("Could not find outgoing connection");
                }
                this.getStateNode().setConstraint(outgoingConnection, (Constraint)element.getValue());
            }
            this.updateConnectionLabels();
        } else {
            super.setPropertyValue(id, value);
        }
    }

    public class MyHashMap<K, V>
    extends HashMap<K, V> {
        private static final long serialVersionUID = 510L;

        public MyHashMap() {
        }

        public MyHashMap(Map<K, V> map) {
            super(map);
        }

        @Override
        public String toString() {
            return "";
        }
    }
}

