/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.example.factorial;

import java.math.BigInteger;
import java.util.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;

public class FactorialServerHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger logger = Logger.getLogger(FactorialServerHandler.class.getName());
    private int lastMultiplier = 1;
    private BigInteger factorial = new BigInteger(new byte[]{1});

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (e instanceof ChannelStateEvent) {
            logger.info(e.toString());
        }
        super.handleUpstream(ctx, e);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        BigInteger number = e.getMessage() instanceof BigInteger ? (BigInteger)e.getMessage() : new BigInteger(e.getMessage().toString());
        this.lastMultiplier = number.intValue();
        this.factorial = this.factorial.multiply(number);
        e.getChannel().write(this.factorial);
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        logger.info(new Formatter().format("Factorial of %,d is: %,d", this.lastMultiplier, this.factorial).toString());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        logger.log(Level.WARNING, "Unexpected exception from downstream.", e.getCause());
        e.getChannel().close();
    }
}

