/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.handler;

import java.util.HashMap;
import java.util.Map;
import org.kie.runtime.KnowledgeRuntime;
import org.kie.runtime.process.WorkItem;
import org.kie.runtime.process.WorkItemHandler;
import org.kie.runtime.process.WorkItemManager;

public class ReceiveTaskHandler
implements WorkItemHandler {
    private Map<String, Long> waiting = new HashMap<String, Long>();
    private KnowledgeRuntime ksession;

    public ReceiveTaskHandler(KnowledgeRuntime ksession) {
        this.ksession = ksession;
    }

    public void setKnowledgeRuntime(KnowledgeRuntime ksession) {
        this.ksession = ksession;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        String messageId = (String)workItem.getParameter("MessageId");
        this.waiting.put(messageId, workItem.getId());
    }

    public void messageReceived(String messageId, Object message) {
        Long workItemId = this.waiting.get(messageId);
        if (workItemId == null) {
            return;
        }
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("Message", message);
        this.ksession.getWorkItemManager().completeWorkItem(workItemId.longValue(), results);
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        String messageId = (String)workItem.getParameter("MessageId");
        this.waiting.remove(messageId);
    }
}

