/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.List;
import org.drools.compiler.xml.XmlDumper;
import org.jbpm.bpmn2.xml.AbstractNodeHandler;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.EndNode;
import org.xml.sax.Attributes;

public class EndNodeHandler
extends AbstractNodeHandler {
    @Override
    protected Node createNode(Attributes attrs) {
        throw new IllegalArgumentException("Reading in should be handled by end event handler");
    }

    public Class generateNodeFor() {
        return EndNode.class;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        EndNode endNode = (EndNode)node;
        this.writeNode("endEvent", endNode, xmlDump, metaDataType);
        if (endNode.isTerminate()) {
            xmlDump.append(">" + EOL);
            xmlDump.append("        <terminateEventDefinition " + (endNode.getScope() == 1 ? "tns:scope=\"process\"" : "") + "/>" + EOL);
            this.endNode("endEvent", xmlDump);
            return;
        } else {
            List<DroolsAction> actions = endNode.getActions("onEntry");
            if (actions != null && !actions.isEmpty()) {
                if (actions.size() != 1) return;
                DroolsConsequenceAction action = (DroolsConsequenceAction)actions.get(0);
                String s = action.getConsequence();
                if (s.startsWith("org.drools.process.instance.impl.WorkItemImpl workItem = new org.drools.process.instance.impl.WorkItemImpl();")) {
                    xmlDump.append(">" + EOL);
                    String variable = (String)endNode.getMetaData("MappingVariable");
                    if (variable != null) {
                        xmlDump.append("      <dataInput id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(endNode) + "_Input\" />" + EOL + "      <dataInputAssociation>" + EOL + "        <sourceRef>" + XmlDumper.replaceIllegalChars((String)variable) + "</sourceRef>" + EOL + "        <targetRef>" + XmlBPMNProcessDumper.getUniqueNodeId(endNode) + "_Input</targetRef>" + EOL + "      </dataInputAssociation>" + EOL + "      <inputSet>" + EOL + "        <dataInputRefs>" + XmlBPMNProcessDumper.getUniqueNodeId(endNode) + "_Input</dataInputRefs>" + EOL + "      </inputSet>" + EOL);
                    }
                    xmlDump.append("      <messageEventDefinition messageRef=\"" + XmlBPMNProcessDumper.getUniqueNodeId(endNode) + "_Message\"/>" + EOL);
                    this.endNode("endEvent", xmlDump);
                    return;
                } else if (s.startsWith("kcontext.getKnowledgeRuntime().signalEvent(\"")) {
                    xmlDump.append(">" + EOL);
                    s = s.substring(44);
                    String type = s.substring(0, s.indexOf("\""));
                    s = s.substring(s.indexOf(",") + 2);
                    String variable = null;
                    if (!s.startsWith("null")) {
                        variable = s.substring(0, s.indexOf(")"));
                        xmlDump.append("      <dataInput id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(endNode) + "_Input\" />" + EOL + "      <dataInputAssociation>" + EOL + "        <sourceRef>" + XmlDumper.replaceIllegalChars((String)variable) + "</sourceRef>" + EOL + "        <targetRef>" + XmlBPMNProcessDumper.getUniqueNodeId(endNode) + "_Input</targetRef>" + EOL + "      </dataInputAssociation>" + EOL + "      <inputSet>" + EOL + "        <dataInputRefs>" + XmlBPMNProcessDumper.getUniqueNodeId(endNode) + "_Input</dataInputRefs>" + EOL + "      </inputSet>" + EOL);
                    }
                    if (type.startsWith("Compensate-")) {
                        xmlDump.append("      <compensateEventDefinition activityRef=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(type.substring(11)) + "\"/>" + EOL);
                    } else {
                        xmlDump.append("      <signalEventDefinition signalRef=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(type) + "\"/>" + EOL);
                    }
                    this.endNode("endEvent", xmlDump);
                    return;
                } else {
                    if (!s.startsWith("kcontext.getProcessInstance().signalEvent(\"")) throw new IllegalArgumentException("Unknown action " + s);
                    xmlDump.append(">" + EOL);
                    s = s.substring(43);
                    String type = s.substring(0, s.indexOf("\""));
                    xmlDump.append("      <compensateEventDefinition activityRef=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(type.substring(11)) + "\"/>" + EOL);
                    this.endNode("endEvent", xmlDump);
                }
                return;
            } else {
                this.endNode(xmlDump);
            }
        }
    }
}

