/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.LinkedList;
import java.util.Map;
import org.drools.process.core.Work;
import org.drools.process.core.datatype.DataType;
import org.drools.process.core.datatype.impl.type.ObjectDataType;
import org.drools.process.core.impl.WorkImpl;
import org.drools.xml.ExtensibleXmlParser;
import org.jbpm.bpmn2.core.ItemDefinition;
import org.jbpm.bpmn2.xml.AbstractNodeHandler;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.node.Assignment;
import org.jbpm.workflow.core.node.DataAssociation;
import org.jbpm.workflow.core.node.ForEachNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TaskHandler
extends AbstractNodeHandler {
    @Override
    protected Node createNode(Attributes attrs) {
        return new WorkItemNode();
    }

    public Class<?> generateNodeFor() {
        return Node.class;
    }

    @Override
    protected void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        WorkItemNode workItemNode = (WorkItemNode)node;
        String name = this.getTaskName(element);
        WorkImpl work = new WorkImpl();
        work.setName(name);
        workItemNode.setWork((Work)work);
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("ioSpecification".equals(nodeName)) {
                this.readIoSpecification(xmlNode, this.dataInputs, this.dataOutputs);
                continue;
            }
            if ("dataInputAssociation".equals(nodeName)) {
                this.readDataInputAssociation(xmlNode, workItemNode, this.dataInputs);
                continue;
            }
            if (!"dataOutputAssociation".equals(nodeName)) continue;
            this.readDataOutputAssociation(xmlNode, workItemNode, this.dataOutputs);
        }
        this.handleScript(workItemNode, element, "onEntry");
        this.handleScript(workItemNode, element, "onExit");
    }

    protected String getTaskName(Element element) {
        return element.getAttribute("taskName");
    }

    protected void readDataInputAssociation(org.w3c.dom.Node xmlNode, WorkItemNode workItemNode, Map<String, String> dataInputs) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        if ("sourceRef".equals(subNode.getNodeName())) {
            String source = subNode.getTextContent();
            subNode = subNode.getNextSibling();
            String target = subNode.getTextContent();
            LinkedList<Assignment> assignments = new LinkedList<Assignment>();
            for (subNode = subNode.getNextSibling(); subNode != null; subNode = subNode.getNextSibling()) {
                org.w3c.dom.Node ssubNode = subNode.getFirstChild();
                String from = ssubNode.getTextContent();
                String to = ssubNode.getNextSibling().getTextContent();
                assignments.add(new Assignment("XPath", from, to));
            }
            workItemNode.addInAssociation(new DataAssociation(source, dataInputs.get(target), assignments, null));
        } else {
            String to = subNode.getTextContent();
            if ((subNode = subNode.getNextSibling()) != null) {
                String text;
                org.w3c.dom.Node subSubNode = subNode.getFirstChild();
                NodeList nl = subSubNode.getChildNodes();
                if (nl.getLength() > 1) {
                    workItemNode.getWork().setParameter(dataInputs.get(to), (Object)subSubNode.getTextContent());
                    return;
                }
                if (nl.getLength() == 0) {
                    return;
                }
                Object result = null;
                org.w3c.dom.Node from = nl.item(0);
                result = from instanceof Text ? ((text = ((Text)from).getTextContent()).startsWith("\"") && text.endsWith("\"") ? text.substring(1, text.length() - 1) : text) : nl.item(0);
                workItemNode.getWork().setParameter(dataInputs.get(to), result);
            }
        }
    }

    protected void readDataOutputAssociation(org.w3c.dom.Node xmlNode, WorkItemNode workItemNode, Map<String, String> dataOutputs) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        String source = subNode.getTextContent();
        subNode = subNode.getNextSibling();
        String target = subNode.getTextContent();
        LinkedList<Assignment> assignments = new LinkedList<Assignment>();
        for (subNode = subNode.getNextSibling(); subNode != null; subNode = subNode.getNextSibling()) {
            org.w3c.dom.Node ssubNode = subNode.getFirstChild();
            String from = ssubNode.getTextContent();
            String to = ssubNode.getNextSibling().getTextContent();
            assignments.add(new Assignment("XPath", from, to));
        }
        workItemNode.addOutAssociation(new DataAssociation(dataOutputs.get(source), target, assignments, null));
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        throw new IllegalArgumentException("Writing out should be handled by the WorkItemNodeHandler");
    }

    @Override
    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        Node node = (Node)parser.getCurrent();
        this.handleNode(node, element, uri, localName, parser);
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (!"multiInstanceLoopCharacteristics".equals(nodeName)) continue;
            ForEachNode forEachNode = new ForEachNode();
            forEachNode.setId(node.getId());
            forEachNode.setMetaData("UniqueId", node.getMetaData().get("UniqueId"));
            node.setMetaData("UniqueId", null);
            node.setMetaData("hidden", true);
            forEachNode.addNode(node);
            forEachNode.linkIncomingConnections("DROOLS_DEFAULT", node.getId(), "DROOLS_DEFAULT");
            forEachNode.linkOutgoingConnections(node.getId(), "DROOLS_DEFAULT", "DROOLS_DEFAULT");
            node = forEachNode;
            this.handleForEachNode(node, element, uri, localName, parser);
            break;
        }
        NodeContainer nodeContainer = (NodeContainer)parser.getParent();
        nodeContainer.addNode(node);
        return node;
    }

    protected void readDataInputAssociation(org.w3c.dom.Node xmlNode, ForEachNode forEachNode) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        String inputVariable = subNode.getTextContent();
        if (inputVariable != null && inputVariable.trim().length() > 0) {
            forEachNode.setCollectionExpression(inputVariable);
        }
    }

    protected void handleForEachNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        ForEachNode forEachNode = (ForEachNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("dataInputAssociation".equals(nodeName)) {
                this.readDataInputAssociation(xmlNode, forEachNode);
                continue;
            }
            if (!"multiInstanceLoopCharacteristics".equals(nodeName)) continue;
            this.readMultiInstanceLoopCharacteristics(xmlNode, forEachNode, parser);
        }
    }

    protected void readMultiInstanceLoopCharacteristics(org.w3c.dom.Node xmlNode, ForEachNode forEachNode, ExtensibleXmlParser parser) {
        for (org.w3c.dom.Node subNode = xmlNode.getFirstChild(); subNode != null; subNode = subNode.getNextSibling()) {
            String outputDataRef;
            String outputDataName;
            ItemDefinition itemDefinition;
            Map itemDefinitions;
            ObjectDataType dataType;
            String itemSubjectRef;
            String variableName;
            String nodeName = subNode.getNodeName();
            if ("inputDataItem".equals(nodeName)) {
                variableName = ((Element)subNode).getAttribute("id");
                itemSubjectRef = ((Element)subNode).getAttribute("itemSubjectRef");
                dataType = null;
                itemDefinitions = (Map)((ProcessBuildData)parser.getData()).getMetaData("ItemDefinitions");
                if (itemDefinitions != null && (itemDefinition = (ItemDefinition)itemDefinitions.get(itemSubjectRef)) != null) {
                    dataType = new ObjectDataType(itemDefinition.getStructureRef());
                }
                if (dataType == null) {
                    dataType = new ObjectDataType("java.lang.Object");
                }
                if (variableName == null || variableName.trim().length() <= 0) continue;
                forEachNode.setVariable(variableName, (DataType)dataType);
                continue;
            }
            if ("outputDataItem".equals(nodeName)) {
                variableName = ((Element)subNode).getAttribute("id");
                itemSubjectRef = ((Element)subNode).getAttribute("itemSubjectRef");
                dataType = null;
                itemDefinitions = (Map)((ProcessBuildData)parser.getData()).getMetaData("ItemDefinitions");
                if (itemDefinitions != null && (itemDefinition = (ItemDefinition)itemDefinitions.get(itemSubjectRef)) != null) {
                    dataType = new ObjectDataType(itemDefinition.getStructureRef());
                }
                if (dataType == null) {
                    dataType = new ObjectDataType("java.lang.Object");
                }
                if (variableName == null || variableName.trim().length() <= 0) continue;
                forEachNode.setOutputVariable(variableName, (DataType)dataType);
                continue;
            }
            if (!"loopDataOutputRef".equals(nodeName) || (outputDataName = (String)this.dataOutputs.get(outputDataRef = ((Element)subNode).getTextContent())) == null || outputDataName.trim().length() <= 0) continue;
            forEachNode.setOutputCollectionExpression(outputDataName);
        }
    }
}

