/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.compiler.xml.processes;

import org.drools.xml.ExtensibleXmlParser;
import org.jbpm.compiler.xml.processes.AbstractNodeHandler;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.Join;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class JoinNodeHandler
extends AbstractNodeHandler {
    @Override
    protected Node createNode() {
        return new Join();
    }

    @Override
    public void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        String n;
        super.handleNode(node, element, uri, localName, parser);
        Join joinNode = (Join)node;
        String type = element.getAttribute("type");
        if (type != null && type.length() != 0) {
            joinNode.setType(new Integer(type));
        }
        if ((n = element.getAttribute("n")) != null && n.length() != 0) {
            joinNode.setN(n);
        }
    }

    public Class generateNodeFor() {
        return Join.class;
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, boolean includeMeta) {
        String n;
        Join joinNode = (Join)node;
        this.writeNode("join", joinNode, xmlDump, includeMeta);
        int type = joinNode.getType();
        if (type != 0) {
            xmlDump.append("type=\"" + type + "\" ");
        }
        if (type == 4 && (n = joinNode.getN()) != null && n.length() != 0) {
            xmlDump.append("n=\"" + n + "\" ");
        }
        if (includeMeta && this.containsMetaData(joinNode)) {
            xmlDump.append(">" + EOL);
            this.writeMetaData(joinNode, xmlDump);
            this.endNode("join", xmlDump);
        } else {
            this.endNode(xmlDump);
        }
    }
}

