/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.builder.dialect.mvel;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.drools.base.mvel.MVELCompilationUnit;
import org.drools.base.mvel.MVELCompileable;
import org.drools.compiler.AnalysisResult;
import org.drools.compiler.BoundIdentifiers;
import org.drools.compiler.DescrBuildError;
import org.drools.lang.descr.ActionDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.rule.MVELDialectRuntimeData;
import org.drools.rule.builder.PackageBuildContext;
import org.drools.rule.builder.dialect.mvel.MVELAnalysisResult;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.drools.spi.Wireable;
import org.jbpm.process.builder.ActionBuilder;
import org.jbpm.process.core.ContextResolver;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.instance.impl.MVELAction;
import org.jbpm.workflow.core.DroolsAction;
import org.kie.runtime.process.ProcessContext;
import org.mvel2.Macro;
import org.mvel2.MacroProcessor;

public class MVELActionBuilder
implements ActionBuilder {
    private static final Map macros = new HashMap(5);

    @Override
    public void build(PackageBuildContext context, DroolsAction action, ActionDescr actionDescr, ContextResolver contextResolver) {
        String text = MVELActionBuilder.processMacros(actionDescr.getText());
        try {
            MVELDialect dialect = (MVELDialect)context.getDialect("mvel");
            boolean typeSafe = context.isTypesafe();
            HashMap<String, Class> variables = new HashMap<String, Class>();
            context.setTypesafe(false);
            BoundIdentifiers boundIdentifiers = new BoundIdentifiers(variables, context.getPackageBuilder().getGlobals());
            MVELAnalysisResult analysis = (MVELAnalysisResult)dialect.analyzeBlock(context, (BaseDescr)actionDescr, dialect.getInterceptors(), text, boundIdentifiers, null, "context", ProcessContext.class);
            context.setTypesafe(typeSafe);
            Set variableNames = analysis.getNotBoundedIdentifiers();
            if (contextResolver != null) {
                for (String variableName : variableNames) {
                    if (analysis.getMvelVariables().keySet().contains(variableName) || variableName.equals("kcontext") || variableName.equals("context")) continue;
                    VariableScope variableScope = (VariableScope)contextResolver.resolveContext("VariableScope", variableName);
                    if (variableScope == null) {
                        context.getErrors().add(new DescrBuildError(context.getParentDescr(), (BaseDescr)actionDescr, null, "Could not find variable '" + variableName + "' for action '" + actionDescr.getText() + "'"));
                        continue;
                    }
                    variables.put(variableName, context.getDialect().getTypeResolver().resolveType(variableScope.findVariable(variableName).getType().getStringType()));
                }
            }
            MVELCompilationUnit unit = dialect.getMVELCompilationUnit(text, (AnalysisResult)analysis, null, null, variables, context, "context", ProcessContext.class);
            MVELAction expr = new MVELAction(unit, context.getDialect().getId());
            action.setMetaData("Action", expr);
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData(dialect.getId());
            data.addCompileable((Wireable)action, (MVELCompileable)expr);
            expr.compile(data);
        }
        catch (Exception e) {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), (BaseDescr)actionDescr, null, "Unable to build expression for action '" + actionDescr.getText() + "' :" + e));
        }
    }

    public static String processMacros(String consequence) {
        MacroProcessor macroProcessor = new MacroProcessor();
        macroProcessor.setMacros(macros);
        return macroProcessor.parse(MVELActionBuilder.delimitExpressions(consequence));
    }

    public static String delimitExpressions(String s) {
        StringBuilder result = new StringBuilder();
        char[] cs = s.toCharArray();
        int brace = 0;
        int sqre = 0;
        int crly = 0;
        int lastNonWhite = 59;
        for (int i = 0; i < cs.length; ++i) {
            int c = cs[i];
            switch (c) {
                case 40: {
                    ++brace;
                    break;
                }
                case 123: {
                    ++crly;
                    break;
                }
                case 91: {
                    ++sqre;
                    break;
                }
                case 41: {
                    --brace;
                    break;
                }
                case 125: {
                    --crly;
                    break;
                }
                case 93: {
                    --sqre;
                    break;
                }
            }
            if (brace == 0 && sqre == 0 && crly == 0 && (c == 10 || c == 13)) {
                if (lastNonWhite != 59) {
                    result.append(';');
                    lastNonWhite = 59;
                }
            } else if (!Character.isWhitespace((char)c)) {
                lastNonWhite = c;
            }
            result.append((char)c);
        }
        return result.toString();
    }

    static {
        macros.put("insert", new Macro(){

            public String doMacro() {
                return "kcontext.getKnowledgeRuntime().insert";
            }
        });
    }
}

