/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import org.drools.common.InternalWorkingMemory;
import org.drools.core.util.Entry;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.LeftInputAdapterNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.RightTuple;
import org.drools.spi.PropagationContext;

public class ModifyPreviousTuples {
    private LeftTuple leftTuple;
    private RightTuple rightTuple;
    private boolean unlinkingEnabled;

    public ModifyPreviousTuples(LeftTuple leftTuple, RightTuple rightTuple, boolean unlinkingEnabled) {
        this.leftTuple = leftTuple;
        this.rightTuple = rightTuple;
        this.unlinkingEnabled = unlinkingEnabled;
    }

    public LeftTuple peekLeftTuple() {
        return this.leftTuple;
    }

    public RightTuple peekRightTuple() {
        return this.rightTuple;
    }

    public void removeLeftTuple() {
        LeftTuple current = this.leftTuple;
        current.setLeftParentPrevious(null);
        this.leftTuple = current.getLeftParentNext();
        current.setLeftParentNext(null);
    }

    public void removeRightTuple() {
        RightTuple current = this.rightTuple;
        current.setHandlePrevious(null);
        this.rightTuple = current.getHandleNext();
        current.setHandleNext(null);
    }

    public void retractTuples(PropagationContext context, InternalWorkingMemory wm) {
        Entry current;
        if (this.leftTuple != null) {
            for (current = this.leftTuple; current != null; current = current.getLeftParentNext()) {
                if (this.unlinkingEnabled) {
                    LeftInputAdapterNode liaNode = (LeftInputAdapterNode)current.getLeftTupleSink().getLeftTupleSource();
                    LeftInputAdapterNode.LiaNodeMemory lm = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory(liaNode);
                    LeftInputAdapterNode.doDeleteObject((LeftTuple)current, context, lm.getSegmentMemory(), wm, liaNode, lm);
                    continue;
                }
                current.getLeftTupleSink().retractLeftTuple((LeftTuple)current, context, wm);
            }
        }
        if (this.rightTuple != null) {
            for (current = this.rightTuple; current != null; current = ((RightTuple)current).getHandleNext()) {
                BetaNode node = (BetaNode)((RightTuple)current).getRightTupleSink();
                if (this.unlinkingEnabled) {
                    BetaMemory bm = BetaNode.getBetaMemory(node, wm);
                    BetaNode.doDeleteRightTuple((RightTuple)current, wm, bm);
                    continue;
                }
                node.retractRightTuple((RightTuple)current, context, wm);
            }
        }
    }
}

