/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.wsht;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.eventmessaging.EventResponseHandler;
import org.jbpm.process.workitem.wsht.HumanTaskHandlerHelper;
import org.jbpm.process.workitem.wsht.PeopleAssignmentHelper;
import org.jbpm.task.I18NText;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.PeopleAssignments;
import org.jbpm.task.SubTasksStrategy;
import org.jbpm.task.SubTasksStrategyFactory;
import org.jbpm.task.Task;
import org.jbpm.task.TaskData;
import org.jbpm.task.User;
import org.jbpm.task.event.TaskEventKey;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.utils.ContentMarshallerHelper;
import org.jbpm.task.utils.OnErrorAction;
import org.kie.runtime.KnowledgeRuntime;
import org.kie.runtime.StatefulKnowledgeSession;
import org.kie.runtime.process.WorkItem;
import org.kie.runtime.process.WorkItemHandler;
import org.kie.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHTWorkItemHandler
implements WorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHTWorkItemHandler.class);
    protected KnowledgeRuntime session;
    protected OnErrorAction action;
    protected Map<TaskEventKey, EventResponseHandler> eventHandlers = new HashMap<TaskEventKey, EventResponseHandler>();

    public AbstractHTWorkItemHandler(KnowledgeRuntime session) {
        this.session = session;
        this.action = OnErrorAction.LOG;
    }

    public AbstractHTWorkItemHandler(KnowledgeRuntime session, OnErrorAction action) {
        this.session = session;
        this.action = action;
    }

    public void setAction(OnErrorAction action) {
        this.action = action;
    }

    protected Task createTaskBasedOnWorkItemParams(WorkItem workItem) {
        String createdBy;
        String subTaskStrategiesCommaSeparated;
        String comment;
        String taskName;
        Task task = new Task();
        String locale = (String)workItem.getParameter("Locale");
        if (locale == null) {
            locale = "en-UK";
        }
        if ((taskName = (String)workItem.getParameter("TaskName")) != null) {
            ArrayList<I18NText> names = new ArrayList<I18NText>();
            names.add(new I18NText(locale, taskName));
            task.setNames(names);
        }
        if ((comment = (String)workItem.getParameter("Comment")) == null) {
            comment = "";
        }
        ArrayList<I18NText> descriptions = new ArrayList<I18NText>();
        descriptions.add(new I18NText(locale, comment));
        task.setDescriptions(descriptions);
        ArrayList<I18NText> subjects = new ArrayList<I18NText>();
        subjects.add(new I18NText(locale, comment));
        task.setSubjects(subjects);
        String priorityString = (String)workItem.getParameter("Priority");
        int priority = 0;
        if (priorityString != null) {
            try {
                priority = new Integer(priorityString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        task.setPriority(priority);
        TaskData taskData = new TaskData();
        taskData.setWorkItemId(workItem.getId());
        taskData.setProcessInstanceId(workItem.getProcessInstanceId());
        if (this.session != null && this.session.getProcessInstance(workItem.getProcessInstanceId()) != null) {
            taskData.setProcessId(this.session.getProcessInstance(workItem.getProcessInstanceId()).getProcess().getId());
        }
        if (this.session != null && this.session instanceof StatefulKnowledgeSession) {
            taskData.setProcessSessionId(((StatefulKnowledgeSession)this.session).getId());
        }
        taskData.setSkipable(!"false".equals(workItem.getParameter("Skippable")));
        Long parentId = (Long)workItem.getParameter("ParentId");
        if (parentId != null) {
            taskData.setParentId(parentId);
        }
        if ((subTaskStrategiesCommaSeparated = (String)workItem.getParameter("SubTaskStrategies")) != null && !subTaskStrategiesCommaSeparated.equals("")) {
            String[] subTaskStrategies = subTaskStrategiesCommaSeparated.split(",");
            ArrayList<SubTasksStrategy> strategies = new ArrayList<SubTasksStrategy>();
            for (String subTaskStrategyString : subTaskStrategies) {
                SubTasksStrategy subTaskStrategy = SubTasksStrategyFactory.newStrategy(subTaskStrategyString);
                strategies.add(subTaskStrategy);
            }
            task.setSubTaskStrategies(strategies);
        }
        if ((createdBy = (String)workItem.getParameter("CreatedBy")) != null && createdBy.trim().length() > 0) {
            taskData.setCreatedBy(new User(createdBy));
        }
        task.setTaskData(taskData);
        PeopleAssignmentHelper peopleAssignmentHelper = new PeopleAssignmentHelper();
        peopleAssignmentHelper.handlePeopleAssignments(workItem, task, taskData);
        PeopleAssignments peopleAssignments = task.getPeopleAssignments();
        List<OrganizationalEntity> businessAdministrators = peopleAssignments.getBusinessAdministrators();
        task.setDeadlines(HumanTaskHandlerHelper.setDeadlines(workItem, businessAdministrators, this.session.getEnvironment()));
        return task;
    }

    protected ContentData createTaskContentBasedOnWorkItemParams(WorkItem workItem) {
        ContentData content = null;
        HashMap contentObject = workItem.getParameter("Content");
        if (contentObject == null) {
            contentObject = new HashMap(workItem.getParameters());
        }
        if (contentObject != null) {
            content = ContentMarshallerHelper.marshal(contentObject, this.session.getEnvironment());
        }
        return content;
    }

    protected boolean isAutoClaim(WorkItem workItem, Task task) {
        String swimlaneUser = (String)workItem.getParameter("SwimlaneActorId");
        return swimlaneUser != null && !"".equals(swimlaneUser) && task.getPeopleAssignments().getPotentialOwners().size() > 1;
    }

    public abstract void executeWorkItem(WorkItem var1, WorkItemManager var2);

    public abstract void abortWorkItem(WorkItem var1, WorkItemManager var2);
}

