/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.wsht;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.eventmessaging.EventResponseHandler;
import org.jbpm.eventmessaging.Payload;
import org.jbpm.process.workitem.wsht.HumanTaskHandlerHelper;
import org.jbpm.process.workitem.wsht.PeopleAssignmentHelper;
import org.jbpm.task.AsyncTaskService;
import org.jbpm.task.Content;
import org.jbpm.task.I18NText;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.PeopleAssignments;
import org.jbpm.task.Status;
import org.jbpm.task.SubTasksStrategy;
import org.jbpm.task.SubTasksStrategyFactory;
import org.jbpm.task.Task;
import org.jbpm.task.TaskData;
import org.jbpm.task.event.TaskEventKey;
import org.jbpm.task.event.entity.TaskCompletedEvent;
import org.jbpm.task.event.entity.TaskEvent;
import org.jbpm.task.event.entity.TaskFailedEvent;
import org.jbpm.task.event.entity.TaskSkippedEvent;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.responsehandlers.AbstractBaseResponseHandler;
import org.jbpm.task.utils.ContentMarshallerHelper;
import org.jbpm.task.utils.OnErrorAction;
import org.kie.runtime.Environment;
import org.kie.runtime.KnowledgeRuntime;
import org.kie.runtime.StatefulKnowledgeSession;
import org.kie.runtime.process.WorkItem;
import org.kie.runtime.process.WorkItemHandler;
import org.kie.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class AsyncWSHumanTaskHandler
implements WorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(AsyncWSHumanTaskHandler.class);
    private String ipAddress = "127.0.0.1";
    private int port = 9123;
    private AsyncTaskService client;
    private WorkItemManager manager = null;
    private KnowledgeRuntime session;
    private OnErrorAction action;
    private Map<TaskEventKey, EventResponseHandler> eventHandlers = new HashMap<TaskEventKey, EventResponseHandler>();

    public AsyncWSHumanTaskHandler() {
        this.action = OnErrorAction.LOG;
    }

    public AsyncWSHumanTaskHandler(AsyncTaskService client) {
        this.client = client;
        this.action = OnErrorAction.LOG;
    }

    public AsyncWSHumanTaskHandler(AsyncTaskService client, KnowledgeRuntime session) {
        this.client = client;
        this.session = session;
        this.action = OnErrorAction.LOG;
    }

    public AsyncWSHumanTaskHandler(AsyncTaskService client, OnErrorAction action) {
        this.client = client;
        this.action = action;
    }

    public AsyncWSHumanTaskHandler(AsyncTaskService client, KnowledgeRuntime session, OnErrorAction action) {
        this.client = client;
        this.session = session;
        this.action = action;
    }

    public void setConnection(String ipAddress, int port) {
        this.ipAddress = ipAddress;
        this.port = port;
    }

    public void setClient(AsyncTaskService client) {
        this.client = client;
    }

    public void setAction(OnErrorAction action) {
        this.action = action;
    }

    public void connect() {
        boolean connected;
        if (this.client == null) {
            throw new IllegalStateException("You must set the client to the work item to work");
        }
        if (this.client != null && !(connected = this.client.connect(this.ipAddress, this.port))) {
            throw new IllegalArgumentException("Could not connect task client");
        }
        this.registerTaskEvents();
    }

    private void registerTaskEvents() {
        TaskEventKey key = new TaskEventKey(TaskCompletedEvent.class, -1L);
        TaskCompletedHandler eventResponseHandler = new TaskCompletedHandler(this.manager, this.session.getEnvironment(), this.client);
        this.client.registerForEvent(key, false, eventResponseHandler);
        this.eventHandlers.put(key, eventResponseHandler);
        key = new TaskEventKey(TaskFailedEvent.class, -1L);
        this.client.registerForEvent(key, false, eventResponseHandler);
        this.eventHandlers.put(key, eventResponseHandler);
        key = new TaskEventKey(TaskSkippedEvent.class, -1L);
        this.client.registerForEvent(key, false, eventResponseHandler);
        this.eventHandlers.put(key, eventResponseHandler);
    }

    public void setManager(WorkItemManager manager) {
        this.manager = manager;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        String subTaskStrategiesCommaSeparated;
        String comment;
        String taskName;
        if (this.manager == null) {
            this.manager = manager;
        } else if (this.manager != manager) {
            throw new IllegalArgumentException("This WSHumanTaskHandler can only be used for one WorkItemManager");
        }
        this.connect();
        Task task = new Task();
        String locale = (String)workItem.getParameter("Locale");
        if (locale == null) {
            locale = "en-UK";
        }
        if ((taskName = (String)workItem.getParameter("TaskName")) != null) {
            ArrayList<I18NText> names = new ArrayList<I18NText>();
            names.add(new I18NText(locale, taskName));
            task.setNames(names);
        }
        if ((comment = (String)workItem.getParameter("Comment")) == null) {
            comment = "";
        }
        ArrayList<I18NText> descriptions = new ArrayList<I18NText>();
        descriptions.add(new I18NText(locale, comment));
        task.setDescriptions(descriptions);
        ArrayList<I18NText> subjects = new ArrayList<I18NText>();
        subjects.add(new I18NText(locale, comment));
        task.setSubjects(subjects);
        String priorityString = (String)workItem.getParameter("Priority");
        int priority = 0;
        if (priorityString != null) {
            try {
                priority = new Integer(priorityString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        task.setPriority(priority);
        TaskData taskData = new TaskData();
        taskData.setWorkItemId(workItem.getId());
        taskData.setProcessInstanceId(workItem.getProcessInstanceId());
        if (this.session != null && this.session.getProcessInstance(workItem.getProcessInstanceId()) != null) {
            taskData.setProcessId(this.session.getProcessInstance(workItem.getProcessInstanceId()).getProcess().getId());
        }
        if (this.session != null && this.session instanceof StatefulKnowledgeSession) {
            taskData.setProcessSessionId(((StatefulKnowledgeSession)this.session).getId());
        }
        taskData.setSkipable(!"false".equals(workItem.getParameter("Skippable")));
        Long parentId = (Long)workItem.getParameter("ParentId");
        if (parentId != null) {
            taskData.setParentId(parentId);
        }
        if ((subTaskStrategiesCommaSeparated = (String)workItem.getParameter("SubTaskStrategies")) != null && !subTaskStrategiesCommaSeparated.equals("")) {
            String[] subTaskStrategies = subTaskStrategiesCommaSeparated.split(",");
            ArrayList<SubTasksStrategy> strategies = new ArrayList<SubTasksStrategy>();
            for (String subTaskStrategyString : subTaskStrategies) {
                SubTasksStrategy subTaskStrategy = SubTasksStrategyFactory.newStrategy(subTaskStrategyString);
                strategies.add(subTaskStrategy);
            }
            task.setSubTaskStrategies(strategies);
        }
        PeopleAssignmentHelper peopleAssignmentHelper = new PeopleAssignmentHelper();
        peopleAssignmentHelper.handlePeopleAssignments(workItem, task, taskData);
        task.setTaskData(taskData);
        ContentData content = null;
        Object contentObject = workItem.getParameter("Content");
        if (contentObject == null) {
            contentObject = workItem.getParameters();
        }
        if (contentObject != null) {
            content = ContentMarshallerHelper.marshal(contentObject, this.session.getEnvironment());
        }
        PeopleAssignments peopleAssignments = task.getPeopleAssignments();
        List<OrganizationalEntity> businessAdministrators = peopleAssignments.getBusinessAdministrators();
        task.setDeadlines(HumanTaskHandlerHelper.setDeadlines(workItem, businessAdministrators, this.session.getEnvironment()));
        this.client.addTask(task, content, new TaskAddedHandler(workItem.getId()));
    }

    public void dispose() throws Exception {
        for (TaskEventKey key : this.eventHandlers.keySet()) {
            this.client.registerForEvent(key, true, this.eventHandlers.get(key));
        }
        this.eventHandlers.clear();
        if (this.client != null) {
            this.client.disconnect();
        }
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        AbortTaskResponseHandler abortTaskResponseHandler = new AbortTaskResponseHandler(this.client);
        this.client.getTaskByWorkItemId(workItem.getId(), abortTaskResponseHandler);
    }

    private static class AbortTaskResponseHandler
    extends AbstractBaseResponseHandler
    implements TaskClientHandler.GetTaskResponseHandler {
        private AsyncTaskService client;

        public AbortTaskResponseHandler(AsyncTaskService client) {
            this.client = client;
        }

        @Override
        public void execute(Task task) {
            if (task != null) {
                this.client.exit(task.getId(), "Administrator", null);
            }
        }
    }

    private static class GetResultContentResponseHandler
    extends AbstractBaseResponseHandler
    implements TaskClientHandler.GetContentResponseHandler {
        private WorkItemManager manager;
        private Task task;
        private Map<String, Object> results;
        private Environment env;

        public GetResultContentResponseHandler(WorkItemManager manager, Environment env, Task task, Map<String, Object> results) {
            this.manager = manager;
            this.task = task;
            this.results = results;
            this.env = env;
        }

        @Override
        public void execute(Content content) {
            Object result = ContentMarshallerHelper.unmarshall(content.getContent(), this.env);
            this.results.put("Result", result);
            if (result instanceof Map) {
                Map map = (Map)result;
                for (Map.Entry entry : map.entrySet()) {
                    if (!(entry.getKey() instanceof String)) continue;
                    this.results.put((String)entry.getKey(), entry.getValue());
                }
            }
            this.manager.completeWorkItem(this.task.getTaskData().getWorkItemId(), this.results);
        }
    }

    private static class GetCompletedTaskResponseHandler
    extends AbstractBaseResponseHandler
    implements TaskClientHandler.GetTaskResponseHandler {
        private WorkItemManager manager;
        private AsyncTaskService client;
        private Environment env;

        public GetCompletedTaskResponseHandler(WorkItemManager manager, Environment env, AsyncTaskService client) {
            this.manager = manager;
            this.client = client;
            this.env = env;
        }

        @Override
        public void execute(Task task) {
            long workItemId = task.getTaskData().getWorkItemId();
            if (task.getTaskData().getStatus() == Status.Completed) {
                String userId = task.getTaskData().getActualOwner().getId();
                HashMap<String, Object> results = new HashMap<String, Object>();
                results.put("ActorId", userId);
                long contentId = task.getTaskData().getOutputContentId();
                if (contentId != -1L) {
                    GetResultContentResponseHandler getContentResponseHandler = new GetResultContentResponseHandler(this.manager, this.env, task, results);
                    this.client.getContent(contentId, getContentResponseHandler);
                } else {
                    this.manager.completeWorkItem(workItemId, results);
                }
            } else {
                this.manager.abortWorkItem(workItemId);
            }
        }
    }

    private static class TaskCompletedHandler
    extends AbstractBaseResponseHandler
    implements EventResponseHandler {
        private WorkItemManager manager;
        private AsyncTaskService client;
        private Environment env;

        public TaskCompletedHandler(WorkItemManager manager, Environment env, AsyncTaskService client) {
            this.manager = manager;
            this.client = client;
            this.env = env;
        }

        @Override
        public void execute(Payload payload) {
            TaskEvent event = (TaskEvent)payload.get();
            long taskId = event.getTaskId();
            GetCompletedTaskResponseHandler getTaskResponseHandler = new GetCompletedTaskResponseHandler(this.manager, this.env, this.client);
            this.client.getTask(taskId, getTaskResponseHandler);
        }

        @Override
        public boolean isRemove() {
            return false;
        }
    }

    private class TaskAddedHandler
    extends AbstractBaseResponseHandler
    implements TaskClientHandler.AddTaskResponseHandler {
        private long workItemId;

        public TaskAddedHandler(long workItemId) {
            this.workItemId = workItemId;
        }

        @Override
        public void execute(long taskId) {
        }

        @Override
        public synchronized void setError(RuntimeException error) {
            super.setError(error);
            if (AsyncWSHumanTaskHandler.this.action.equals((Object)OnErrorAction.ABORT)) {
                AsyncWSHumanTaskHandler.this.session.getWorkItemManager().abortWorkItem(this.workItemId);
            } else {
                if (AsyncWSHumanTaskHandler.this.action.equals((Object)OnErrorAction.RETHROW)) {
                    throw this.getError();
                }
                if (AsyncWSHumanTaskHandler.this.action.equals((Object)OnErrorAction.LOG)) {
                    StringBuffer logMsg = new StringBuffer();
                    logMsg.append(new Date() + ": Error when creating task on task server for work item id " + this.workItemId);
                    logMsg.append(". Error reported by task server: " + this.getError().getMessage());
                    logger.error(logMsg.toString(), (Throwable)this.getError());
                }
            }
        }
    }
}

