/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.event;

import java.util.HashMap;
import java.util.List;
import org.jbpm.task.event.TaskEventsAdmin;
import org.jbpm.task.event.entity.TaskEvent;
import org.jbpm.task.event.entity.TaskEventType;
import org.jbpm.task.service.persistence.TaskPersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskEventsAdminImpl
implements TaskEventsAdmin {
    protected TaskPersistenceManager tpm;
    private static final Logger logger = LoggerFactory.getLogger(TaskEventsAdminImpl.class);

    public TaskEventsAdminImpl(TaskPersistenceManager tpm) {
        this.tpm = tpm;
    }

    @Override
    public void storeEvent(TaskEvent event) {
        boolean txOwner = this.tpm.beginTransaction();
        this.tpm.saveEntity(event);
        this.tpm.endTransaction(txOwner);
    }

    @Override
    public List<TaskEvent> getEventsByTaskId(Long taskId) {
        HashMap<String, Object> params = TaskPersistenceManager.addParametersToMap("id", taskId);
        return (List)this.tpm.queryWithParametersInTransaction("TaskEventsByTaskId", params);
    }

    @Override
    public List<TaskEvent> getEventsByTypeByTaskId(Long taskId, TaskEventType type) {
        HashMap<String, Object> params = TaskPersistenceManager.addParametersToMap("taskId", taskId, "type", type.getValue());
        return (List)this.tpm.queryWithParametersInTransaction("TaskEventsByTypeByTaskId", params);
    }
}

