/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.event.entity;

public enum TaskEventType {
    Create("cr"),
    Claim("cl"),
    Stop("st"),
    Complete("co"),
    Fail("fa"),
    Forward("fo"),
    Release("re"),
    Skipped("sk"),
    Started("be"),
    Suspended("ss"),
    SuspendedUntil("su"),
    Resume("rs"),
    Removed("rm"),
    SetPriority("sp"),
    AddedAttachment("aa"),
    DeletedAttachment("da"),
    AddedComment("ac"),
    UpdatedComment("uc"),
    Delegated("de"),
    SetOutput("so"),
    DeleteOutput("do"),
    SetFault("sf"),
    DeleteFault("df"),
    Activate("at"),
    Nominate("no"),
    SetGenericHumanRole("sr"),
    Expire("ex"),
    Escalated("es"),
    Cancel("ca"),
    UnknownUserEvent("us");

    private String type;

    private TaskEventType(String t) {
        this.type = t;
    }

    public String getValue() {
        return this.type;
    }

    public static TaskEventType getTypeFromValue(String type) {
        int hashCode = type.hashCode();
        switch (hashCode) {
            case 3123: {
                return Activate;
            }
            case 3104: {
                return AddedAttachment;
            }
            case 3106: {
                return AddedComment;
            }
            case 3166: {
                return Cancel;
            }
            case 3177: {
                return Claim;
            }
            case 3180: {
                return Complete;
            }
            case 3183: {
                return Create;
            }
            case 3201: {
                return Delegated;
            }
            case 3202: {
                return DeleteFault;
            }
            case 3211: {
                return DeleteOutput;
            }
            case 3197: {
                return DeletedAttachment;
            }
            case 3246: {
                return Escalated;
            }
            case 3251: {
                return Expire;
            }
            case 3259: {
                return Fail;
            }
            case 3273: {
                return Forward;
            }
            case 3521: {
                return Nominate;
            }
            case 3635: {
                return Release;
            }
            case 3643: {
                return Removed;
            }
            case 3649: {
                return Resume;
            }
            case 3667: {
                return SetFault;
            }
            case 3679: {
                return SetGenericHumanRole;
            }
            case 3676: {
                return SetOutput;
            }
            case 3677: {
                return SetPriority;
            }
            case 3672: {
                return Skipped;
            }
            case 3139: {
                return Started;
            }
            case 3681: {
                return Stop;
            }
            case 3680: {
                return Suspended;
            }
            case 3682: {
                return SuspendedUntil;
            }
            case 3742: {
                return UnknownUserEvent;
            }
            case 3726: {
                return UpdatedComment;
            }
        }
        throw new IllegalStateException("Unknown type: " + type);
    }
}

