/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.identity;

import java.io.InputStream;
import java.util.Properties;
import org.jbpm.task.identity.UserGroupCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserGroupCallbackManager {
    public static final String USER_GROUP_CALLBACK_KEY = "jbpm.usergroup.callback";
    private static UserGroupCallbackManager instance;
    private UserGroupCallback callback = null;
    private static final Logger logger;
    private Properties callbackproperties = null;

    private UserGroupCallbackManager() {
        try {
            if (System.getProperty(USER_GROUP_CALLBACK_KEY) != null) {
                this.callback = (UserGroupCallback)Class.forName(System.getProperty(USER_GROUP_CALLBACK_KEY)).newInstance();
                logger.info("UserGroupCallback registered from system property: " + this.callback.getClass().getName());
            } else {
                InputStream in = this.getClass().getResourceAsStream("jbpm.usergroup.callback.properties");
                if (in != null) {
                    Properties callbackproperties = new Properties();
                    callbackproperties.load(in);
                    if (!this.isEmpty(callbackproperties.getProperty(USER_GROUP_CALLBACK_KEY))) {
                        this.callback = (UserGroupCallback)Class.forName(callbackproperties.getProperty(USER_GROUP_CALLBACK_KEY)).newInstance();
                        logger.info("UserGroupCallback registered from properties file: " + this.callback.getClass().getName());
                    }
                    in.close();
                }
            }
        }
        catch (Throwable t) {
            logger.error("Error trying to create callback: " + t.getMessage());
            this.callback = null;
        }
    }

    public static UserGroupCallbackManager getInstance() {
        if (instance == null) {
            instance = new UserGroupCallbackManager();
        }
        return instance;
    }

    public static void resetCallback() {
        instance = null;
    }

    public void setCallbackFromProperties(Properties callbackproperties) {
        this.callbackproperties = callbackproperties;
        try {
            if (!this.isEmpty(callbackproperties.getProperty(USER_GROUP_CALLBACK_KEY))) {
                this.callback = (UserGroupCallback)Class.forName(callbackproperties.getProperty(USER_GROUP_CALLBACK_KEY)).newInstance();
                logger.info("UserGroupCallback registered from properties file: " + this.callback.getClass().getName());
            }
        }
        catch (Throwable t) {
            logger.error("Error trying to create callback: " + t.getMessage());
            this.callback = null;
        }
    }

    public void setCallback(UserGroupCallback callback) {
        this.callback = callback;
        if (callback != null) {
            logger.info("UserGroupCallback registered: " + callback.getClass().getName());
        } else {
            logger.info("Unregistering UserGroupCallback");
        }
    }

    public boolean existsCallback() {
        return this.callback != null;
    }

    public UserGroupCallback getCallback() {
        return this.callback;
    }

    public String getProperty(String name) {
        if (this.callbackproperties != null) {
            return this.callbackproperties.getProperty(name);
        }
        return null;
    }

    public void setProperty(String name, String value) {
        if (this.callbackproperties == null) {
            this.callbackproperties = new Properties();
        }
        this.callbackproperties.setProperty(name, value);
    }

    private boolean isEmpty(CharSequence str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (str.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    static {
        logger = LoggerFactory.getLogger(UserGroupCallbackManager.class);
    }
}

