/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.drools.process.instance.impl.WorkItemImpl;
import org.jbpm.process.workitem.email.EmailWorkItemHandler;
import org.jbpm.task.Content;
import org.jbpm.task.Deadline;
import org.jbpm.task.EmailNotification;
import org.jbpm.task.EmailNotificationHeader;
import org.jbpm.task.Escalation;
import org.jbpm.task.Group;
import org.jbpm.task.Language;
import org.jbpm.task.Notification;
import org.jbpm.task.NotificationType;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.Reassignment;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.User;
import org.jbpm.task.UserInfo;
import org.jbpm.task.service.EscalatedDeadlineHandler;
import org.jbpm.task.service.TaskService;
import org.jbpm.task.utils.ContentMarshallerHelper;
import org.kie.internal.utils.ChainedProperties;
import org.kie.internal.utils.ClassLoaderUtil;
import org.kie.runtime.Environment;
import org.kie.runtime.process.WorkItem;
import org.kie.runtime.process.WorkItemManager;
import org.mvel2.templates.TemplateRuntime;

public class DefaultEscalatedDeadlineHandler
implements EscalatedDeadlineHandler {
    private UserInfo userInfo;
    private String from;
    private String replyTo;
    EmailWorkItemHandler handler;
    WorkItemManager manager;
    private Environment environment;
    private ClassLoader classLoader;
    protected List<Status> validStatuses = new ArrayList<Status>();

    public DefaultEscalatedDeadlineHandler(Properties properties) {
        this.handler = new EmailWorkItemHandler();
        String host = properties.getProperty("mail.smtp.host", "localhost");
        String port = properties.getProperty("mail.smtp.port", "25");
        String user = properties.getProperty("mail.smtp.user");
        String password = properties.getProperty("mail.smtp.password");
        this.from = properties.getProperty("from", null);
        this.replyTo = properties.getProperty("replyTo", null);
        this.handler.setConnection(host, port, user, password);
        this.setValidStatuses();
    }

    public DefaultEscalatedDeadlineHandler(Properties properties, ClassLoader classLoader) {
        this.handler = new EmailWorkItemHandler();
        String host = properties.getProperty("mail.smtp.host", "localhost");
        String port = properties.getProperty("mail.smtp.port", "25");
        String user = properties.getProperty("mail.smtp.user");
        String password = properties.getProperty("mail.smtp.password");
        this.from = properties.getProperty("from", null);
        this.replyTo = properties.getProperty("replyTo", null);
        this.handler.setConnection(host, port, user, password);
        this.classLoader = classLoader;
        this.setValidStatuses();
    }

    public DefaultEscalatedDeadlineHandler() {
        this.handler = new EmailWorkItemHandler();
        ChainedProperties conf = new ChainedProperties("email.conf", (ClassLoader)ClassLoaderUtil.getClassLoader(null, this.getClass(), (boolean)false));
        String host = conf.getProperty("host", null);
        String port = conf.getProperty("port", "25");
        String user = conf.getProperty("user", null);
        String password = conf.getProperty("password", null);
        this.from = conf.getProperty("from", null);
        this.replyTo = conf.getProperty("replyTo", null);
        this.handler.setConnection(host, port, user, password);
        this.setValidStatuses();
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public WorkItemManager getManager() {
        return this.manager;
    }

    public void setManager(WorkItemManager manager) {
        this.manager = manager;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void executeEscalatedDeadline(Task task, Deadline deadline, Content content, TaskService service) {
        if (deadline == null || deadline.getEscalations() == null || !this.isInValidStatus(task)) {
            return;
        }
        for (Escalation escalation : deadline.getEscalations()) {
            if (!escalation.getReassignments().isEmpty()) {
                Reassignment reassignment = escalation.getReassignments().get(0);
                task.getTaskData().setStatus(Status.Ready);
                ArrayList<OrganizationalEntity> potentialOwners = new ArrayList<OrganizationalEntity>(reassignment.getPotentialOwners());
                task.getPeopleAssignments().setPotentialOwners(potentialOwners);
                task.getTaskData().setActualOwner(null);
            }
            for (Notification notification : escalation.getNotifications()) {
                if (notification.getNotificationType() != NotificationType.Email) continue;
                this.executeEmailNotification((EmailNotification)notification, task, content);
            }
        }
        deadline.setEscalated(true);
    }

    public void executeEmailNotification(EmailNotification notification, Task task, Content content) {
        HashMap<String, List<User>> users = new HashMap<String, List<User>>();
        for (OrganizationalEntity entity : notification.getBusinessAdministrators()) {
            if (entity instanceof Group) {
                this.buildMapByLanguage(users, (Group)entity);
                continue;
            }
            this.buildMapByLanguage(users, (User)entity);
        }
        for (OrganizationalEntity entity : notification.getRecipients()) {
            if (entity instanceof Group) {
                this.buildMapByLanguage(users, (Group)entity);
                continue;
            }
            this.buildMapByLanguage(users, (User)entity);
        }
        HashMap<String, Object> doc = null;
        if (content != null) {
            Object objectFromBytes = null;
            try {
                objectFromBytes = ContentMarshallerHelper.unmarshall(content.getContent(), this.environment, this.classLoader);
            }
            catch (Exception e) {
                objectFromBytes = TaskService.eval(new InputStreamReader(new ByteArrayInputStream(content.getContent())));
            }
            if (objectFromBytes instanceof Map) {
                doc = (HashMap<String, Object>)objectFromBytes;
            } else {
                doc = new HashMap<String, Object>();
                doc.put("content", objectFromBytes);
            }
        } else {
            doc = Collections.emptyMap();
        }
        Map<Language, EmailNotificationHeader> headers = notification.getEmailHeaders();
        for (Map.Entry entry : users.entrySet()) {
            String emailAddress;
            EmailNotificationHeader header = headers.get(new Language((String)entry.getKey()));
            HashMap<String, String> email = new HashMap<String, String>();
            StringBuilder to = new StringBuilder();
            boolean first = true;
            for (User user : (List)entry.getValue()) {
                if (!first) {
                    to.append(';');
                }
                String emailAddress2 = this.userInfo.getEmailForEntity(user);
                to.append(emailAddress2);
                first = false;
            }
            email.put("To", to.toString());
            if (header.getFrom() != null && header.getFrom().trim().length() > 0) {
                emailAddress = this.userInfo.getEmailForEntity(new User(header.getFrom()));
                email.put("From", emailAddress);
            } else {
                email.put("From", this.from);
            }
            if (header.getReplyTo() != null && header.getReplyTo().trim().length() > 0) {
                emailAddress = this.userInfo.getEmailForEntity(new User(header.getReplyTo()));
                email.put("Reply-To", emailAddress);
            } else {
                email.put("Reply-To", this.replyTo);
            }
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("doc", doc);
            vars.put("processInstanceId", task.getTaskData().getProcessInstanceId());
            vars.put("processSessionId", task.getTaskData().getProcessSessionId());
            vars.put("workItemId", task.getTaskData().getWorkItemId());
            vars.put("expirationTime", task.getTaskData().getExpirationTime());
            vars.put("taskId", task.getId());
            vars.put("owners", task.getPeopleAssignments().getPotentialOwners());
            String subject = (String)TemplateRuntime.eval((String)header.getSubject(), vars);
            String body = (String)TemplateRuntime.eval((String)header.getBody(), vars);
            email.put("Subject", subject);
            email.put("Body", body);
            WorkItemImpl workItem = new WorkItemImpl();
            workItem.setParameters(email);
            this.handler.executeWorkItem((WorkItem)workItem, this.manager);
        }
    }

    private void buildMapByLanguage(Map<String, List<User>> map, Group group) {
        Iterator<OrganizationalEntity> it = this.userInfo.getMembersForGroup(group);
        while (it.hasNext()) {
            OrganizationalEntity entity = it.next();
            if (entity instanceof Group) {
                this.buildMapByLanguage(map, (Group)entity);
                continue;
            }
            this.buildMapByLanguage(map, (User)entity);
        }
    }

    private void buildMapByLanguage(Map<String, List<User>> map, User user) {
        String language = this.userInfo.getLanguageForEntity(user);
        List<User> list = map.get(language);
        if (list == null) {
            list = new ArrayList<User>();
            map.put(language, list);
        }
        list.add(user);
    }

    protected void setValidStatuses() {
        this.validStatuses.add(Status.Created);
        this.validStatuses.add(Status.Ready);
        this.validStatuses.add(Status.Reserved);
        this.validStatuses.add(Status.InProgress);
        this.validStatuses.add(Status.Suspended);
    }

    protected boolean isInValidStatus(Task task) {
        return this.validStatuses.contains((Object)task.getTaskData().getStatus());
    }
}

