/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityNotFoundException;
import javax.persistence.Query;
import org.drools.core.util.StringUtils;
import org.jbpm.task.Attachment;
import org.jbpm.task.Comment;
import org.jbpm.task.Content;
import org.jbpm.task.Deadline;
import org.jbpm.task.Deadlines;
import org.jbpm.task.Escalation;
import org.jbpm.task.Group;
import org.jbpm.task.Notification;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.PeopleAssignments;
import org.jbpm.task.Reassignment;
import org.jbpm.task.Status;
import org.jbpm.task.SubTasksStrategy;
import org.jbpm.task.Task;
import org.jbpm.task.TaskData;
import org.jbpm.task.User;
import org.jbpm.task.identity.UserGroupCallback;
import org.jbpm.task.identity.UserGroupCallbackManager;
import org.jbpm.task.query.DeadlineSummary;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.Allowed;
import org.jbpm.task.service.CannotAddTaskException;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.service.EscalatedDeadlineHandler;
import org.jbpm.task.service.FaultData;
import org.jbpm.task.service.Operation;
import org.jbpm.task.service.OperationCommand;
import org.jbpm.task.service.PermissionDeniedException;
import org.jbpm.task.service.SendIcal;
import org.jbpm.task.service.TaskException;
import org.jbpm.task.service.TaskService;
import org.jbpm.task.service.TaskServiceRequest;
import org.jbpm.task.service.persistence.TaskPersistenceManager;
import org.jbpm.task.utils.ContentMarshallerHelper;
import org.kie.KnowledgeBase;
import org.kie.runtime.KieSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskServiceSession {
    private final TaskPersistenceManager tpm;
    private final TaskService service;
    private Map<String, KnowledgeBase> ruleBases;
    private Map<String, Map<String, Object>> globals;
    private Map<String, Boolean> userGroupsMap = new HashMap<String, Boolean>();
    private static final Logger logger = LoggerFactory.getLogger(TaskServiceSession.class);

    public TaskServiceSession(TaskService service, TaskPersistenceManager tpm) {
        this.service = service;
        this.tpm = tpm;
        this.ruleBases = service.getKieBases();
        this.globals = service.getGlobals();
    }

    public void dispose() {
        this.tpm.dispose();
        if (this.ruleBases != null) {
            this.ruleBases.clear();
            this.ruleBases = null;
        }
        if (this.globals != null) {
            this.globals.clear();
            this.globals = null;
        }
        if (this.userGroupsMap != null) {
            this.userGroupsMap.clear();
            this.userGroupsMap = null;
        }
    }

    public TaskPersistenceManager getTaskPersistenceManager() {
        return this.tpm;
    }

    public TaskService getService() {
        return this.service;
    }

    public void setRuleBase(String type, KnowledgeBase ruleBase) {
        if (this.ruleBases == null) {
            this.ruleBases = new HashMap<String, KnowledgeBase>();
        }
        this.ruleBases.put(type, ruleBase);
    }

    public void setGlobals(String type, Map<String, Object> globals) {
        if (this.globals == null) {
            this.globals = new HashMap<String, Map<String, Object>>();
        }
        this.globals.put(type, globals);
    }

    public void addUser(User user) {
        if (!this.tpm.userExists(user.getId())) {
            this.persistInTransaction(user);
        } else {
            logger.warn("User " + user.getId() + " already exists in Task Server");
        }
    }

    public void addGroup(Group group) {
        if (!this.tpm.groupExists(group.getId())) {
            this.persistInTransaction(group);
        } else {
            logger.warn("Group " + group.getId() + " already exists in Task Server");
        }
    }

    private void executeTaskAddRules(Task task, ContentData contentData) throws CannotAddTaskException {
        KnowledgeBase ruleBase = this.ruleBases.get("addTask");
        if (ruleBase != null) {
            Map<String, Object> globals;
            KieSession session = ruleBase.newKieSession();
            if (this.globals != null && (globals = this.globals.get("addTask")) != null) {
                for (Map.Entry<String, Object> entry : globals.entrySet()) {
                    session.setGlobal(entry.getKey(), entry.getValue());
                }
            }
            TaskServiceRequest request = new TaskServiceRequest("addTask", null, null);
            session.setGlobal("request", (Object)request);
            session.insert((Object)task);
            if (contentData != null) {
                session.insert(ContentMarshallerHelper.unmarshall(contentData.getContent(), session.getEnvironment()));
            }
            session.fireAllRules();
            session.dispose();
            if (!request.isAllowed()) {
                StringBuilder error = new StringBuilder("Cannot add Task:\n");
                if (request.getReasons() != null) {
                    for (String reason : request.getReasons()) {
                        error.append(reason).append('\n');
                    }
                }
                throw new CannotAddTaskException(error.toString());
            }
        }
    }

    public void addTask(final Task task, final ContentData contentData) throws CannotAddTaskException {
        this.doCallbackOperationForPeopleAssignments(task.getPeopleAssignments());
        this.doCallbackOperationForTaskData(task.getTaskData());
        this.doCallbackOperationForTaskDeadlines(task.getDeadlines());
        TaskData taskData = task.getTaskData();
        Status currentStatus = taskData.initialize();
        PeopleAssignments assignments = task.getPeopleAssignments();
        if (assignments != null) {
            List<OrganizationalEntity> potentialOwners = assignments.getPotentialOwners();
            currentStatus = taskData.assignOwnerAndStatus(potentialOwners);
        }
        if (this.ruleBases != null) {
            this.executeTaskAddRules(task, contentData);
        }
        this.doOperationInTransaction(new TransactedOperation(){

            @Override
            public void doOperation() {
                TaskServiceSession.this.tpm.saveEntity(task);
                if (contentData != null) {
                    Content content = new Content(contentData.getContent());
                    TaskServiceSession.this.tpm.saveEntity(content);
                    task.getTaskData().setDocument(content.getId(), contentData);
                }
            }
        });
        if (task.getDeadlines() != null) {
            this.scheduleTask(task);
        }
        if ((currentStatus = task.getTaskData().getStatus()) == Status.Ready) {
            String actualOwner = "";
            if (task.getTaskData().getActualOwner() != null) {
                actualOwner = task.getTaskData().getActualOwner().getId();
            }
            this.service.getEventSupport().fireTaskCreated(task.getId(), actualOwner, task.getTaskData().getProcessSessionId());
        }
        if (currentStatus == Status.Reserved) {
            SendIcal.getInstance().sendIcalForTask(task, this.service.getUserinfo());
            this.service.getEventSupport().fireTaskClaimed(task.getId(), task.getTaskData().getActualOwner().getId(), task.getTaskData().getProcessSessionId());
        }
    }

    private void scheduleTask(Task task) {
        List<Deadline> endDeadlines;
        long now = System.currentTimeMillis();
        List<Deadline> startDeadlines = task.getDeadlines().getStartDeadlines();
        if (startDeadlines != null) {
            this.scheduleDeadlines(startDeadlines, now, task.getId());
        }
        if ((endDeadlines = task.getDeadlines().getEndDeadlines()) != null) {
            this.scheduleDeadlines(endDeadlines, now, task.getId());
        }
    }

    public void scheduleUnescalatedDeadlines() {
        long now = System.currentTimeMillis();
        for (DeadlineSummary summary : this.tpm.getUnescalatedDeadlines()) {
            TaskService.ScheduledTaskDeadline deadline = new TaskService.ScheduledTaskDeadline(summary.getTaskId(), summary.getDeadlineId(), this.service);
            long delay = summary.getDate().getTime() - now;
            this.service.schedule(deadline, delay);
        }
    }

    private void scheduleDeadlines(List<Deadline> deadlines, long now, long taskId) {
        for (Deadline deadline : deadlines) {
            if (deadline.isEscalated().booleanValue()) continue;
            Date date = deadline.getDate();
            this.service.schedule(new TaskService.ScheduledTaskDeadline(taskId, deadline.getId(), this.service), date.getTime() - now);
        }
    }

    void evalCommand(Operation operation, List<OperationCommand> commands, Task task, User user, OrganizationalEntity targetEntity, List<String> groupIds) throws PermissionDeniedException {
        TaskData taskData = task.getTaskData();
        boolean statusMatched = false;
        for (OperationCommand command : commands) {
            if (command.getStatus() != null) {
                for (Status status : command.getStatus()) {
                    if (taskData.getStatus() == status) {
                        statusMatched = true;
                        if (!this.isAllowed(command, task, user, groupIds)) {
                            String errorMessage = "User '" + user + "' does not have permissions to execution operation '" + (Object)((Object)operation) + "' on task id " + task.getId();
                            throw new PermissionDeniedException(errorMessage);
                        }
                        this.commands(command, task, user, targetEntity);
                        continue;
                    }
                    logger.debug("No match on status for task " + task.getId() + ": status " + (Object)((Object)taskData.getStatus()) + " != " + (Object)((Object)status));
                }
            }
            if (command.getPreviousStatus() == null) continue;
            for (Status status : command.getPreviousStatus()) {
                if (taskData.getPreviousStatus() == status) {
                    statusMatched = true;
                    if (!this.isAllowed(command, task, user, groupIds)) {
                        String errorMessage = "User '" + user + "' does not have permissions to execution operation '" + (Object)((Object)operation) + "' on task id " + task.getId();
                        throw new PermissionDeniedException(errorMessage);
                    }
                    this.commands(command, task, user, targetEntity);
                    continue;
                }
                logger.debug("No match on previous status for task " + task.getId() + ": status " + (Object)((Object)taskData.getStatus()) + " != " + (Object)((Object)status));
            }
        }
        if (!statusMatched) {
            String errorMessage = "User '" + user + "' was unable to execution operation '" + (Object)((Object)operation) + "' on task id " + task.getId() + " due to a no 'current status' match";
            throw new PermissionDeniedException(errorMessage);
        }
    }

    private boolean isAllowed(OperationCommand command, Task task, User user, List<String> groupIds) {
        PeopleAssignments people = task.getPeopleAssignments();
        TaskData taskData = task.getTaskData();
        boolean operationAllowed = false;
        for (Allowed allowed : command.getAllowed()) {
            if (operationAllowed) break;
            switch (allowed) {
                case Owner: {
                    operationAllowed = taskData.getActualOwner() != null && taskData.getActualOwner().equals(user);
                    break;
                }
                case Initiator: {
                    operationAllowed = taskData.getCreatedBy() != null && taskData.getCreatedBy().equals(user) || groupIds != null && groupIds.contains(taskData.getCreatedBy().getId());
                    break;
                }
                case PotentialOwner: {
                    operationAllowed = this.isAllowed(user, groupIds, people.getPotentialOwners());
                    break;
                }
                case BusinessAdministrator: {
                    operationAllowed = this.isAllowed(user, groupIds, people.getBusinessAdministrators());
                    break;
                }
                case Anyone: {
                    operationAllowed = true;
                }
            }
        }
        if (operationAllowed && command.isUserIsExplicitPotentialOwner()) {
            operationAllowed = people.getPotentialOwners().contains(user);
        }
        if (operationAllowed && command.isSkippable()) {
            operationAllowed = taskData.isSkipable();
        }
        return operationAllowed;
    }

    private void commands(OperationCommand command, Task task, User user, OrganizationalEntity targetEntity) {
        PeopleAssignments people = task.getPeopleAssignments();
        TaskData taskData = task.getTaskData();
        if (command.getNewStatus() != null) {
            taskData.setStatus(command.getNewStatus());
        } else if (command.isSetToPreviousStatus()) {
            taskData.setStatus(taskData.getPreviousStatus());
        }
        if (command.isAddTargetEntityToPotentialOwners() && !people.getPotentialOwners().contains(targetEntity)) {
            people.getPotentialOwners().add(targetEntity);
        }
        if (command.isRemoveUserFromPotentialOwners()) {
            people.getPotentialOwners().remove(user);
        }
        if (command.isSetNewOwnerToUser()) {
            taskData.setActualOwner(user);
        }
        if (command.isSetNewOwnerToNull()) {
            taskData.setActualOwner(null);
        }
        if (command.getExec() != null) {
            switch (command.getExec()) {
                case Claim: {
                    taskData.setActualOwner((User)targetEntity);
                    SendIcal.getInstance().sendIcalForTask(task, this.service.getUserinfo());
                    this.service.getEventSupport().fireTaskClaimed(task.getId(), task.getTaskData().getActualOwner().getId(), task.getTaskData().getProcessSessionId());
                }
            }
        }
    }

    public void taskOperation(Operation operation, long taskId, String userId, String targetEntityId, ContentData data, List<String> groupIds) throws TaskException {
        OrganizationalEntity targetEntity = null;
        groupIds = this.doUserGroupCallbackOperation(userId, groupIds);
        this.doCallbackUserOperation(targetEntityId);
        if (targetEntityId != null) {
            targetEntity = this.getEntity(OrganizationalEntity.class, targetEntityId);
        }
        final Task task = this.getTask(taskId);
        User user = this.getEntity(User.class, userId);
        boolean transactionOwner = false;
        try {
            List<OperationCommand> commands = this.service.getCommandsForOperation(operation);
            transactionOwner = this.tpm.beginTransaction();
            this.evalCommand(operation, commands, task, user, targetEntity, groupIds);
            switch (operation) {
                case Claim: {
                    this.taskClaimOperation(task);
                    break;
                }
                case Complete: {
                    this.taskCompleteOperation(task, data);
                    break;
                }
                case Fail: {
                    this.taskFailOperation(task, data);
                    break;
                }
                case Skip: {
                    this.taskSkipOperation(task, userId);
                    break;
                }
                case Remove: {
                    this.taskRemoveOperation(task, user);
                    break;
                }
                case Register: {
                    this.taskRegisterOperation(task, user);
                }
            }
            switch (operation) {
                case Start: {
                    this.postTaskStartOperation(task);
                    break;
                }
                case Forward: {
                    this.postTaskForwardOperation(task);
                    break;
                }
                case Release: {
                    this.postTaskReleaseOperation(task);
                    break;
                }
                case Stop: {
                    this.postTaskStopOperation(task);
                    break;
                }
                case Claim: {
                    this.postTaskClaimOperation(task);
                    break;
                }
                case Complete: {
                    this.postTaskCompleteOperation(task);
                    break;
                }
                case Fail: {
                    this.postTaskFailOperation(task);
                    break;
                }
                case Skip: {
                    this.postTaskSkipOperation(task, userId);
                    break;
                }
                case Exit: {
                    this.postTaskExitOperation(task, userId);
                }
            }
            this.tpm.endTransaction(transactionOwner);
        }
        catch (RuntimeException re) {
            boolean takeOverTransaction = true;
            this.tpm.rollBackTransaction(takeOverTransaction);
            this.doOperationInTransaction(new TransactedOperation(){

                @Override
                public void doOperation() {
                    task.getTaskData().setStatus(Status.Error);
                }
            });
            throw re;
        }
    }

    private void taskClaimOperation(Task task) {
        task.getTaskData().setClaimTime(new Date());
        SendIcal.getInstance().sendIcalForTask(task, this.service.getUserinfo());
    }

    private void postTaskClaimOperation(Task task) {
        this.service.getEventSupport().fireTaskClaimed(task.getId(), task.getTaskData().getActualOwner().getId(), task.getTaskData().getProcessSessionId());
    }

    private void postTaskStartOperation(Task task) {
        this.service.getEventSupport().fireTaskStarted(task.getId(), task.getTaskData().getActualOwner().getId(), task.getTaskData().getProcessSessionId());
    }

    private void postTaskForwardOperation(Task task) {
        String actualOwner = "";
        if (task.getTaskData().getActualOwner() != null) {
            actualOwner = task.getTaskData().getActualOwner().getId();
        }
        this.service.getEventSupport().fireTaskForwarded(task.getId(), actualOwner, task.getTaskData().getProcessSessionId());
    }

    private void postTaskReleaseOperation(Task task) {
        String actualOwner = "";
        if (task.getTaskData().getActualOwner() != null) {
            actualOwner = task.getTaskData().getActualOwner().getId();
        }
        this.service.getEventSupport().fireTaskReleased(task.getId(), actualOwner, task.getTaskData().getProcessSessionId());
    }

    private void postTaskStopOperation(Task task) {
        this.service.getEventSupport().fireTaskStopped(task.getId(), task.getTaskData().getActualOwner().getId(), task.getTaskData().getProcessSessionId());
    }

    private void taskCompleteOperation(Task task, ContentData data) {
        task.getTaskData().setCompletedOn(new Date());
        if (data != null) {
            this.setOutput(task.getId(), task.getTaskData().getActualOwner().getId(), data);
        }
        this.checkSubTaskStrategy(task);
    }

    private void postTaskCompleteOperation(Task task) {
        this.service.unschedule(task.getId());
        this.clearDeadlines(task);
        this.service.getEventSupport().fireTaskCompleted(task.getId(), task.getTaskData().getActualOwner().getId(), task.getTaskData().getProcessSessionId());
    }

    private void taskFailOperation(Task task, ContentData data) {
        if (data != null) {
            this.setFault(task.getId(), task.getTaskData().getActualOwner().getId(), (FaultData)data);
        }
    }

    private void postTaskFailOperation(Task task) {
        this.service.unschedule(task.getId());
        this.clearDeadlines(task);
        this.service.getEventSupport().fireTaskFailed(task.getId(), task.getTaskData().getActualOwner().getId(), task.getTaskData().getProcessSessionId());
    }

    private void taskSkipOperation(Task task, String userId) {
        this.checkSubTaskStrategy(task);
    }

    private void postTaskSkipOperation(Task task, String userId) {
        this.service.unschedule(task.getId());
        this.clearDeadlines(task);
        this.service.getEventSupport().fireTaskSkipped(task.getId(), userId, task.getTaskData().getProcessSessionId());
    }

    private void postTaskExitOperation(Task task, String userId) {
        this.service.unschedule(task.getId());
        this.clearDeadlines(task);
    }

    public Task getTask(long taskId) {
        return this.getEntity(Task.class, taskId);
    }

    public Deadline getDeadline(long deadlineId) {
        return (Deadline)this.tpm.findEntity(Deadline.class, deadlineId);
    }

    public void setTaskStatus(long taskId, Status status) {
        this.tpm.setTaskStatusInTransaction(taskId, status);
    }

    public void addComment(long taskId, final Comment comment) {
        final Task task = this.getTask(taskId);
        this.doCallbackOperationForComment(comment);
        this.doOperationInTransaction(new TransactedOperation(){

            @Override
            public void doOperation() {
                task.getTaskData().addComment(comment);
            }
        });
    }

    public void addAttachment(long taskId, final Attachment attachment, final Content content) {
        final Task task = this.getTask(taskId);
        this.doCallbackOperationForAttachment(attachment);
        this.doOperationInTransaction(new TransactedOperation(){

            @Override
            public void doOperation() {
                TaskServiceSession.this.tpm.saveEntity(content);
                attachment.setContent(content);
                task.getTaskData().addAttachment(attachment);
            }
        });
    }

    public void setDocumentContent(long taskId, final Content content) {
        final Task task = this.getTask(taskId);
        this.doOperationInTransaction(new TransactedOperation(){

            @Override
            public void doOperation() {
                TaskServiceSession.this.tpm.saveEntity(content);
                task.getTaskData().setDocumentContentId(content.getId());
            }
        });
    }

    public Content getContent(final long contentId) {
        final Content[] result = new Content[]{null};
        this.doOperationInTransaction(new TransactedOperation(){

            @Override
            public void doOperation() {
                result[0] = (Content)TaskServiceSession.this.tpm.findEntity(Content.class, contentId);
            }
        });
        return result[0];
    }

    public void deleteAttachment(long taskId, final long attachmentId, final long contentId) {
        final Task task = this.getTask(taskId);
        this.doOperationInTransaction(new TransactedOperation(){

            @Override
            public void doOperation() {
                Attachment removedAttachment = task.getTaskData().removeAttachment(attachmentId);
                if (removedAttachment != null) {
                    TaskServiceSession.this.tpm.deleteEntity(removedAttachment);
                }
                String deleteContent = "delete from Content c where c.id = :id";
                Query query = TaskServiceSession.this.tpm.createNewQuery("delete from Content c where c.id = :id");
                query.setParameter("id", (Object)contentId);
                query.executeUpdate();
            }
        });
    }

    public void deleteComment(long taskId, final long commentId) {
        final Task task = this.getTask(taskId);
        this.doOperationInTransaction(new TransactedOperation(){

            @Override
            public void doOperation() {
                Comment removedComment = task.getTaskData().removeComment(commentId);
                if (removedComment != null) {
                    TaskServiceSession.this.tpm.deleteEntity(removedComment);
                }
            }
        });
    }

    public void claimNextAvailable(String userId, String language) {
        this.doCallbackUserOperation(userId);
        ArrayList<Status> status = new ArrayList<Status>();
        status.add(Status.Ready);
        List<TaskSummary> queryTasks = this.getTasksAssignedAsPotentialOwnerByStatus(userId, status, language);
        if (queryTasks.size() > 0) {
            this.taskOperation(Operation.Claim, queryTasks.get(0).getId(), userId, null, null, null);
        } else {
            logger.info(" No Task Available to Assign");
        }
    }

    @Deprecated
    public void claimNextAvailable(String userId, List<String> groupIds, String language) {
        this.doCallbackUserOperation(userId);
        groupIds = this.doUserGroupCallbackOperation(userId, groupIds);
        ArrayList<Status> status = new ArrayList<Status>();
        status.add(Status.Ready);
        List<TaskSummary> queryTasks = this.getTasksAssignedAsPotentialOwnerByStatusByGroup(userId, groupIds, status, language);
        if (queryTasks.size() > 0) {
            this.taskOperation(Operation.Claim, queryTasks.get(0).getId(), userId, null, null, groupIds);
        } else {
            logger.info(" No Task Available to Assign");
        }
    }

    @Deprecated
    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, String language) {
        return this.getTasksAssignedAsPotentialOwner(userId, groupIds, language, -1, -1);
    }

    public Task getTaskByWorkItemId(long workItemId) {
        HashMap<String, Object> params = TaskPersistenceManager.addParametersToMap("workItemId", workItemId);
        Object taskObject = this.tpm.queryWithParametersInTransaction("TaskByWorkItemId", params, true);
        return (Task)taskObject;
    }

    public List<Long> getTasksByProcessInstanceId(long processInstanceId) {
        HashMap<String, Object> params = TaskPersistenceManager.addParametersToMap("processInstanceId", processInstanceId);
        return (List)this.tpm.queryWithParametersInTransaction("TasksByProcessInstanceId", params, false);
    }

    public List<TaskSummary> getTasksOwned(String userId, String language) {
        this.doCallbackUserOperation(userId);
        return this.tpm.queryTasksWithUserIdAndLanguage("TasksOwned", userId, language);
    }

    public List<TaskSummary> getTasksOwned(String userId, List<Status> status, String language) {
        this.doCallbackUserOperation(userId);
        return this.tpm.queryTasksWithUserIdStatusAndLanguage("TasksOwnedWithParticularStatus", userId, status, language);
    }

    public List<TaskSummary> getTasksAssignedAsBusinessAdministrator(String userId, String language) {
        this.doCallbackUserOperation(userId);
        return this.tpm.queryTasksWithUserIdAndLanguage("TasksAssignedAsBusinessAdministrator", userId, language);
    }

    public List<TaskSummary> getTasksAssignedAsExcludedOwner(String userId, String language) {
        this.doCallbackUserOperation(userId);
        return this.tpm.queryTasksWithUserIdAndLanguage("TasksAssignedAsExcludedOwner", userId, language);
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, String language) {
        return this.getTasksAssignedAsPotentialOwner(userId, language, -1, -1);
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByStatus(String userId, List<Status> status, String language) {
        this.doCallbackUserOperation(userId);
        List<String> groupIds = this.doUserGroupCallbackOperation(userId, null);
        if (groupIds == null || groupIds.size() == 0) {
            HashMap<String, Object> params = TaskPersistenceManager.addParametersToMap("userId", userId, "language", language, "status", status);
            return (List)this.tpm.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerByStatus", params);
        }
        HashMap<String, Object> params = TaskPersistenceManager.addParametersToMap("userId", userId, "groupIds", groupIds, "language", language, "status", status);
        return (List)this.tpm.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerByStatusWithGroups", params);
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, String language, int firstResult, int maxResults) {
        this.doCallbackUserOperation(userId);
        List<String> groupIds = this.doUserGroupCallbackOperation(userId, null);
        if (groupIds == null || groupIds.size() == 0) {
            HashMap<String, Object> params = TaskPersistenceManager.addParametersToMap("userId", userId, "language", language);
            if (maxResults != -1) {
                params.put("firstResult", firstResult);
                params.put("maxResults", maxResults);
            }
            return (List)this.tpm.queryWithParametersInTransaction("TasksAssignedAsPotentialOwner", params);
        }
        HashMap<String, Object> params = TaskPersistenceManager.addParametersToMap("userId", userId, "groupIds", groupIds, "language", language);
        if (maxResults != -1) {
            params.put("firstResult", firstResult);
            params.put("maxResults", maxResults);
        }
        return (List)this.tpm.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerWithGroups", params);
    }

    @Deprecated
    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, String language, int firstResult, int maxResults) {
        this.doCallbackUserOperation(userId);
        groupIds = this.doUserGroupCallbackOperation(userId, groupIds);
        HashMap<String, Object> params = TaskPersistenceManager.addParametersToMap("userId", userId, "groupIds", groupIds, "language", language);
        if (maxResults != -1) {
            params.put("firstResult", firstResult);
            params.put("maxResults", maxResults);
        }
        return (List)this.tpm.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerWithGroups", params);
    }

    public List<TaskSummary> getSubTasksAssignedAsPotentialOwner(long parentId, String userId, String language) {
        this.doCallbackUserOperation(userId);
        List<String> groupIds = this.doUserGroupCallbackOperation(userId, null);
        HashMap<String, Object> params = TaskPersistenceManager.addParametersToMap("userId", userId, "groupIds", groupIds, "parentId", parentId, "language", language);
        return (List)this.tpm.queryWithParametersInTransaction("SubTasksAssignedAsPotentialOwner", params);
    }

    @Deprecated
    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByGroup(String groupId, String language) {
        this.doCallbackGroupOperation(groupId);
        HashMap<String, Object> params = TaskPersistenceManager.addParametersToMap("groupId", groupId, "language", language);
        return (List)this.tpm.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerByGroup", params);
    }

    public List<TaskSummary> getSubTasksByParent(long parentId, String language) {
        HashMap<String, Object> params = TaskPersistenceManager.addParametersToMap("parentId", parentId, "language", language);
        return (List)this.tpm.queryWithParametersInTransaction("GetSubTasksByParentTaskId", params);
    }

    public List<TaskSummary> getTasksAssignedAsRecipient(String userId, String language) {
        this.doCallbackUserOperation(userId);
        return this.tpm.queryTasksWithUserIdAndLanguage("TasksAssignedAsRecipient", userId, language);
    }

    public List<TaskSummary> getTasksAssignedAsTaskInitiator(String userId, String language) {
        this.doCallbackUserOperation(userId);
        return this.tpm.queryTasksWithUserIdAndLanguage("TasksAssignedAsTaskInitiator", userId, language);
    }

    public List<TaskSummary> getTasksAssignedAsTaskStakeholder(String userId, String language) {
        this.doCallbackUserOperation(userId);
        return this.tpm.queryTasksWithUserIdAndLanguage("TasksAssignedAsTaskStakeholder", userId, language);
    }

    @Deprecated
    public List<?> query(String qlString, Integer size, Integer offset) {
        String regex = "(?i) *select .*";
        String badRegex = "(?i).*(delete|update) .*";
        if (!qlString.matches(regex) || qlString.matches(badRegex)) {
            throw new UnsupportedOperationException("Only select queries are supported: '" + qlString + "'");
        }
        Query genericQuery = this.tpm.createNewQuery(qlString);
        genericQuery.setMaxResults(size.intValue());
        genericQuery.setFirstResult(offset.intValue());
        return genericQuery.getResultList();
    }

    private void taskRemoveOperation(Task task, User user) {
        if (!task.getPeopleAssignments().getRecipients().contains(user)) {
            throw new RuntimeException("Couldn't remove user " + user.getId() + " since it isn't a notification recipient");
        }
        task.getPeopleAssignments().getRecipients().remove(user);
    }

    private void taskRegisterOperation(Task task, User user) {
        if (!task.getPeopleAssignments().getRecipients().contains(user)) {
            task.getPeopleAssignments().getRecipients().add(user);
        }
    }

    public void nominateTask(long taskId, String userId, final List<OrganizationalEntity> potentialOwners) {
        this.doCallbackUserOperation(userId);
        this.doCallbackOperationForPotentialOwners(potentialOwners);
        final Task task = this.getEntity(Task.class, taskId);
        User user = this.getEntity(User.class, userId);
        if (!this.isAllowed(user, null, task.getPeopleAssignments().getBusinessAdministrators())) {
            throw new PermissionDeniedException("User " + userId + " is not allowed to perform Nominate on Task " + taskId);
        }
        this.doOperationInTransaction(new TransactedOperation(){

            @Override
            public void doOperation() {
                task.getTaskData().assignOwnerAndStatus(potentialOwners);
                if (task.getTaskData().getStatus() == Status.Ready) {
                    task.getPeopleAssignments().setPotentialOwners(potentialOwners);
                }
            }
        });
    }

    private Task getTaskAndCheckTaskUserId(long taskId, String userId, String operation) {
        Task task = this.getEntity(Task.class, taskId);
        if (!userId.equals(task.getTaskData().getActualOwner().getId())) {
            throw new RuntimeException("User " + userId + " is not the actual owner of the task " + taskId + " and can't perform " + operation);
        }
        return task;
    }

    public void setOutput(long taskId, String userId, final ContentData outputContentData) {
        final Task task = this.getTaskAndCheckTaskUserId(taskId, userId, "setOutput");
        this.doOperationInTransaction(new TransactedOperation(){

            @Override
            public void doOperation() {
                Content content = new Content();
                content.setContent(outputContentData.getContent());
                TaskServiceSession.this.tpm.saveEntity(content);
                task.getTaskData().setOutput(content.getId(), outputContentData);
            }
        });
    }

    public void setFault(long taskId, String userId, final FaultData faultContentData) {
        final Task task = this.getTaskAndCheckTaskUserId(taskId, userId, "setFault");
        this.doOperationInTransaction(new TransactedOperation(){

            @Override
            public void doOperation() {
                Content content = new Content();
                content.setContent(faultContentData.getContent());
                TaskServiceSession.this.tpm.saveEntity(content);
                task.getTaskData().setFault(content.getId(), faultContentData);
            }
        });
    }

    public void setPriority(final long taskId, String userId, final int priority) {
        this.doOperationInTransaction(new TransactedOperation(){

            @Override
            public void doOperation() {
                Task task = (Task)TaskServiceSession.this.getEntity(Task.class, taskId);
                task.setPriority(priority);
            }
        });
    }

    public void deleteOutput(long taskId, String userId) {
        final Task task = this.getTaskAndCheckTaskUserId(taskId, userId, "deleteOutput");
        this.doOperationInTransaction(new TransactedOperation(){

            @Override
            public void doOperation() {
                long contentId = task.getTaskData().getOutputContentId();
                Content content = (Content)TaskServiceSession.this.tpm.findEntity(Content.class, contentId);
                ContentData data = new ContentData();
                TaskServiceSession.this.tpm.deleteEntity(content);
                task.getTaskData().setOutput(0L, data);
            }
        });
    }

    public void deleteFault(long taskId, String userId) {
        final Task task = this.getTask(taskId);
        if (!userId.equals(task.getTaskData().getActualOwner().getId())) {
            throw new RuntimeException("User " + userId + " is not the actual owner of the task " + taskId + " and can't perform deleteFault");
        }
        this.doOperationInTransaction(new TransactedOperation(){

            @Override
            public void doOperation() {
                long contentId = task.getTaskData().getFaultContentId();
                Content content = (Content)TaskServiceSession.this.tpm.findEntity(Content.class, contentId);
                FaultData data = new FaultData();
                TaskServiceSession.this.tpm.deleteEntity(content);
                task.getTaskData().setFault(0L, data);
            }
        });
    }

    private boolean isAllowed(User user, List<String> groupIds, List<OrganizationalEntity> entities) {
        for (OrganizationalEntity entity : entities) {
            if (entity instanceof User && entity.equals(user)) {
                return true;
            }
            if (!(entity instanceof Group) || groupIds == null || !groupIds.contains(entity.getId())) continue;
            return true;
        }
        return false;
    }

    private void checkSubTaskStrategy(Task task) {
        for (SubTasksStrategy strategy : task.getSubTaskStrategies()) {
            strategy.execute(this, this.service, task);
        }
        if (task.getTaskData().getParentId() != -1L) {
            Task parentTask = this.getTask(task.getTaskData().getParentId());
            for (SubTasksStrategy strategy : parentTask.getSubTaskStrategies()) {
                strategy.execute(this, this.service, parentTask);
            }
        }
    }

    private <T> T getEntity(final Class<T> entityClass, final Object primaryKey) {
        final Object[] result = new Object[1];
        this.doOperationInTransaction(new TransactedOperation(){

            @Override
            public void doOperation() {
                result[0] = TaskServiceSession.this.tpm.findEntity(entityClass, primaryKey);
            }
        });
        Object entity = result[0];
        if (entity == null) {
            throw new EntityNotFoundException("No " + entityClass.getSimpleName() + " with ID " + primaryKey + " was found!");
        }
        return (T)entity;
    }

    private void persistInTransaction(final Object object) {
        this.doOperationInTransaction(new TransactedOperation(){

            @Override
            public void doOperation() {
                TaskServiceSession.this.tpm.saveEntity(object);
            }
        });
    }

    public void doOperationInTransaction(TransactedOperation operation) {
        boolean txOwner = false;
        boolean operationSuccessful = false;
        boolean txStarted = false;
        try {
            txOwner = this.tpm.beginTransaction();
            txStarted = true;
            operation.doOperation();
            operationSuccessful = true;
            this.tpm.endTransaction(txOwner);
        }
        catch (Exception e) {
            this.tpm.rollBackTransaction(txOwner);
            String message = !txStarted ? "Could not start transaction." : (!operationSuccessful ? "Operation failed" : "Could not commit transaction");
            if (e instanceof TaskException) {
                throw (TaskException)e;
            }
            throw new RuntimeException(message, e);
        }
    }

    @Deprecated
    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByStatusByGroup(String userId, List<String> groupIds, List<Status> status, String language) {
        this.doCallbackUserOperation(userId);
        HashMap<String, Object> params = TaskPersistenceManager.addParametersToMap("userId", userId, "groupIds", groupIds, "language", language, "status", status);
        return (List)this.tpm.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerByStatusWithGroups", params);
    }

    public List<TaskSummary> getTasksByStatusByProcessId(long processInstanceId, List<Status> status, String language) {
        HashMap<String, Object> params = TaskPersistenceManager.addParametersToMap("processInstanceId", processInstanceId, "status", status, "language", language);
        List result = (List)this.tpm.queryWithParametersInTransaction("TasksByStatusByProcessId", params);
        return result;
    }

    public List<TaskSummary> getTasksByStatusByProcessIdByTaskName(long processInstanceId, List<Status> status, String taskName, String language) {
        HashMap<String, Object> params = TaskPersistenceManager.addParametersToMap("processInstanceId", processInstanceId, "status", status, "taskName", taskName, "language", language);
        List result = (List)this.tpm.queryWithParametersInTransaction("TasksByStatusByProcessIdByTaskName", params);
        return result;
    }

    public void executeEscalatedDeadline(EscalatedDeadlineHandler escalatedDeadlineHandler, TaskService service, long taskId, long deadlineId) {
        boolean txOwner = false;
        boolean operationSuccessful = false;
        boolean txStarted = false;
        try {
            txOwner = this.tpm.beginTransaction();
            txStarted = true;
            Task task = (Task)this.tpm.findEntity(Task.class, taskId);
            Deadline deadline = (Deadline)this.tpm.findEntity(Deadline.class, deadlineId);
            TaskData taskData = task.getTaskData();
            Content content = null;
            if (taskData != null) {
                content = (Content)this.tpm.findEntity(Content.class, taskData.getDocumentContentId());
            }
            escalatedDeadlineHandler.executeEscalatedDeadline(task, deadline, content, service);
            operationSuccessful = true;
            this.tpm.endTransaction(txOwner);
        }
        catch (Exception e) {
            this.tpm.rollBackTransaction(txOwner);
            String message = !txStarted ? "Could not start transaction." : (!operationSuccessful ? "Operation failed" : "Could not commit transaction");
            throw new RuntimeException(message, e);
        }
    }

    private List<String> doUserGroupCallbackOperation(String userId, List<String> groupIds) {
        if (UserGroupCallbackManager.getInstance().existsCallback()) {
            this.doCallbackUserOperation(userId);
            this.doCallbackGroupsOperation(userId, groupIds);
            List<String> allGroupIds = null;
            return UserGroupCallbackManager.getInstance().getCallback().getGroupsForUser(userId, groupIds, allGroupIds);
        }
        logger.debug("UserGroupCallback has not been registered.");
        return groupIds;
    }

    private boolean doCallbackUserOperation(String userId) {
        if (UserGroupCallbackManager.getInstance().existsCallback()) {
            if (userId != null && UserGroupCallbackManager.getInstance().getCallback().existsUser(userId)) {
                this.addUserFromCallbackOperation(userId);
                return true;
            }
            return false;
        }
        logger.debug("UserGroupCallback has not been registered.");
        return true;
    }

    private boolean doCallbackGroupOperation(String groupId) {
        if (UserGroupCallbackManager.getInstance().existsCallback()) {
            if (groupId != null && UserGroupCallbackManager.getInstance().getCallback().existsGroup(groupId)) {
                this.addGroupFromCallbackOperation(groupId);
                return true;
            }
            return false;
        }
        logger.debug("UserGroupCallback has not been registered.");
        return true;
    }

    private void doCallbackOperationForTaskData(TaskData data) {
        if (UserGroupCallbackManager.getInstance().existsCallback() && data != null) {
            boolean userExists;
            if (data.getActualOwner() != null && !(userExists = this.doCallbackUserOperation(data.getActualOwner().getId()))) {
                data.setActualOwner(null);
                data.setStatus(Status.Ready);
            }
            if (data.getCreatedBy() != null && !(userExists = this.doCallbackUserOperation(data.getCreatedBy().getId()))) {
                data.setCreatedBy(null);
            }
        }
    }

    private void doCallbackOperationForPotentialOwners(List<OrganizationalEntity> potentialOwners) {
        if (UserGroupCallbackManager.getInstance().existsCallback() && potentialOwners != null) {
            ArrayList<OrganizationalEntity> nonExistingEntities = new ArrayList<OrganizationalEntity>();
            for (OrganizationalEntity orgEntity : potentialOwners) {
                boolean groupExists;
                boolean userExists;
                if (orgEntity instanceof User && !(userExists = this.doCallbackUserOperation(orgEntity.getId()))) {
                    nonExistingEntities.add(orgEntity);
                }
                if (!(orgEntity instanceof Group) || (groupExists = this.doCallbackGroupOperation(orgEntity.getId()))) continue;
                nonExistingEntities.add(orgEntity);
            }
            if (!nonExistingEntities.isEmpty()) {
                potentialOwners.removeAll(nonExistingEntities);
            }
        }
    }

    private void doCallbackOperationForPeopleAssignments(PeopleAssignments assignments) {
        if (UserGroupCallbackManager.getInstance().existsCallback()) {
            ArrayList<OrganizationalEntity> nonExistingEntities = new ArrayList<OrganizationalEntity>();
            if (assignments != null) {
                List<OrganizationalEntity> stakeholders;
                List<OrganizationalEntity> recipients;
                List<OrganizationalEntity> excludedOwners;
                List<OrganizationalEntity> businessAdmins = assignments.getBusinessAdministrators();
                if (businessAdmins != null) {
                    for (OrganizationalEntity admin : businessAdmins) {
                        boolean groupExists;
                        boolean userExists;
                        if (admin instanceof User && !(userExists = this.doCallbackUserOperation(admin.getId()))) {
                            nonExistingEntities.add(admin);
                        }
                        if (!(admin instanceof Group) || (groupExists = this.doCallbackGroupOperation(admin.getId()))) continue;
                        nonExistingEntities.add(admin);
                    }
                    if (!nonExistingEntities.isEmpty()) {
                        businessAdmins.removeAll(nonExistingEntities);
                        nonExistingEntities.clear();
                    }
                }
                if (businessAdmins == null || businessAdmins.isEmpty()) {
                    throw new CannotAddTaskException("There are no known Business Administrators, task cannot be created according to WS-HT specification");
                }
                List<OrganizationalEntity> potentialOwners = assignments.getPotentialOwners();
                if (potentialOwners != null) {
                    for (OrganizationalEntity powner : potentialOwners) {
                        boolean groupExists;
                        boolean userExists;
                        if (powner instanceof User && !(userExists = this.doCallbackUserOperation(powner.getId()))) {
                            nonExistingEntities.add(powner);
                        }
                        if (!(powner instanceof Group) || (groupExists = this.doCallbackGroupOperation(powner.getId()))) continue;
                        nonExistingEntities.add(powner);
                    }
                    if (!nonExistingEntities.isEmpty()) {
                        potentialOwners.removeAll(nonExistingEntities);
                        nonExistingEntities.clear();
                    }
                }
                if (assignments.getTaskInitiator() != null && assignments.getTaskInitiator().getId() != null) {
                    this.doCallbackUserOperation(assignments.getTaskInitiator().getId());
                }
                if ((excludedOwners = assignments.getExcludedOwners()) != null) {
                    for (OrganizationalEntity exowner : excludedOwners) {
                        boolean groupExists;
                        boolean userExists;
                        if (exowner instanceof User && !(userExists = this.doCallbackUserOperation(exowner.getId()))) {
                            nonExistingEntities.add(exowner);
                        }
                        if (!(exowner instanceof Group) || (groupExists = this.doCallbackGroupOperation(exowner.getId()))) continue;
                        nonExistingEntities.add(exowner);
                    }
                    if (!nonExistingEntities.isEmpty()) {
                        excludedOwners.removeAll(nonExistingEntities);
                        nonExistingEntities.clear();
                    }
                }
                if ((recipients = assignments.getRecipients()) != null) {
                    for (OrganizationalEntity recipient : recipients) {
                        boolean groupExists;
                        boolean userExists;
                        if (recipient instanceof User && !(userExists = this.doCallbackUserOperation(recipient.getId()))) {
                            nonExistingEntities.add(recipient);
                        }
                        if (!(recipient instanceof Group) || (groupExists = this.doCallbackGroupOperation(recipient.getId()))) continue;
                        nonExistingEntities.add(recipient);
                    }
                    if (!nonExistingEntities.isEmpty()) {
                        recipients.removeAll(nonExistingEntities);
                        nonExistingEntities.clear();
                    }
                }
                if ((stakeholders = assignments.getTaskStakeholders()) != null) {
                    for (OrganizationalEntity stakeholder : stakeholders) {
                        boolean groupExists;
                        boolean userExists;
                        if (stakeholder instanceof User && !(userExists = this.doCallbackUserOperation(stakeholder.getId()))) {
                            nonExistingEntities.add(stakeholder);
                        }
                        if (!(stakeholder instanceof Group) || (groupExists = this.doCallbackGroupOperation(stakeholder.getId()))) continue;
                        nonExistingEntities.add(stakeholder);
                    }
                    if (!nonExistingEntities.isEmpty()) {
                        stakeholders.removeAll(nonExistingEntities);
                        nonExistingEntities.clear();
                    }
                }
            }
        }
    }

    private void doCallbackOperationForComment(Comment comment) {
        if (comment != null && comment.getAddedBy() != null) {
            this.doCallbackUserOperation(comment.getAddedBy().getId());
        }
    }

    private void doCallbackOperationForAttachment(Attachment attachment) {
        if (attachment != null && attachment.getAttachedBy() != null) {
            this.doCallbackUserOperation(attachment.getAttachedBy().getId());
        }
    }

    private void doCallbackOperationForTaskDeadlines(Deadlines deadlines) {
        if (deadlines != null) {
            List<OrganizationalEntity> potentialOwners;
            List<OrganizationalEntity> administrators;
            List<OrganizationalEntity> recipients;
            List<Reassignment> ressignments;
            List<Notification> notifications;
            List<Escalation> escalations;
            if (deadlines.getStartDeadlines() != null) {
                List<Deadline> startDeadlines = deadlines.getStartDeadlines();
                for (Deadline startDeadline : startDeadlines) {
                    escalations = startDeadline.getEscalations();
                    if (escalations == null) continue;
                    for (Escalation escalation : escalations) {
                        notifications = escalation.getNotifications();
                        ressignments = escalation.getReassignments();
                        if (notifications != null) {
                            for (Notification notification : notifications) {
                                recipients = notification.getRecipients();
                                if (recipients != null) {
                                    for (OrganizationalEntity recipient : recipients) {
                                        if (recipient instanceof User) {
                                            this.doCallbackUserOperation(recipient.getId());
                                        }
                                        if (!(recipient instanceof Group)) continue;
                                        this.doCallbackGroupOperation(recipient.getId());
                                    }
                                }
                                if ((administrators = notification.getBusinessAdministrators()) == null) continue;
                                for (OrganizationalEntity administrator : administrators) {
                                    if (administrator instanceof User) {
                                        this.doCallbackUserOperation(administrator.getId());
                                    }
                                    if (!(administrator instanceof Group)) continue;
                                    this.doCallbackGroupOperation(administrator.getId());
                                }
                            }
                        }
                        if (ressignments == null) continue;
                        for (Reassignment reassignment : ressignments) {
                            potentialOwners = reassignment.getPotentialOwners();
                            if (potentialOwners == null) continue;
                            for (OrganizationalEntity potentialOwner : potentialOwners) {
                                if (potentialOwner instanceof User) {
                                    this.doCallbackUserOperation(potentialOwner.getId());
                                }
                                if (!(potentialOwner instanceof Group)) continue;
                                this.doCallbackGroupOperation(potentialOwner.getId());
                            }
                        }
                    }
                }
            }
            if (deadlines.getEndDeadlines() != null) {
                List<Deadline> endDeadlines = deadlines.getEndDeadlines();
                for (Deadline endDeadline : endDeadlines) {
                    escalations = endDeadline.getEscalations();
                    if (escalations == null) continue;
                    for (Escalation escalation : escalations) {
                        notifications = escalation.getNotifications();
                        ressignments = escalation.getReassignments();
                        if (notifications != null) {
                            for (Notification notification : notifications) {
                                recipients = notification.getRecipients();
                                if (recipients != null) {
                                    for (OrganizationalEntity recipient : recipients) {
                                        if (recipient instanceof User) {
                                            this.doCallbackUserOperation(recipient.getId());
                                        }
                                        if (!(recipient instanceof Group)) continue;
                                        this.doCallbackGroupOperation(recipient.getId());
                                    }
                                }
                                if ((administrators = notification.getBusinessAdministrators()) == null) continue;
                                for (OrganizationalEntity administrator : administrators) {
                                    if (administrator instanceof User) {
                                        this.doCallbackUserOperation(administrator.getId());
                                    }
                                    if (!(administrator instanceof Group)) continue;
                                    this.doCallbackGroupOperation(administrator.getId());
                                }
                            }
                        }
                        if (ressignments == null) continue;
                        for (Reassignment reassignment : ressignments) {
                            potentialOwners = reassignment.getPotentialOwners();
                            if (potentialOwners == null) continue;
                            for (OrganizationalEntity potentialOwner : potentialOwners) {
                                if (potentialOwner instanceof User) {
                                    this.doCallbackUserOperation(potentialOwner.getId());
                                }
                                if (!(potentialOwner instanceof Group)) continue;
                                this.doCallbackGroupOperation(potentialOwner.getId());
                            }
                        }
                    }
                }
            }
        }
    }

    private void doCallbackGroupsOperation(String userId, List<String> groupIds) {
        if (UserGroupCallbackManager.getInstance().existsCallback()) {
            if (userId != null) {
                List<String> userGroups;
                UserGroupCallback callback = UserGroupCallbackManager.getInstance().getCallback();
                if (groupIds != null && groupIds.size() > 0) {
                    List<String> userGroups2 = callback.getGroupsForUser(userId, groupIds, null);
                    for (String groupId : groupIds) {
                        if (!callback.existsGroup(groupId) || userGroups2 == null || !userGroups2.contains(groupId)) continue;
                        this.addGroupFromCallbackOperation(groupId);
                    }
                } else if (!(this.userGroupsMap.containsKey(userId) && this.userGroupsMap.get(userId).booleanValue() || (userGroups = callback.getGroupsForUser(userId, null, null)) == null || userGroups.size() <= 0)) {
                    for (String group : userGroups) {
                        this.addGroupFromCallbackOperation(group);
                    }
                    this.userGroupsMap.put(userId, true);
                }
            } else if (groupIds != null) {
                for (String groupId : groupIds) {
                    this.addGroupFromCallbackOperation(groupId);
                }
            }
        } else {
            logger.debug("UserGroupCallback has not been registered.");
        }
    }

    private void addGroupFromCallbackOperation(String groupId) {
        try {
            boolean groupExists;
            boolean bl = groupExists = this.tpm.findEntity(Group.class, groupId) != null;
            if (!StringUtils.isEmpty((CharSequence)groupId) && !groupExists) {
                Group group = new Group(groupId);
                this.persistInTransaction(group);
            }
        }
        catch (Throwable t) {
            logger.debug("Trying to add group " + groupId + ", but it already exists. ");
        }
    }

    private void addUserFromCallbackOperation(String userId) {
        try {
            boolean userExists;
            boolean bl = userExists = this.tpm.findEntity(User.class, userId) != null;
            if (!StringUtils.isEmpty((CharSequence)userId) && !userExists) {
                User user = new User(userId);
                this.persistInTransaction(user);
            }
        }
        catch (Throwable t) {
            logger.debug("Unable to add user " + userId);
        }
    }

    private void clearDeadlines(final Task task) {
        if (task.getDeadlines() == null) {
            return;
        }
        try {
            this.doOperationInTransaction(new TransactedOperation(){

                @Override
                public void doOperation() {
                    Iterator<Deadline> it = null;
                    if (task.getDeadlines().getStartDeadlines() != null) {
                        it = task.getDeadlines().getStartDeadlines().iterator();
                        while (it.hasNext()) {
                            TaskServiceSession.this.tpm.deleteEntity(it.next());
                            it.remove();
                        }
                    }
                    if (task.getDeadlines().getEndDeadlines() != null) {
                        it = task.getDeadlines().getEndDeadlines().iterator();
                        while (it.hasNext()) {
                            TaskServiceSession.this.tpm.deleteEntity(it.next());
                            it.remove();
                        }
                    }
                }
            });
        }
        catch (Throwable t) {
            logger.error("Unable to clear deadlines for task " + task.getId(), t);
        }
    }

    public static interface TransactedOperation {
        public void doOperation() throws Exception;
    }
}

