/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.local;

import java.util.List;
import org.jbpm.eventmessaging.EventKey;
import org.jbpm.eventmessaging.EventResponseHandler;
import org.jbpm.eventmessaging.EventTriggerTransport;
import org.jbpm.eventmessaging.Payload;
import org.jbpm.task.Attachment;
import org.jbpm.task.Comment;
import org.jbpm.task.Content;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.TaskService;
import org.jbpm.task.event.TaskEventListener;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.service.FaultData;
import org.jbpm.task.service.Operation;
import org.jbpm.task.service.TaskServiceSession;
import org.jbpm.task.utils.ContentMarshallerHelper;
import org.kie.runtime.Environment;

public class LocalTaskService
implements TaskService {
    private org.jbpm.task.service.TaskService service;
    private Environment environment;

    public LocalTaskService(org.jbpm.task.service.TaskService taskService) {
        this.service = taskService;
    }

    @Override
    public void activate(long taskId, String userId) {
        TaskServiceSession session = this.service.createSession();
        session.taskOperation(Operation.Activate, taskId, userId, null, null, null);
        session.dispose();
    }

    @Override
    public void addAttachment(long taskId, Attachment attachment, Content content) {
        TaskServiceSession session = this.service.createSession();
        session.addAttachment(taskId, attachment, content);
        session.dispose();
    }

    @Override
    public void addComment(long taskId, Comment comment) {
        TaskServiceSession session = this.service.createSession();
        session.addComment(taskId, comment);
        session.dispose();
    }

    @Override
    public void addTask(Task task, ContentData content) {
        TaskServiceSession session = this.service.createSession();
        session.addTask(task, content);
        session.dispose();
    }

    @Override
    public void claim(long taskId, String userId) {
        TaskServiceSession session = this.service.createSession();
        session.taskOperation(Operation.Claim, taskId, userId, null, null, null);
        session.dispose();
    }

    @Override
    @Deprecated
    public void claim(long taskId, String userId, List<String> groupIds) {
        TaskServiceSession session = this.service.createSession();
        session.taskOperation(Operation.Claim, taskId, userId, null, null, groupIds);
        session.dispose();
    }

    @Override
    public void complete(long taskId, String userId, ContentData outputData) {
        TaskServiceSession session = this.service.createSession();
        session.taskOperation(Operation.Complete, taskId, userId, null, outputData, null);
        session.dispose();
    }

    @Override
    public void completeWithResults(long taskId, String userId, Object results) {
        ContentData contentData = null;
        if (results != null) {
            contentData = ContentMarshallerHelper.marshal(results, this.environment);
        }
        this.complete(taskId, userId, contentData);
    }

    @Override
    public boolean connect() {
        return true;
    }

    @Override
    public boolean connect(String address, int port) {
        return true;
    }

    @Override
    public void delegate(long taskId, String userId, String targetUserId) {
        TaskServiceSession session = this.service.createSession();
        session.taskOperation(Operation.Delegate, taskId, userId, targetUserId, null, null);
        session.dispose();
    }

    @Override
    public void deleteAttachment(long taskId, long attachmentId, long contentId) {
        TaskServiceSession session = this.service.createSession();
        session.deleteAttachment(taskId, attachmentId, contentId);
        session.dispose();
    }

    @Override
    public void deleteComment(long taskId, long commentId) {
        TaskServiceSession session = this.service.createSession();
        session.deleteComment(taskId, commentId);
        session.dispose();
    }

    @Override
    public void deleteFault(long taskId, String userId) {
        TaskServiceSession session = this.service.createSession();
        session.deleteFault(taskId, userId);
        session.dispose();
    }

    @Override
    public void deleteOutput(long taskId, String userId) {
        TaskServiceSession session = this.service.createSession();
        session.deleteOutput(taskId, userId);
        session.dispose();
    }

    @Override
    public void disconnect() throws Exception {
    }

    public void dispose() {
    }

    @Override
    public void exit(long taskId, String userId) {
        TaskServiceSession session = this.service.createSession();
        session.taskOperation(Operation.Exit, taskId, userId, null, null, null);
        session.dispose();
    }

    @Override
    public void fail(long taskId, String userId, FaultData faultData) {
        TaskServiceSession session = this.service.createSession();
        session.taskOperation(Operation.Fail, taskId, userId, null, faultData, null);
        session.dispose();
    }

    @Override
    public void forward(long taskId, String userId, String targetEntityId) {
        TaskServiceSession session = this.service.createSession();
        session.taskOperation(Operation.Forward, taskId, userId, targetEntityId, null, null);
        session.dispose();
    }

    @Override
    public Content getContent(long contentId) {
        TaskServiceSession session = this.service.createSession();
        Content content = session.getContent(contentId);
        session.dispose();
        return content;
    }

    @Override
    public List<TaskSummary> getSubTasksAssignedAsPotentialOwner(long parentId, String userId, String language) {
        TaskServiceSession session = this.service.createSession();
        List<TaskSummary> result = session.getSubTasksAssignedAsPotentialOwner(parentId, userId, language);
        session.dispose();
        return result;
    }

    @Override
    public List<TaskSummary> getSubTasksByParent(long parentId) {
        TaskServiceSession session = this.service.createSession();
        List<TaskSummary> result = session.getSubTasksByParent(parentId, null);
        session.dispose();
        return result;
    }

    @Override
    public Task getTask(long taskId) {
        TaskServiceSession session = this.service.createSession();
        Task result = session.getTask(taskId);
        this.loadLazyFields(result);
        session.dispose();
        return result;
    }

    @Override
    public Task getTaskByWorkItemId(long workItemId) {
        TaskServiceSession session = this.service.createSession();
        Task result = session.getTaskByWorkItemId(workItemId);
        this.loadLazyFields(result);
        session.dispose();
        return result;
    }

    @Override
    public List<Long> getTasksByProcessInstanceId(long processInstanceId) {
        TaskServiceSession session = this.service.createSession();
        List<Long> result = session.getTasksByProcessInstanceId(processInstanceId);
        session.dispose();
        return result;
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsBusinessAdministrator(String userId, String language) {
        TaskServiceSession session = this.service.createSession();
        List<TaskSummary> result = session.getTasksAssignedAsBusinessAdministrator(userId, language);
        session.dispose();
        return result;
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsExcludedOwner(String userId, String language) {
        TaskServiceSession session = this.service.createSession();
        List<TaskSummary> result = session.getTasksAssignedAsExcludedOwner(userId, language);
        session.dispose();
        return result;
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, String language) {
        TaskServiceSession session = this.service.createSession();
        List<TaskSummary> result = session.getTasksAssignedAsPotentialOwner(userId, language);
        session.dispose();
        return result;
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByStatus(String userId, List<Status> status, String language) {
        TaskServiceSession session = this.service.createSession();
        List<TaskSummary> result = session.getTasksAssignedAsPotentialOwnerByStatus(userId, status, language);
        session.dispose();
        return result;
    }

    @Override
    @Deprecated
    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByStatusByGroup(String userId, List<String> groupIds, List<Status> status, String language) {
        TaskServiceSession session = this.service.createSession();
        List<TaskSummary> result = session.getTasksAssignedAsPotentialOwnerByStatusByGroup(userId, groupIds, status, language);
        session.dispose();
        return result;
    }

    @Override
    @Deprecated
    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, String language) {
        TaskServiceSession session = this.service.createSession();
        List<TaskSummary> result = session.getTasksAssignedAsPotentialOwner(userId, groupIds, language);
        session.dispose();
        return result;
    }

    @Override
    @Deprecated
    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, String language, int firstResult, int maxResult) {
        TaskServiceSession session = this.service.createSession();
        List<TaskSummary> result = session.getTasksAssignedAsPotentialOwner(userId, groupIds, language, firstResult, maxResult);
        session.dispose();
        return result;
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsRecipient(String userId, String language) {
        TaskServiceSession session = this.service.createSession();
        List<TaskSummary> result = session.getTasksAssignedAsRecipient(userId, language);
        session.dispose();
        return result;
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsTaskInitiator(String userId, String language) {
        TaskServiceSession session = this.service.createSession();
        List<TaskSummary> result = session.getTasksAssignedAsTaskInitiator(userId, language);
        session.dispose();
        return result;
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsTaskStakeholder(String userId, String language) {
        TaskServiceSession session = this.service.createSession();
        List<TaskSummary> result = session.getTasksAssignedAsTaskStakeholder(userId, language);
        session.dispose();
        return result;
    }

    @Override
    public List<TaskSummary> getTasksByStatusByProcessId(long processInstanceId, List<Status> status, String language) {
        TaskServiceSession session = this.service.createSession();
        List<TaskSummary> result = session.getTasksByStatusByProcessId(processInstanceId, status, language);
        session.dispose();
        return result;
    }

    @Override
    public List<TaskSummary> getTasksByStatusByProcessIdByTaskName(long processInstanceId, List<Status> status, String taskName, String language) {
        TaskServiceSession session = this.service.createSession();
        List<TaskSummary> result = session.getTasksByStatusByProcessIdByTaskName(processInstanceId, status, taskName, language);
        session.dispose();
        return result;
    }

    @Override
    public List<TaskSummary> getTasksOwned(String userId, String language) {
        TaskServiceSession session = this.service.createSession();
        List<TaskSummary> result = session.getTasksOwned(userId, language);
        session.dispose();
        return result;
    }

    @Override
    public List<TaskSummary> getTasksOwned(String userId, List<Status> status, String language) {
        TaskServiceSession session = this.service.createSession();
        List<TaskSummary> result = session.getTasksOwned(userId, status, language);
        session.dispose();
        return result;
    }

    @Override
    public void nominate(long taskId, String userId, List<OrganizationalEntity> potentialOwners) {
        TaskServiceSession session = this.service.createSession();
        session.nominateTask(taskId, userId, potentialOwners);
        session.dispose();
    }

    @Override
    @Deprecated
    public List<?> query(String qlString, Integer size, Integer offset) {
        TaskServiceSession session = this.service.createSession();
        List<?> result = session.query(qlString, size, offset);
        session.dispose();
        return result;
    }

    @Override
    public void register(long taskId, String userId) {
        TaskServiceSession session = this.service.createSession();
        session.taskOperation(Operation.Register, taskId, userId, null, null, null);
        session.dispose();
    }

    @Override
    public void registerForEvent(EventKey key, boolean remove, EventResponseHandler responseHandler) {
        SimpleEventTransport transport = new SimpleEventTransport(responseHandler, remove);
        this.service.getEventKeys().register(key, transport);
    }

    @Override
    public void unregisterForEvent(EventKey key) {
        this.service.getEventKeys().removeKey(key);
    }

    @Override
    public void release(long taskId, String userId) {
        TaskServiceSession session = this.service.createSession();
        session.taskOperation(Operation.Release, taskId, userId, null, null, null);
        session.dispose();
    }

    @Override
    public void remove(long taskId, String userId) {
        TaskServiceSession session = this.service.createSession();
        session.taskOperation(Operation.Remove, taskId, userId, null, null, null);
        session.dispose();
    }

    @Override
    public void resume(long taskId, String userId) {
        TaskServiceSession session = this.service.createSession();
        session.taskOperation(Operation.Resume, taskId, userId, null, null, null);
        session.dispose();
    }

    @Override
    public void setDocumentContent(long taskId, Content content) {
        TaskServiceSession session = this.service.createSession();
        session.setDocumentContent(taskId, content);
        session.dispose();
    }

    @Override
    public void setFault(long taskId, String userId, FaultData fault) {
        TaskServiceSession session = this.service.createSession();
        session.setFault(taskId, userId, fault);
        session.dispose();
    }

    @Override
    public void setOutput(long taskId, String userId, ContentData outputContentData) {
        TaskServiceSession session = this.service.createSession();
        session.setOutput(taskId, userId, outputContentData);
        session.dispose();
    }

    @Override
    public void setPriority(long taskId, String userId, int priority) {
        TaskServiceSession session = this.service.createSession();
        session.setPriority(taskId, userId, priority);
        session.dispose();
    }

    @Override
    public void skip(long taskId, String userId) {
        TaskServiceSession session = this.service.createSession();
        session.taskOperation(Operation.Skip, taskId, userId, null, null, null);
        session.dispose();
    }

    @Override
    public void start(long taskId, String userId) {
        TaskServiceSession session = this.service.createSession();
        session.taskOperation(Operation.Start, taskId, userId, null, null, null);
        session.dispose();
    }

    @Override
    public void stop(long taskId, String userId) {
        TaskServiceSession session = this.service.createSession();
        session.taskOperation(Operation.Stop, taskId, userId, null, null, null);
        session.dispose();
    }

    @Override
    public void suspend(long taskId, String userId) {
        TaskServiceSession session = this.service.createSession();
        session.taskOperation(Operation.Suspend, taskId, userId, null, null, null);
        session.dispose();
    }

    @Override
    public void claimNextAvailable(String userId, String language) {
        TaskServiceSession session = this.service.createSession();
        session.claimNextAvailable(userId, language);
        session.dispose();
    }

    @Override
    @Deprecated
    public void claimNextAvailable(String userId, List<String> groupIds, String language) {
        TaskServiceSession session = this.service.createSession();
        session.claimNextAvailable(userId, groupIds, language);
        session.dispose();
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void addEventListener(TaskEventListener listener) {
        this.service.addEventListener(listener);
    }

    private void loadLazyFields(Task task) {
        task.getPeopleAssignments().getBusinessAdministrators().size();
        task.getPeopleAssignments().getPotentialOwners().size();
        task.getPeopleAssignments().getRecipients().size();
        task.getPeopleAssignments().getExcludedOwners().size();
        task.getPeopleAssignments().getTaskStakeholders().size();
        task.getDeadlines().getStartDeadlines().size();
        task.getDeadlines().getEndDeadlines().size();
        task.getDelegation().getDelegates().size();
        task.getTaskData().getAttachments().size();
        task.getTaskData().getComments().size();
        task.getDescriptions().size();
        task.getNames().size();
        task.getSubjects().size();
        task.getSubTaskStrategies().size();
    }

    private static class SimpleEventTransport
    implements EventTriggerTransport {
        private boolean remove;
        private EventResponseHandler responseHandler;

        public SimpleEventTransport(EventResponseHandler responseHandler, boolean remove) {
            this.responseHandler = responseHandler;
            this.remove = remove;
        }

        @Override
        public void trigger(Payload payload) {
            this.responseHandler.execute(payload);
        }

        @Override
        public boolean isRemove() {
            return this.remove;
        }
    }
}

