/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.builder.conf.impl.JaxbConfigurationImpl;
import org.drools.compiler.BPMN2ProcessFactory;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageRegistry;
import org.drools.io.impl.BaseResource;
import org.drools.lang.descr.CompositePackageDescr;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.TypeDeclarationDescr;
import org.kie.builder.CompositeKnowledgeBuilder;
import org.kie.io.Resource;
import org.kie.io.ResourceConfiguration;
import org.kie.io.ResourceType;

public class CompositeKnowledgeBuilderImpl
implements CompositeKnowledgeBuilder {
    private final PackageBuilder pkgBuilder;
    private final Map<ResourceType, List<ResourceDescr>> resourcesByType = new HashMap<ResourceType, List<ResourceDescr>>();
    private RuntimeException buildException = null;
    public ResourceType currentType = null;

    public CompositeKnowledgeBuilderImpl(PackageBuilder pkgBuilder) {
        this.pkgBuilder = pkgBuilder;
    }

    public CompositeKnowledgeBuilder type(ResourceType type) {
        this.currentType = type;
        return this;
    }

    public CompositeKnowledgeBuilder add(Resource resource) {
        if (this.currentType == null) {
            throw new RuntimeException("You must declare the type of the resource");
        }
        return this.add(resource, this.currentType);
    }

    public CompositeKnowledgeBuilder add(Resource resource, ResourceType type) {
        ResourceConfiguration configuration = resource instanceof BaseResource ? ((BaseResource)resource).getConfiguration() : null;
        return this.add(resource, type, configuration);
    }

    public CompositeKnowledgeBuilder add(Resource resource, ResourceType type, ResourceConfiguration configuration) {
        ResourceDescr resourceDescr = new ResourceDescr(configuration, resource);
        List<ResourceDescr> resourceDescrs = this.resourcesByType.get(type);
        if (resourceDescrs == null) {
            resourceDescrs = new ArrayList<ResourceDescr>();
            this.resourcesByType.put(type, resourceDescrs);
        }
        resourceDescrs.add(resourceDescr);
        return this;
    }

    private List<Resource> getResources() {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (List<ResourceDescr> resourceDescrs : this.resourcesByType.values()) {
            for (ResourceDescr resourceDescr : resourceDescrs) {
                resources.add(resourceDescr.resource);
            }
        }
        return resources;
    }

    public void build() {
        this.buildException = null;
        this.pkgBuilder.registerBuildResources(this.getResources());
        this.registerDSL();
        this.buildPackages();
        this.buildResources();
        this.buildOthers();
        this.resourcesByType.clear();
        if (this.buildException != null) {
            throw this.buildException;
        }
    }

    private void buildPackages() {
        Collection<CompositePackageDescr> packages = this.buildPackageDescr();
        this.buildTypeDeclarations(packages);
        this.buildRules(packages);
    }

    private void registerDSL() {
        List<ResourceDescr> resourcesByType = this.resourcesByType.remove(ResourceType.DSL);
        if (resourcesByType != null) {
            for (ResourceDescr resourceDescr : resourcesByType) {
                try {
                    this.pkgBuilder.addDsl(resourceDescr.resource);
                }
                catch (RuntimeException e) {
                    if (this.buildException != null) continue;
                    this.buildException = e;
                }
                catch (Exception e) {
                    if (this.buildException != null) continue;
                    this.buildException = new RuntimeException(e);
                }
            }
        }
    }

    private void buildResources() {
        List<ResourceDescr> resourcesByType = this.resourcesByType.remove(ResourceType.DRF);
        if (resourcesByType != null) {
            for (ResourceDescr resourceDescr : resourcesByType) {
                try {
                    this.pkgBuilder.addProcessFromXml(resourceDescr.resource);
                }
                catch (RuntimeException e) {
                    if (this.buildException != null) continue;
                    this.buildException = e;
                }
                catch (Exception e) {
                    if (this.buildException != null) continue;
                    this.buildException = new RuntimeException(e);
                }
            }
        }
        if ((resourcesByType = this.resourcesByType.remove(ResourceType.BPMN2)) != null) {
            for (ResourceDescr resourceDescr : resourcesByType) {
                try {
                    BPMN2ProcessFactory.configurePackageBuilder(this.pkgBuilder);
                    this.pkgBuilder.addProcessFromXml(resourceDescr.resource);
                }
                catch (RuntimeException e) {
                    if (this.buildException != null) continue;
                    this.buildException = e;
                }
                catch (Exception e) {
                    if (this.buildException != null) continue;
                    this.buildException = new RuntimeException(e);
                }
            }
        }
        if ((resourcesByType = this.resourcesByType.remove(ResourceType.PKG)) != null) {
            for (ResourceDescr resourceDescr : resourcesByType) {
                try {
                    this.pkgBuilder.addPackageFromInputStream(resourceDescr.resource);
                }
                catch (RuntimeException e) {
                    if (this.buildException != null) continue;
                    this.buildException = e;
                }
                catch (Exception e) {
                    if (this.buildException != null) continue;
                    this.buildException = new RuntimeException(e);
                }
            }
        }
        if ((resourcesByType = this.resourcesByType.remove(ResourceType.CHANGE_SET)) != null) {
            for (ResourceDescr resourceDescr : resourcesByType) {
                try {
                    this.pkgBuilder.addPackageFromChangeSet(resourceDescr.resource);
                }
                catch (RuntimeException e) {
                    if (this.buildException != null) continue;
                    this.buildException = e;
                }
                catch (Exception e) {
                    if (this.buildException != null) continue;
                    this.buildException = new RuntimeException(e);
                }
            }
        }
        if ((resourcesByType = this.resourcesByType.remove(ResourceType.XSD)) != null) {
            for (ResourceDescr resourceDescr : resourcesByType) {
                try {
                    this.pkgBuilder.addPackageFromXSD(resourceDescr.resource, (JaxbConfigurationImpl)resourceDescr.configuration);
                }
                catch (RuntimeException e) {
                    if (this.buildException != null) continue;
                    this.buildException = e;
                }
                catch (Exception e) {
                    if (this.buildException != null) continue;
                    this.buildException = new RuntimeException(e);
                }
            }
        }
        if ((resourcesByType = this.resourcesByType.remove(ResourceType.PMML)) != null) {
            for (ResourceDescr resourceDescr : resourcesByType) {
                try {
                    this.pkgBuilder.addPackageFromPMML(resourceDescr.resource, ResourceType.PMML, resourceDescr.configuration);
                }
                catch (RuntimeException e) {
                    if (this.buildException != null) continue;
                    this.buildException = e;
                }
                catch (Exception e) {
                    if (this.buildException != null) continue;
                    this.buildException = new RuntimeException(e);
                }
            }
        }
    }

    private void buildOthers() {
        try {
            for (Map.Entry<ResourceType, List<ResourceDescr>> entry : this.resourcesByType.entrySet()) {
                for (ResourceDescr resourceDescr : entry.getValue()) {
                    this.pkgBuilder.addPackageForExternalType(resourceDescr.resource, entry.getKey(), resourceDescr.configuration);
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void buildRules(Collection<CompositePackageDescr> packages) {
        for (CompositePackageDescr packageDescr : packages) {
            PackageRegistry pkgRegistry = this.pkgBuilder.getPackageRegistry(packageDescr.getNamespace());
            this.pkgBuilder.processOtherDeclarations(pkgRegistry, packageDescr);
            this.pkgBuilder.compileAllRules(packageDescr, pkgRegistry);
        }
    }

    private void buildTypeDeclarations(Collection<CompositePackageDescr> packages) {
        for (CompositePackageDescr packageDescr : packages) {
            for (TypeDeclarationDescr typeDeclarationDescr : packageDescr.getTypeDeclarations()) {
                if (this.pkgBuilder.isEmpty(typeDeclarationDescr.getNamespace())) {
                    typeDeclarationDescr.setNamespace(packageDescr.getNamespace());
                }
                this.pkgBuilder.registerGeneratedType(typeDeclarationDescr);
            }
        }
        HashMap<String, List<PackageBuilder.TypeDefinition>> unresolvedTypes = new HashMap<String, List<PackageBuilder.TypeDefinition>>();
        for (CompositePackageDescr compositePackageDescr : packages) {
            List<PackageBuilder.TypeDefinition> unresolvedTypesForPkg = this.buildTypeDeclarations(compositePackageDescr);
            if (unresolvedTypesForPkg == null) continue;
            unresolvedTypes.put(compositePackageDescr.getNamespace(), unresolvedTypesForPkg);
        }
        for (Map.Entry entry : unresolvedTypes.entrySet()) {
            this.pkgBuilder.processUnresolvedTypes(this.pkgBuilder.getPackageRegistry((String)entry.getKey()), (List)entry.getValue());
        }
        for (CompositePackageDescr compositePackageDescr : packages) {
            for (ImportDescr importDescr : compositePackageDescr.getImports()) {
                this.pkgBuilder.getPackageRegistry(compositePackageDescr.getNamespace()).addImport(importDescr);
            }
        }
    }

    private List<PackageBuilder.TypeDefinition> buildTypeDeclarations(PackageDescr packageDescr) {
        PackageRegistry pkgRegistry = this.pkgBuilder.initPackageRegistry(packageDescr);
        if (pkgRegistry == null) {
            return null;
        }
        this.pkgBuilder.processEntryPointDeclarations(pkgRegistry, packageDescr);
        return this.pkgBuilder.processTypeDeclarations(pkgRegistry, packageDescr);
    }

    private Collection<CompositePackageDescr> buildPackageDescr() {
        HashMap<String, CompositePackageDescr> packages = new HashMap<String, CompositePackageDescr>();
        List<ResourceDescr> resourcesByType = this.resourcesByType.remove(ResourceType.DRL);
        if (resourcesByType != null) {
            for (ResourceDescr resourceDescr : resourcesByType) {
                try {
                    this.registerPackageDescr(packages, resourceDescr.resource, this.pkgBuilder.drlToPackageDescr(resourceDescr.resource));
                }
                catch (RuntimeException e) {
                    if (this.buildException != null) continue;
                    this.buildException = e;
                }
                catch (Exception e) {
                    if (this.buildException != null) continue;
                    this.buildException = new RuntimeException(e);
                }
            }
        }
        if ((resourcesByType = this.resourcesByType.remove(ResourceType.DESCR)) != null) {
            for (ResourceDescr resourceDescr : resourcesByType) {
                try {
                    this.registerPackageDescr(packages, resourceDescr.resource, this.pkgBuilder.drlToPackageDescr(resourceDescr.resource));
                }
                catch (RuntimeException e) {
                    if (this.buildException != null) continue;
                    this.buildException = e;
                }
                catch (Exception e) {
                    if (this.buildException != null) continue;
                    this.buildException = new RuntimeException(e);
                }
            }
        }
        if ((resourcesByType = this.resourcesByType.remove(ResourceType.DSLR)) != null) {
            for (ResourceDescr resourceDescr : resourcesByType) {
                try {
                    this.registerPackageDescr(packages, resourceDescr.resource, this.pkgBuilder.dslrToPackageDescr(resourceDescr.resource));
                }
                catch (RuntimeException e) {
                    if (this.buildException != null) continue;
                    this.buildException = e;
                }
                catch (Exception e) {
                    if (this.buildException != null) continue;
                    this.buildException = new RuntimeException(e);
                }
            }
        }
        if ((resourcesByType = this.resourcesByType.remove(ResourceType.XDRL)) != null) {
            for (ResourceDescr resourceDescr : resourcesByType) {
                try {
                    this.registerPackageDescr(packages, resourceDescr.resource, this.pkgBuilder.xmlToPackageDescr(resourceDescr.resource));
                }
                catch (RuntimeException e) {
                    if (this.buildException != null) continue;
                    this.buildException = e;
                }
                catch (Exception e) {
                    if (this.buildException != null) continue;
                    this.buildException = new RuntimeException(e);
                }
            }
        }
        if ((resourcesByType = this.resourcesByType.remove(ResourceType.BRL)) != null) {
            for (ResourceDescr resourceDescr : resourcesByType) {
                try {
                    this.registerPackageDescr(packages, resourceDescr.resource, this.pkgBuilder.brlToPackageDescr(resourceDescr.resource));
                }
                catch (RuntimeException e) {
                    if (this.buildException != null) continue;
                    this.buildException = e;
                }
                catch (Exception e) {
                    if (this.buildException != null) continue;
                    this.buildException = new RuntimeException(e);
                }
            }
        }
        if ((resourcesByType = this.resourcesByType.remove(ResourceType.DTABLE)) != null) {
            for (ResourceDescr resourceDescr : resourcesByType) {
                try {
                    this.registerPackageDescr(packages, resourceDescr.resource, this.pkgBuilder.decisionTableToPackageDescr(resourceDescr.resource, resourceDescr.configuration));
                }
                catch (RuntimeException e) {
                    if (this.buildException != null) continue;
                    this.buildException = e;
                }
                catch (Exception e) {
                    if (this.buildException != null) continue;
                    this.buildException = new RuntimeException(e);
                }
            }
        }
        return packages.values();
    }

    private void registerPackageDescr(Map<String, CompositePackageDescr> packages, Resource resource, PackageDescr packageDescr) {
        if (packageDescr != null) {
            CompositePackageDescr compositePackageDescr = packages.get(packageDescr.getNamespace());
            if (compositePackageDescr == null) {
                packages.put(packageDescr.getNamespace(), new CompositePackageDescr(resource, packageDescr));
            } else {
                compositePackageDescr.addPackageDescr(resource, packageDescr);
            }
        }
    }

    private static class ResourceDescr {
        final Resource resource;
        final ResourceConfiguration configuration;

        private ResourceDescr(ResourceConfiguration configuration, Resource resource) {
            this.configuration = configuration;
            this.resource = resource;
        }
    }
}

