/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.compiler;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.FactoryConfigurationError;
import org.drools.RuntimeDroolsException;
import org.drools.compiler.Dialect;
import org.drools.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.DroolsError;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.compiler.PackageRegistry;
import org.drools.compiler.ParserError;
import org.drools.compiler.ProcessBuilder;
import org.drools.compiler.ProcessLoadError;
import org.drools.lang.descr.ActionDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.ProcessDescr;
import org.drools.rule.Package;
import org.drools.xml.SemanticModule;
import org.jbpm.compiler.xml.ProcessSemanticModule;
import org.jbpm.compiler.xml.XmlProcessReader;
import org.jbpm.compiler.xml.processes.RuleFlowMigrator;
import org.jbpm.process.builder.ProcessBuildContext;
import org.jbpm.process.builder.ProcessNodeBuilder;
import org.jbpm.process.builder.ProcessNodeBuilderRegistry;
import org.jbpm.process.builder.dialect.ProcessDialect;
import org.jbpm.process.builder.dialect.ProcessDialectRegistry;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.context.exception.ActionExceptionHandler;
import org.jbpm.process.core.context.exception.ExceptionHandler;
import org.jbpm.process.core.context.exception.ExceptionScope;
import org.jbpm.process.core.impl.ProcessImpl;
import org.jbpm.process.core.validation.ProcessValidationError;
import org.jbpm.process.core.validation.ProcessValidator;
import org.jbpm.ruleflow.core.validation.RuleFlowProcessValidator;
import org.jbpm.workflow.core.Constraint;
import org.jbpm.workflow.core.impl.ConnectionRef;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.impl.ExtendedNodeImpl;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.core.impl.WorkflowProcessImpl;
import org.jbpm.workflow.core.node.CompositeNode;
import org.jbpm.workflow.core.node.ConstraintTrigger;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.EventSubProcessNode;
import org.jbpm.workflow.core.node.MilestoneNode;
import org.jbpm.workflow.core.node.Split;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.StateNode;
import org.jbpm.workflow.core.node.Trigger;
import org.kie.definition.process.Connection;
import org.kie.definition.process.Node;
import org.kie.definition.process.NodeContainer;
import org.kie.definition.process.Process;
import org.kie.definition.process.WorkflowProcess;
import org.kie.io.Resource;

public class ProcessBuilderImpl
implements ProcessBuilder {
    private PackageBuilder packageBuilder;
    private final List<DroolsError> errors = new ArrayList<DroolsError>();
    private Map<String, ProcessValidator> processValidators = new HashMap<String, ProcessValidator>();

    public ProcessBuilderImpl(PackageBuilder packageBuilder) {
        this.packageBuilder = packageBuilder;
        this.configurePackageBuilder(packageBuilder);
        this.processValidators.put("RuleFlow", RuleFlowProcessValidator.getInstance());
    }

    public void configurePackageBuilder(PackageBuilder packageBuilder) {
        PackageBuilderConfiguration conf = packageBuilder.getPackageBuilderConfiguration();
        if (conf.getSemanticModules().getSemanticModule("http://drools.org/drools-5.0/process") == null) {
            conf.addSemanticModule((SemanticModule)new ProcessSemanticModule());
        }
    }

    public List<DroolsError> getErrors() {
        return this.errors;
    }

    public void buildProcess(Process process, Resource resource) {
        boolean hasErrors = false;
        ProcessValidator validator = this.processValidators.get(process.getType());
        if (validator == null) {
            System.out.println("Could not find validator for process " + process.getType() + ".");
            System.out.println("Continuing without validation of the process " + process.getName() + "[" + process.getId() + "]");
        } else {
            ProcessValidationError[] errors = validator.validateProcess((Process)((WorkflowProcess)process));
            if (errors.length != 0) {
                hasErrors = true;
                for (int i = 0; i < errors.length; ++i) {
                    this.errors.add((DroolsError)new ParserError(errors[i].toString(), -1, -1));
                }
            }
        }
        if (!hasErrors) {
            String rules = this.generateRules(process);
            try {
                this.packageBuilder.addPackageFromDrl((Reader)new StringReader(rules), resource);
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
            catch (DroolsParserException e) {
                e.printStackTrace(System.err);
            }
            PackageRegistry pkgRegistry = this.packageBuilder.getPackageRegistry(process.getPackageName());
            if (pkgRegistry != null) {
                Package p = pkgRegistry.getPackage();
                if (p != null) {
                    ProcessDescr processDescr = new ProcessDescr();
                    processDescr.setName(process.getPackageName() + "." + process.getName());
                    processDescr.setResource(resource);
                    DialectCompiletimeRegistry dialectRegistry = pkgRegistry.getDialectCompiletimeRegistry();
                    Dialect dialect = dialectRegistry.getDialect("java");
                    dialect.init(processDescr);
                    ProcessBuildContext buildContext = new ProcessBuildContext(this.packageBuilder, p, process, (BaseDescr)processDescr, dialectRegistry, dialect);
                    this.buildContexts((ContextContainer)process, buildContext);
                    if (process instanceof WorkflowProcess) {
                        this.buildNodes((WorkflowProcess)process, buildContext);
                    }
                    p.addProcess(process);
                    pkgRegistry.compileAll();
                    pkgRegistry.getDialectRuntimeRegistry().onBeforeExecute();
                }
            } else {
                throw new RuntimeDroolsException("invalid package name");
            }
        }
    }

    public void buildContexts(ContextContainer contextContainer, ProcessBuildContext buildContext) {
        List<Context> exceptionScopes = contextContainer.getContexts("ExceptionScope");
        if (exceptionScopes != null) {
            for (Context context : exceptionScopes) {
                ExceptionScope exceptionScope = (ExceptionScope)context;
                for (ExceptionHandler exceptionHandler : exceptionScope.getExceptionHandlers().values()) {
                    if (!(exceptionHandler instanceof ActionExceptionHandler)) continue;
                    DroolsConsequenceAction action = (DroolsConsequenceAction)((ActionExceptionHandler)exceptionHandler).getAction();
                    ActionDescr actionDescr = new ActionDescr();
                    actionDescr.setText(action.getConsequence());
                    ProcessDialect dialect = ProcessDialectRegistry.getDialect(action.getDialect());
                    dialect.getActionBuilder().build(buildContext, action, actionDescr, (ProcessImpl)buildContext.getProcess());
                }
            }
        }
    }

    public void buildNodes(WorkflowProcess process, ProcessBuildContext context) {
        this.processNodes(process.getNodes(), (Process)process, context.getProcessDescr(), context);
        if (!context.getErrors().isEmpty()) {
            this.errors.addAll(context.getErrors());
        }
        ProcessDialectRegistry.getDialect("java").addProcess(context);
    }

    private void processNodes(Node[] nodes, Process process, ProcessDescr processDescr, ProcessBuildContext context) {
        for (Node node : nodes) {
            ProcessNodeBuilder builder = ProcessNodeBuilderRegistry.INSTANCE.getNodeBuilder(node);
            if (builder != null) {
                builder.build(process, processDescr, context, node);
            }
            if (node instanceof NodeContainer) {
                this.processNodes(((NodeContainer)node).getNodes(), process, processDescr, context);
            }
            if (node instanceof ContextContainer) {
                this.buildContexts((ContextContainer)node, context);
            }
            if (System.getProperty("jbpm.enable.multi.con") == null || (builder = ProcessNodeBuilderRegistry.INSTANCE.getNodeBuilder(NodeImpl.class)) == null) continue;
            builder.build(process, processDescr, context, node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DroolsError> addProcessFromXml(Resource resource) throws IOException {
        Reader reader = resource.getReader();
        PackageBuilderConfiguration configuration = this.packageBuilder.getPackageBuilderConfiguration();
        XmlProcessReader xmlReader = new XmlProcessReader(configuration.getSemanticModules(), (ClassLoader)this.packageBuilder.getRootClassLoader());
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader newLoader = this.getClass().getClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(newLoader);
            String portRuleFlow = System.getProperty("drools.ruleflow.port", "false");
            Reader portedReader = null;
            portedReader = portRuleFlow.equalsIgnoreCase("true") ? this.portToCurrentVersion(reader) : reader;
            List<Process> processes = xmlReader.read(portedReader);
            if (processes != null) {
                for (Process process : processes) {
                    this.buildProcess(process, resource);
                }
            } else {
                this.errors.add((DroolsError)new ProcessLoadError(resource, "unable to parse xml", null));
            }
        }
        catch (FactoryConfigurationError e1) {
            this.errors.add((DroolsError)new ProcessLoadError(resource, "FactoryConfigurationError ", e1.getException()));
        }
        catch (Exception e2) {
            e2.printStackTrace();
            this.errors.add((DroolsError)new ProcessLoadError(resource, "unable to parse xml", e2));
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
        reader.close();
        return this.errors;
    }

    private Reader portToCurrentVersion(Reader reader) throws Exception {
        String xml = RuleFlowMigrator.convertReaderToString(reader);
        if (RuleFlowMigrator.needToMigrateRFM(xml)) {
            xml = RuleFlowMigrator.portRFMToCurrentVersion(xml);
        } else if (RuleFlowMigrator.needToMigrateRF(xml)) {
            xml = RuleFlowMigrator.portRFMToCurrentVersion(xml);
        }
        return new StringReader(xml);
    }

    private String generateRules(Process process) {
        StringBuffer builder = new StringBuffer();
        if (process instanceof WorkflowProcessImpl) {
            Map<String, String> globals;
            List<String> functionImports;
            WorkflowProcessImpl ruleFlow = (WorkflowProcessImpl)process;
            builder.append("package " + ruleFlow.getPackageName() + "\n");
            List<String> imports = ruleFlow.getImports();
            if (imports != null) {
                for (String importString : imports) {
                    builder.append("import " + importString + ";\n");
                }
            }
            if ((functionImports = ruleFlow.getFunctionImports()) != null) {
                for (String importString : functionImports) {
                    builder.append("import function " + importString + ";\n");
                }
            }
            if ((globals = ruleFlow.getGlobals()) != null) {
                for (Map.Entry<String, String> entry : globals.entrySet()) {
                    builder.append("global " + entry.getValue() + " " + entry.getKey() + ";\n");
                }
            }
            Node[] nodes = ruleFlow.getNodes();
            this.generateRules(nodes, process, builder);
        }
        return builder.toString();
    }

    private void generateRules(Node[] nodes, Process process, StringBuffer builder) {
        for (int i = 0; i < nodes.length; ++i) {
            ExtendedNodeImpl state;
            if (nodes[i] instanceof Split) {
                Split split = (Split)nodes[i];
                if (split.getType() != 2 && split.getType() != 3) continue;
                for (Connection connection : split.getDefaultOutgoingConnections()) {
                    Constraint constraint = split.getConstraint(connection);
                    if (!"rule".equals(constraint.getType())) continue;
                    builder.append(this.createSplitRule(process, connection, split.getConstraint(connection).getConstraint()));
                }
                continue;
            }
            if (nodes[i] instanceof MilestoneNode) {
                MilestoneNode milestone = (MilestoneNode)nodes[i];
                builder.append(this.createMilestoneRule(process, milestone));
                continue;
            }
            if (nodes[i] instanceof StateNode) {
                state = (StateNode)nodes[i];
                builder.append(this.createStateRules(process, (StateNode)state));
                continue;
            }
            if (nodes[i] instanceof StartNode) {
                StartNode startNode = (StartNode)nodes[i];
                List<Trigger> triggers = startNode.getTriggers();
                if (triggers == null) continue;
                for (Trigger trigger : triggers) {
                    if (!(trigger instanceof ConstraintTrigger)) continue;
                    builder.append(this.createStartConstraintRule(process, startNode.getNodeContainer(), (ConstraintTrigger)trigger));
                }
                continue;
            }
            if (nodes[i] instanceof NodeContainer) {
                this.generateRules(((NodeContainer)nodes[i]).getNodes(), process, builder);
                continue;
            }
            if (!(nodes[i] instanceof EventNode)) continue;
            state = (EventNode)nodes[i];
            builder.append(this.createEventStateRule(process, (EventNode)state));
        }
    }

    private String createSplitRule(Process process, Connection connection, String constraint) {
        return "rule \"RuleFlow-Split-" + process.getId() + "-" + ((org.jbpm.workflow.core.Node)connection.getFrom()).getUniqueId() + "-" + ((org.jbpm.workflow.core.Node)connection.getTo()).getUniqueId() + "-" + connection.getToType() + "\" \n" + "      ruleflow-group \"DROOLS_SYSTEM\" \n" + "    when \n" + "      " + constraint + "\n" + "    then \n" + "end \n\n";
    }

    private String createMilestoneRule(Process process, MilestoneNode milestone) {
        return "rule \"RuleFlow-Milestone-" + process.getId() + "-" + milestone.getUniqueId() + "\" \n" + "      ruleflow-group \"DROOLS_SYSTEM\" \n" + "    when \n" + "      " + milestone.getConstraint() + "\n" + "    then \n" + "end \n\n";
    }

    private String createStateRule(Process process, StateNode state, ConnectionRef key, Constraint constraint) {
        if (constraint.getConstraint() == null || constraint.getConstraint().trim().length() == 0) {
            return "";
        }
        return "rule \"RuleFlowStateNode-" + process.getId() + "-" + state.getUniqueId() + "-" + key.getNodeId() + "-" + key.getToType() + "\" \n" + "      ruleflow-group \"DROOLS_SYSTEM\" \n" + "    when \n" + "      " + state.getConstraints().get(key).getConstraint() + "\n" + "    then \n" + "end \n\n";
    }

    private String createEventStateRule(Process process, EventNode event) {
        String condition = (String)event.getMetaData("Condition");
        String attachedTo = (String)event.getMetaData("AttachedTo");
        if (condition == null || condition.trim().length() == 0) {
            return "";
        }
        return "rule \"RuleFlowStateEvent-" + process.getId() + "-" + event.getUniqueId() + "-" + attachedTo + "\" \n" + "      ruleflow-group \"DROOLS_SYSTEM\" \n" + "    when \n" + "      " + condition + "\n" + "    then \n" + "end \n\n";
    }

    private String createEventSubprocessStateRule(Process process, CompositeNode compositeNode, ConstraintTrigger trigger) {
        String condition = trigger.getConstraint();
        if (condition == null || condition.trim().length() == 0) {
            return "";
        }
        return "rule \"RuleFlowStateEventSubProcess-" + process.getId() + "-" + compositeNode.getUniqueId() + "\" \n" + "      ruleflow-group \"DROOLS_SYSTEM\" \n" + "    when \n" + "      " + condition + "\n" + "    then \n" + "end \n\n";
    }

    private String createStateRules(Process process, StateNode state) {
        String result = "";
        for (Map.Entry<ConnectionRef, Constraint> entry : state.getConstraints().entrySet()) {
            result = result + this.createStateRule(process, state, entry.getKey(), entry.getValue());
        }
        return result;
    }

    private String createStartConstraintRule(Process process, NodeContainer nodeContainer, ConstraintTrigger trigger) {
        if (nodeContainer instanceof EventSubProcessNode) {
            return this.createEventSubprocessStateRule(process, (EventSubProcessNode)nodeContainer, trigger);
        }
        String result = "rule \"RuleFlow-Start-" + process.getId() + "\" \n" + (trigger.getHeader() == null ? "" : "        " + trigger.getHeader() + " \n") + "    when\n" + "        " + trigger.getConstraint() + "\n" + "    then\n";
        Map<String, String> inMappings = trigger.getInMappings();
        if (inMappings != null && !inMappings.isEmpty()) {
            result = result + "        java.util.Map params = new java.util.HashMap();\n";
            for (Map.Entry<String, String> entry : inMappings.entrySet()) {
                result = result + "        params.put(\"" + entry.getKey() + "\", " + entry.getValue() + ");\n";
            }
            result = result + "        kcontext.getKnowledgeRuntime().startProcess(\"" + process.getId() + "\", params);\n" + "end\n\n";
        } else {
            result = result + "        kcontext.getKnowledgeRuntime().startProcess(\"" + process.getId() + "\");\n" + "end\n\n";
        }
        return result;
    }
}

