/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.compiler.xml.processes;

import org.drools.xml.ExtensibleXmlParser;
import org.jbpm.compiler.xml.processes.AbstractNodeHandler;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.ActionNode;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ActionNodeHandler
extends AbstractNodeHandler {
    @Override
    protected Node createNode() {
        return new ActionNode();
    }

    @Override
    public void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        ActionNode actionNode = (ActionNode)node;
        org.w3c.dom.Node xmlNode = element.getFirstChild();
        if (xmlNode instanceof Element) {
            Element actionXml = (Element)xmlNode;
            DroolsAction action = ActionNodeHandler.extractAction(actionXml);
            actionNode.setAction(action);
        }
    }

    public Class generateNodeFor() {
        return ActionNode.class;
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, boolean includeMeta) {
        ActionNode actionNode = (ActionNode)node;
        this.writeNode("actionNode", actionNode, xmlDump, includeMeta);
        DroolsConsequenceAction action = (DroolsConsequenceAction)actionNode.getAction();
        if (action != null || includeMeta && this.containsMetaData(actionNode)) {
            xmlDump.append(">" + EOL);
            if (action != null) {
                ActionNodeHandler.writeAction(action, xmlDump);
            }
            if (includeMeta) {
                this.writeMetaData(actionNode, xmlDump);
            }
            this.endNode("actionNode", xmlDump);
        } else {
            this.endNode(xmlDump);
        }
    }
}

