/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.compiler.xml.processes;

import org.drools.xml.ExtensibleXmlParser;
import org.jbpm.compiler.xml.processes.AbstractNodeHandler;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.EndNode;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class EndNodeHandler
extends AbstractNodeHandler {
    @Override
    protected Node createNode() {
        return new EndNode();
    }

    @Override
    public void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        EndNode endNode = (EndNode)node;
        String terminate = element.getAttribute("terminate");
        if (terminate != null && "false".equals(terminate)) {
            endNode.setTerminate(false);
        }
    }

    public Class generateNodeFor() {
        return EndNode.class;
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, boolean includeMeta) {
        EndNode endNode = (EndNode)node;
        this.writeNode("end", endNode, xmlDump, includeMeta);
        boolean terminate = endNode.isTerminate();
        if (!terminate) {
            xmlDump.append("terminate=\"false\" ");
        }
        if (includeMeta && this.containsMetaData(endNode)) {
            xmlDump.append(">" + EOL);
            this.writeMetaData(endNode, xmlDump);
            this.endNode("end", xmlDump);
        } else {
            this.endNode(xmlDump);
        }
    }
}

