/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.compiler.xml.processes;

import org.drools.compiler.xml.XmlDumper;
import org.drools.xml.ExtensibleXmlParser;
import org.jbpm.compiler.xml.processes.AbstractNodeHandler;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.MilestoneNode;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class MilestoneNodeHandler
extends AbstractNodeHandler {
    @Override
    protected Node createNode() {
        return new MilestoneNode();
    }

    public Class generateNodeFor() {
        return MilestoneNode.class;
    }

    @Override
    public void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        MilestoneNode milestoneNode = (MilestoneNode)node;
        for (String eventType : milestoneNode.getActionTypes()) {
            this.handleAction(milestoneNode, element, eventType);
        }
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, boolean includeMeta) {
        MilestoneNode milestoneNode = (MilestoneNode)node;
        this.writeNode("milestone", milestoneNode, xmlDump, includeMeta);
        String constraint = milestoneNode.getConstraint();
        if (constraint != null || milestoneNode.getTimers() != null || milestoneNode.containsActions()) {
            xmlDump.append(">\n");
            if (includeMeta) {
                this.writeMetaData(milestoneNode, xmlDump);
            }
            if (constraint != null) {
                xmlDump.append("      <constraint type=\"rule\" dialect=\"mvel\" >" + XmlDumper.replaceIllegalChars((String)constraint.trim()) + "</constraint>" + EOL);
            }
            for (String eventType : milestoneNode.getActionTypes()) {
                this.writeActions(eventType, milestoneNode.getActions(eventType), xmlDump);
            }
            this.writeTimers(milestoneNode.getTimers(), xmlDump);
            this.endNode("milestone", xmlDump);
        } else {
            this.endNode(xmlDump);
        }
    }
}

