/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.builder;

import java.util.HashMap;
import java.util.Map;
import org.drools.compiler.ReturnValueDescr;
import org.drools.lang.descr.ProcessDescr;
import org.jbpm.process.builder.ProcessBuildContext;
import org.jbpm.process.builder.ProcessNodeBuilder;
import org.jbpm.process.builder.dialect.ProcessDialect;
import org.jbpm.process.builder.dialect.ProcessDialectRegistry;
import org.jbpm.process.instance.impl.ReturnValueConstraintEvaluator;
import org.jbpm.process.instance.impl.RuleConstraintEvaluator;
import org.jbpm.workflow.core.Constraint;
import org.jbpm.workflow.core.impl.ConnectionRef;
import org.jbpm.workflow.core.impl.ConstraintImpl;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.core.node.Split;
import org.kie.definition.process.Connection;
import org.kie.definition.process.Node;
import org.kie.definition.process.Process;

public class MultiConditionalSequenceFlowNodeBuilder
implements ProcessNodeBuilder {
    @Override
    public void build(Process process, ProcessDescr processDescr, ProcessBuildContext context, Node node) {
        Map<ConnectionRef, Constraint> constraints = ((NodeImpl)node).getConstraints();
        if (node instanceof Split || constraints.size() == 0) {
            return;
        }
        HashMap<ConnectionRef, Constraint> map = new HashMap<ConnectionRef, Constraint>(constraints);
        for (Map.Entry entry : map.entrySet()) {
            ConnectionRef connection = (ConnectionRef)entry.getKey();
            ConstraintImpl constraint = (ConstraintImpl)entry.getValue();
            Connection outgoingConnection = null;
            for (Connection out : ((NodeImpl)node).getDefaultOutgoingConnections()) {
                if (!out.getToType().equals(connection.getToType()) || out.getTo().getId() != connection.getNodeId()) continue;
                outgoingConnection = out;
            }
            if (outgoingConnection == null) {
                throw new IllegalArgumentException("Could not find outgoing connection");
            }
            if ("rule".equals(constraint.getType())) {
                RuleConstraintEvaluator ruleConstraint = new RuleConstraintEvaluator();
                ruleConstraint.setDialect(constraint.getDialect());
                ruleConstraint.setName(constraint.getName());
                ruleConstraint.setPriority(constraint.getPriority());
                ruleConstraint.setDefault(constraint.isDefault());
                ((NodeImpl)node).setConstraint(outgoingConnection, ruleConstraint);
                continue;
            }
            if (!"code".equals(constraint.getType())) continue;
            ReturnValueConstraintEvaluator returnValueConstraint = new ReturnValueConstraintEvaluator();
            returnValueConstraint.setDialect(constraint.getDialect());
            returnValueConstraint.setName(constraint.getName());
            returnValueConstraint.setPriority(constraint.getPriority());
            returnValueConstraint.setDefault(constraint.isDefault());
            ((NodeImpl)node).setConstraint(outgoingConnection, returnValueConstraint);
            ReturnValueDescr returnValueDescr = new ReturnValueDescr();
            returnValueDescr.setText(constraint.getConstraint());
            ProcessDialect dialect = ProcessDialectRegistry.getDialect(constraint.getDialect());
            dialect.getReturnValueEvaluatorBuilder().build(context, returnValueConstraint, returnValueDescr, (NodeImpl)node);
        }
    }
}

