/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import org.drools.WorkingMemory;
import org.drools.audit.WorkingMemoryLogger;
import org.drools.audit.event.LogEvent;
import org.drools.impl.StatelessKnowledgeSessionImpl;
import org.jbpm.process.audit.event.ExtendedRuleFlowLogEvent;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.kie.event.KnowledgeRuntimeEventManager;
import org.kie.event.process.ProcessCompletedEvent;
import org.kie.event.process.ProcessStartedEvent;
import org.kie.runtime.Environment;
import org.kie.runtime.KnowledgeRuntime;

public abstract class AbstractAuditLogger
extends WorkingMemoryLogger {
    protected Environment env;

    public AbstractAuditLogger(WorkingMemory workingMemory) {
        super(workingMemory);
        this.env = workingMemory.getEnvironment();
    }

    public AbstractAuditLogger(KnowledgeRuntimeEventManager session) {
        super(session);
        if (session instanceof KnowledgeRuntime) {
            this.env = ((KnowledgeRuntime)session).getEnvironment();
        } else if (session instanceof StatelessKnowledgeSessionImpl) {
            this.env = ((StatelessKnowledgeSessionImpl)session).getEnvironment();
        } else {
            throw new IllegalArgumentException("Not supported session in logger: " + session.getClass());
        }
    }

    public void beforeProcessStarted(ProcessStartedEvent event) {
        long parentProcessInstanceId = -1L;
        try {
            ProcessInstanceImpl processInstance = (ProcessInstanceImpl)event.getProcessInstance();
            parentProcessInstanceId = (Long)processInstance.getMetaData().get("ParentProcessInstanceId");
        }
        catch (Exception e) {
            // empty catch block
        }
        ExtendedRuleFlowLogEvent logEvent = new ExtendedRuleFlowLogEvent(8, event.getProcessInstance().getProcessId(), event.getProcessInstance().getProcessName(), event.getProcessInstance().getId(), parentProcessInstanceId);
        this.logEventCreated((LogEvent)logEvent);
    }

    public void afterProcessCompleted(ProcessCompletedEvent event) {
        String outcome = null;
        try {
            ProcessInstanceImpl processInstance = (ProcessInstanceImpl)event.getProcessInstance();
            outcome = processInstance.getOutcome();
        }
        catch (Exception e) {
            // empty catch block
        }
        ExtendedRuleFlowLogEvent logEvent = new ExtendedRuleFlowLogEvent(11, event.getProcessInstance().getProcessId(), event.getProcessInstance().getProcessName(), event.getProcessInstance().getId(), event.getProcessInstance().getState(), outcome);
        this.logEventCreated((LogEvent)logEvent);
    }
}

