/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit.jms;

import com.thoughtworks.xstream.XStream;
import java.util.Arrays;
import java.util.List;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.drools.WorkingMemory;
import org.drools.audit.event.LogEvent;
import org.jbpm.process.audit.AbstractAuditLogger;
import org.kie.event.KnowledgeRuntimeEventManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncAuditLogProducer
extends AbstractAuditLogger {
    private static Logger logger = LoggerFactory.getLogger(AsyncAuditLogProducer.class);
    private static final List<Integer> SUPPORTED_EVENTS = Arrays.asList(8, 11, 24, 26, 33);
    private ConnectionFactory connectionFactory;
    private Queue queue;
    private boolean transacted = true;

    public AsyncAuditLogProducer(WorkingMemory workingMemory, boolean transacted) {
        super(workingMemory);
        this.transacted = transacted;
    }

    public AsyncAuditLogProducer(KnowledgeRuntimeEventManager session, boolean transacted) {
        super(session);
        this.transacted = transacted;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public Queue getQueue() {
        return this.queue;
    }

    public void setQueue(Queue queue) {
        this.queue = queue;
    }

    public void logEventCreated(LogEvent logEvent) {
        if (SUPPORTED_EVENTS.contains(logEvent.getType())) {
            this.sendMessage(logEvent);
        }
    }

    protected void sendMessage(Object messageContent) {
        if (this.connectionFactory == null && this.queue == null) {
            throw new IllegalStateException("ConnectionFactory and Queue cannot be null");
        }
        Connection queueConnection = null;
        Session queueSession = null;
        MessageProducer producer = null;
        try {
            queueConnection = this.connectionFactory.createConnection();
            queueSession = queueConnection.createSession(this.transacted, 1);
            XStream xstream = new XStream();
            String eventXml = xstream.toXML(messageContent);
            TextMessage message = queueSession.createTextMessage(eventXml);
            producer = queueSession.createProducer((Destination)this.queue);
            producer.send((Message)message);
        }
        catch (Exception e) {
            throw new RuntimeException("Error when sending JMS message with working memory event", e);
        }
        finally {
            if (producer != null) {
                try {
                    producer.close();
                }
                catch (JMSException e) {
                    logger.warn("Error when closing producer", (Throwable)e);
                }
            }
            if (queueSession != null) {
                try {
                    queueSession.close();
                }
                catch (JMSException e) {
                    logger.warn("Error when closing queue session", (Throwable)e);
                }
            }
            if (queueConnection != null) {
                try {
                    queueConnection.close();
                }
                catch (JMSException e) {
                    logger.warn("Error when closing queue connection", (Throwable)e);
                }
            }
        }
    }
}

